/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public class DiscriminatorMapping
extends SingleFieldMapping {
    private final JavaTypeMapping delegate;

    public DiscriminatorMapping(DatastoreAdapter dba, DatastoreContainerObject datastoreContainer, JavaTypeMapping delegate) {
        ColumnMetaData colmd;
        this.initialize(dba, delegate.getType());
        this.datastoreContainer = datastoreContainer;
        this.delegate = delegate;
        DiscriminatorMetaData dismd = datastoreContainer.getDiscriminatorMetaData();
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier id = null;
        if (dismd.getColumnMetaData() == null) {
            id = idFactory.newDiscriminatorFieldIdentifier();
            colmd = new ColumnMetaData();
            colmd.setName(id.getIdentifierName());
            dismd.setColumnMetaData(colmd);
        } else {
            colmd = dismd.getColumnMetaData();
            if (colmd.getName() == null) {
                id = idFactory.newDiscriminatorFieldIdentifier();
                colmd.setName(id.getIdentifierName());
            } else {
                id = idFactory.newDatastoreFieldIdentifier(colmd.getName());
            }
        }
        DatastoreField column = datastoreContainer.addDatastoreField(this.getType(), id, this, dismd.getColumnMetaData());
        datastoreContainer.getStoreManager().getMappingManager().createDatastoreMapping(delegate, column, this.getType());
    }

    public Class getJavaType() {
        return DiscriminatorMapping.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return this.delegate.getSampleValue(clr);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        Object valueObj = value;
        if (value instanceof String && (this.getType().equals(ClassNameConstants.LONG) || this.getType().equals(ClassNameConstants.JAVA_LANG_LONG))) {
            valueObj = new Long((String)value);
        }
        return this.delegate.newLiteral(qs, valueObj);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return this.delegate.newScalarExpression(qs, te);
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        Object valueObj = value;
        if (value instanceof String && (this.getType().equals(ClassNameConstants.LONG) || this.getType().equals(ClassNameConstants.JAVA_LANG_LONG))) {
            valueObj = new Long((String)value);
        }
        this.delegate.setObject(om, preparedStatement, exprIndex, valueObj);
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        Object value;
        Object valueObj = value = this.delegate.getObject(om, resultSet, exprIndex);
        if (value instanceof String && (this.getType().equals(ClassNameConstants.LONG) || this.getType().equals(ClassNameConstants.JAVA_LANG_LONG))) {
            valueObj = new Long((String)value);
        }
        return valueObj;
    }

    public int getNumberOfDatastoreFields() {
        return this.delegate.getNumberOfDatastoreFields();
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        return this.delegate.getDataStoreMapping(index);
    }

    public DatastoreMapping[] getDataStoreMappings() {
        return this.delegate.getDataStoreMappings();
    }

    public void addDataStoreMapping(DatastoreMapping datastoreMapping) {
        this.delegate.addDataStoreMapping(datastoreMapping);
    }
}

