/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOCollection;
import org.datanucleus.sco.SCOContainer;
import org.datanucleus.sco.SCOMap;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.sco.UnsetOwners;
import org.datanucleus.state.AbstractStateManager;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.AttachFieldManager;
import org.datanucleus.store.fieldmanager.CachePopulateFieldManager;
import org.datanucleus.store.fieldmanager.CacheRetrieveFieldManager;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.DetachFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.LoadFieldManager;
import org.datanucleus.store.fieldmanager.MakeTransientFieldManager;
import org.datanucleus.store.fieldmanager.NullifyRelationFieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.fieldmanager.ReachabilityFieldManager;
import org.datanucleus.store.fieldmanager.SingleTypeFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.objectvaluegenerator.ObjectValueGenerator;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public final class JDOStateManagerImpl
extends AbstractStateManager
implements javax.jdo.spi.StateManager {
    private static final JDOImplHelper HELPER;
    private static final SingleTypeFieldManager HOLLOWFIELDMANAGER;
    private static final byte MISC_RETRIEVING_DETACHED_STATE = -128;
    private static final byte MISC_RESETTING_DETACHED_STATE = 64;
    private static final byte MISC_UPDATING_EMBEDDING_FIELDS_WITH_OWNER = 32;
    private static final byte MISC_ATTACHING = 16;
    private static final byte MISC_DETACHING = 8;
    private static final byte MISC_MAKING_TRANSIENT = 4;
    private static final byte MISC_FLUSHING = 2;
    private static final byte MISC_DISCONNECTING = 1;
    private byte operationalFlags;
    private byte jdoDfgFlags;
    private byte savedFlags;
    private PersistenceCapable savedImage = null;
    private boolean[] savedLoadedFields = null;
    private boolean flushedNew = false;
    private ActivityState activity = ActivityState.NONE;
    private boolean changingState = false;
    private boolean postLoadPending = false;
    private PersistenceCapable referencedPC = null;
    private List<StateManager> insertionNotifyList = null;
    private Map<javax.jdo.spi.StateManager, FieldContainer> fieldsToBeUpdatedAfterObjectInsertion = null;
    private List<EmbeddedOwnerRelation> embeddedOwners = null;
    private RelationshipManager relationManager;
    private HashMap associatedValuesMap = null;
    boolean loadingFieldsInFetchPlan = false;
    private boolean updatingForPostInsert = false;
    boolean[] preDeleteLoadedFields = null;
    private boolean storingPC = false;

    public JDOStateManagerImpl(ObjectManager om, AbstractClassMetaData cmd) {
        super(om, cmd);
    }

    public void initialiseForHollow(Object id, FieldValues fv, Class pcClass) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoDfgFlags = 1;
        if (id instanceof OID || id == null) {
            this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
        } else {
            this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this, this.myID);
            this.markPKFieldsAsLoaded();
        }
        if (fv != null) {
            this.loadFieldValues(fv);
        }
    }

    public void initialiseForHollowAppId(FieldValues fv, Class pcClass) {
        if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusUserException("This constructor is only for objects using application identity.").setFatal();
        }
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoDfgFlags = 1;
        this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
        if (this.myPC == null) {
            if (!HELPER.getRegisteredClasses().contains(pcClass)) {
                throw new NucleusUserException(LOCALISER.msg("026018", (Object)pcClass.getName())).setFatal();
            }
            throw new NucleusUserException(LOCALISER.msg("026019", (Object)pcClass.getName())).setFatal();
        }
        this.loadFieldValues(fv);
        this.myID = this.myPC.jdoNewObjectIdInstance();
        if (!this.cmd.usesSingleFieldIdentityClass()) {
            this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
        }
    }

    public void initialiseForHollowPreConstructed(Object id, Object pc) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4);
        this.jdoDfgFlags = 1;
        this.myPC = (PersistenceCapable)pc;
        this.replaceStateManager(this.myPC, this);
        this.myPC.jdoReplaceFlags();
    }

    public void initialiseForPersistentClean(Object id, Object pc) {
        this.myID = id;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoDfgFlags = 1;
        this.myPC = (PersistenceCapable)pc;
        this.replaceStateManager(this.myPC, this);
        this.myPC.jdoReplaceFlags();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myOM.putObjectIntoCache(this);
    }

    public void initialiseForEmbedded(Object pc, boolean copyPc) {
        this.pcObjectType = 1;
        this.myID = null;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoDfgFlags = 1;
        this.myPC = (PersistenceCapable)pc;
        this.replaceStateManager(this.myPC, this);
        if (copyPc) {
            PersistenceCapable pcCopy = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
            pcCopy.jdoCopyFields((Object)this.myPC, this.getAllFieldNumbers());
            this.replaceStateManager(pcCopy, this);
            this.myPC = pcCopy;
            this.disconnectClone((PersistenceCapable)pc);
        }
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForPersistentNew(Object pc, FieldValues preInsertChanges) {
        ClassLoaderResolver clr;
        int[] relationPositions;
        this.myPC = (PersistenceCapable)pc;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        this.jdoDfgFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this.myPC, this);
        this.myPC.jdoReplaceFlags();
        this.saveFields();
        this.populateStrategyFields();
        if (preInsertChanges != null) {
            preInsertChanges.fetchFields(this);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            for (int fieldNumber = 0; fieldNumber < this.getAllFieldNumbers().length; ++fieldNumber) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!fmd.isPrimaryKey() || this.myOM.getMetaDataManager().getMetaDataForClass(fmd.getType(), this.getObjectManager().getClassLoaderResolver()) == null) continue;
                Object object = this.currFMmonitor;
                synchronized (object) {
                    Object var9_11;
                    FieldManager prevFM = this.currFM;
                    try {
                        this.currFM = new SingleValueFieldManager();
                        this.myPC.jdoProvideField(fieldNumber);
                        PersistenceCapable pkFieldPC = (PersistenceCapable)((SingleValueFieldManager)this.currFM).fetchObjectField(fieldNumber);
                        if (pkFieldPC == null) {
                            throw new NucleusUserException(LOCALISER.msg("026016", (Object)fmd.getFullFieldName()));
                        }
                        if (!this.myOM.getApiAdapter().isPersistent(pkFieldPC)) {
                            this.myOM.persistObjectInternal(pkFieldPC, null, null, -1, 0);
                        }
                        var9_11 = null;
                        this.currFM = prevFM;
                    }
                    catch (Throwable throwable) {
                        var9_11 = null;
                        this.currFM = prevFM;
                        throw throwable;
                    }
                }
            }
        }
        this.setIdentity(false);
        if (this.getObjectManager().getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
        this.getCallbackHandler().postCreate(this.myPC);
        if (this.myOM.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && (relationPositions = this.cmd.getRelationMemberPositions(clr = this.myOM.getClassLoaderResolver())) != null) {
            for (int i = 0; i < relationPositions.length; ++i) {
                Object value;
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(relationPositions[i]);
                int relationType = mmd.getRelationType(clr);
                if (relationType != 2 && relationType != 6 && relationType != 4 && relationType != 5 || (value = this.provideField(relationPositions[i])) == null) continue;
                if (this.relationManager == null) {
                    this.relationManager = new RelationshipManager(this);
                }
                this.relationManager.relationChange(relationPositions[i], null, null);
            }
        }
    }

    public void initialiseForTransactionalTransient(Object pc) {
        this.myPC = (PersistenceCapable)pc;
        this.myLC = null;
        this.jdoDfgFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceFlags();
        this.populateStrategyFields();
        this.setIdentity(false);
        if (this.myOM.getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
    }

    public void initialiseForDetached(Object pc, Object id, Object version) {
        this.myID = id;
        this.myPC = (PersistenceCapable)pc;
        this.setVersion(version);
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(11);
        this.myPC.jdoReplaceFlags();
        this.replaceStateManager(this.myPC, this);
    }

    public void initialiseForPNewToBeDeleted(Object pc) {
        this.myID = null;
        this.myPC = (PersistenceCapable)pc;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(1);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this.myPC, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForCachedPC(CachedPC cachedPC, Object id, Class pcClass) {
        Object cachePC;
        this.initialiseForHollow(id, null, pcClass);
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(2);
        this.jdoDfgFlags = (byte)-1;
        Object object = cachePC = cachedPC.getPersistableObject();
        synchronized (object) {
            int[] fieldsToLoad = JDOStateManagerImpl.getFlagsSetTo(cachedPC.getLoadedFields(), this.getAllFieldNumbers(), true);
            if (fieldsToLoad != null) {
                JDOStateManagerImpl cacheSM = new JDOStateManagerImpl(this.myOM, this.cmd);
                cacheSM.initialiseForDetached(cachePC, this.getExternalObjectId(this.myPC), this.getVersion(this.myPC));
                this.myOM.putObjectIntoCache(this);
                this.replaceFields(fieldsToLoad, new CacheRetrieveFieldManager(cacheSM, cachedPC));
                this.disconnectClone((PersistenceCapable)cachePC);
            }
            for (int i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = cachedPC.getLoadedFields()[i];
            }
            if (cachedPC.getVersion() != null) {
                this.setVersion(cachedPC.getVersion());
            }
            this.replaceAllLoadedSCOFieldsWithWrappers();
        }
        if (this.myOM.getTransaction().isActive()) {
            this.myOM.enlistInTransaction(this);
        }
        if (this.isFetchPlanLoaded()) {
            this.postLoad();
        }
    }

    public CachedPC cache() {
        int[] loadedFieldNumbers = this.getLoadedFieldNumbers();
        if (loadedFieldNumbers == null || loadedFieldNumbers.length == 0) {
            return null;
        }
        PersistenceCapable cachePC = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this, this.myPC.jdoGetObjectId());
        CachedPC cachedPC = new CachedPC(cachePC, this.getLoadedFields(), this.getTransactionalVersion(this.myPC));
        JDOStateManagerImpl cacheSM = new JDOStateManagerImpl(this.myOM, this.cmd);
        cacheSM.initialiseForDetached(cachePC, this.getExternalObjectId(this.myPC), this.getVersion(this.myPC));
        cacheSM.replaceFields(this.getLoadedFieldNumbers(), new CachePopulateFieldManager(this, cachedPC));
        this.replaceStateManager(cachePC, null);
        return cachedPC;
    }

    public void checkInheritance(FieldValues fv) {
        ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
        String className = this.getStoreManager().getClassNameForObjectID(this.myID, clr, this.myOM);
        if (className == null) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("026013", (Object)this.myOM.getIdentityAsString(this.myID)), this.myID);
        }
        if (!this.cmd.getFullClassName().equals(className)) {
            Class pcClass;
            try {
                pcClass = clr.classForName(className, this.myID.getClass().getClassLoader(), true);
                this.cmd = this.myOM.getMetaDataManager().getMetaDataForClass(pcClass, clr);
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("026014", (Object)this.myOM.getIdentityAsString(this.myID)));
                throw new NucleusUserException(LOCALISER.msg("026014", (Object)this.myOM.getIdentityAsString(this.myID)), e);
            }
            if (this.cmd == null) {
                throw new NucleusUserException(LOCALISER.msg("026012", pcClass)).setFatal();
            }
            if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
                throw new NucleusUserException("This method should only be used for objects using application identity.").setFatal();
            }
            this.myFP = this.myOM.getFetchPlan().manageFetchPlanForClass(this.cmd);
            this.initialiseFieldInformation();
            this.myPC = HELPER.newInstance(pcClass, (javax.jdo.spi.StateManager)this);
            if (this.myPC == null) {
                throw new NucleusUserException(LOCALISER.msg("026018", (Object)this.cmd.getFullClassName())).setFatal();
            }
            this.loadFieldValues(fv);
            this.myID = this.myPC.jdoNewObjectIdInstance();
            if (!this.cmd.usesSingleFieldIdentityClass()) {
                this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
            }
        }
    }

    private void populateStrategyFields() {
        int totalFieldCount = this.cmd.getNoOfInheritedManagedMembers() + this.cmd.getNoOfManagedMembers();
        for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            IdentityStrategy strategy = mmd.getValueStrategy();
            if (strategy != null && !this.getStoreManager().isStrategyDatastoreAttributed(strategy, false)) {
                boolean applyStrategy = true;
                if (!mmd.getType().isPrimitive() && strategy != null && mmd.hasExtension("strategy-when-notnull") && mmd.getValueForExtension("strategy-when-notnull").equalsIgnoreCase("false") && this.provideField(fieldNumber) != null) {
                    applyStrategy = false;
                }
                if (!applyStrategy) continue;
                Object obj = this.getStoreManager().getStrategyValue(this.myOM, this.cmd, fieldNumber);
                this.replaceField(fieldNumber, obj, true);
                continue;
            }
            if (!mmd.hasExtension("object-value-generator")) continue;
            String valGenName = mmd.getValueForExtension("object-value-generator");
            try {
                ObjectValueGenerator valGen = (ObjectValueGenerator)this.myOM.getOMFContext().getPluginManager().createExecutableExtension("org.datanucleus.store_objectvaluegenerator", new String[]{"name"}, new String[]{mmd.getValueForExtension("object-value-generator")}, "class-name", null, null);
                Object value = valGen.generate(this.myOM, this.myPC, mmd.getExtensions());
                this.replaceField(fieldNumber, value, true);
                continue;
            }
            catch (Exception e) {
                NucleusLogger.JDO.info("Exception thrown generating value using objectvaluegenerator " + valGenName, e);
                throw new NucleusException("Exception thrown generating value for object", e);
            }
        }
    }

    public void loadFieldValues(FieldValues fv) {
        FetchPlan.FetchPlanForClass origFetchPlan = this.myFP;
        FetchPlan loadFetchPlan = fv.getFetchPlanForLoading();
        if (loadFetchPlan != null) {
            this.myFP = loadFetchPlan.manageFetchPlanForClass(this.cmd);
        }
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        if (this.loadedFields.length == 0) {
            callPostLoad = true;
        }
        fv.fetchFields(this);
        if (callPostLoad && this.isFetchPlanLoaded() && this.myOM.getOMFContext().getApi().equalsIgnoreCase("JDO")) {
            this.postLoad();
        }
        this.myFP = origFetchPlan;
    }

    private void setIdentity(boolean afterPreStore) {
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (this.cmd.getIdentityMetaData() == null || !this.getStoreManager().isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), true)) {
                this.myID = this.myOM.newObjectId(this.cmd.getFullClassName(), (Object)this.myPC);
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            boolean idSetInDatastore = false;
            int totalFieldCount = this.cmd.getNoOfInheritedManagedMembers() + this.cmd.getNoOfManagedMembers();
            for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!fmd.isPrimaryKey()) continue;
                if (this.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) {
                    idSetInDatastore = true;
                    break;
                }
                if (!this.cmd.usesSingleFieldIdentityClass() || this.provideField(fieldNumber) != null) continue;
                if (afterPreStore) {
                    throw new NucleusUserException(LOCALISER.msg("026017", (Object)this.cmd.getFullClassName(), (Object)fmd.getName())).setFatal();
                }
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026017", (Object)this.cmd.getFullClassName(), (Object)fmd.getName()));
                return;
            }
            if (!idSetInDatastore) {
                this.myID = this.myOM.newObjectId(this.cmd.getFullClassName(), (Object)this.myPC);
            }
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myOM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public void replaceManagedPC(PersistenceCapable pc) {
        if (pc == null) {
            return;
        }
        this.replaceStateManager(pc, this);
        this.replaceStateManager(this.myPC, null);
        this.myPC = pc;
        this.myOM.putObjectIntoCache(this);
    }

    public void copyFieldsFromObject(PersistenceCapable pc, int[] fieldNumbers) {
        if (pc == null) {
            return;
        }
        if (!pc.getClass().getName().equals(this.myPC.getClass().getName())) {
            return;
        }
        this.replaceStateManager(pc, this);
        this.myPC.jdoCopyFields((Object)pc, fieldNumbers);
        this.replaceStateManager(pc, null);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = true;
        }
    }

    private void replaceStateManager(final PersistenceCapable pc, final javax.jdo.spi.StateManager sm) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    pc.jdoReplaceStateManager(sm);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
        }
    }

    public void enlistInTransaction() {
        if (!this.getObjectManager().getTransaction().isActive()) {
            return;
        }
        this.myOM.enlistInTransaction(this);
        if (this.jdoDfgFlags == 1 && this.isDefaultFetchGroupLoaded()) {
            this.jdoDfgFlags = (byte)-1;
            this.myPC.jdoReplaceFlags();
        }
    }

    public void evictFromTransaction() {
        this.myOM.evictFromTransaction(this);
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
    }

    public void saveFields() {
        this.savedImage = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        this.savedImage.jdoCopyFields((Object)this.myPC, this.getAllFieldNumbers());
        this.savedFlags = this.jdoDfgFlags;
        this.savedLoadedFields = (boolean[])this.loadedFields.clone();
    }

    public void restoreFields() {
        if (this.savedImage != null) {
            this.loadedFields = this.savedLoadedFields;
            this.jdoDfgFlags = this.savedFlags;
            this.myPC.jdoReplaceFlags();
            this.myPC.jdoCopyFields((Object)this.savedImage, this.getAllFieldNumbers());
            this.clearDirtyFlags();
            this.clearSavedFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
            Object var2_1 = null;
            this.clearFieldsByNumbers(this.getAllFieldNumbers());
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearFieldsByNumbers(this.getAllFieldNumbers());
            this.clearDirtyFlags();
            this.getStoreManager().notifyObjectIsOutdated(this);
            this.jdoDfgFlags = 1;
            this.myPC.jdoReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
            throw throwable;
        }
        this.clearDirtyFlags();
        this.getStoreManager().notifyObjectIsOutdated(this);
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        this.getCallbackHandler().postClear(this.myPC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonPrimaryKeyFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
            Object var2_1 = null;
            this.clearFieldsByNumbers(this.getNonPrimaryKeyFieldNumbers());
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearFieldsByNumbers(this.getNonPrimaryKeyFieldNumbers());
            this.clearDirtyFlags(this.getNonPrimaryKeyFieldNumbers());
            this.getStoreManager().notifyObjectIsOutdated(this);
            this.jdoDfgFlags = 1;
            this.myPC.jdoReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
            throw throwable;
        }
        this.clearDirtyFlags(this.getNonPrimaryKeyFieldNumbers());
        this.getStoreManager().notifyObjectIsOutdated(this);
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        this.getCallbackHandler().postClear(this.myPC);
    }

    private void clearFieldsByNumbers(int[] fieldNumbers) {
        this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = false;
            this.dirtyFields[fieldNumbers[i]] = false;
        }
    }

    public void clearSavedFields() {
        this.savedImage = null;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
    }

    public void clearLoadedFlags() {
        this.getStoreManager().notifyObjectIsOutdated(this);
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        JDOStateManagerImpl.clearFlags(this.loadedFields);
    }

    public void makeDirty(int field) {
        if (this.activity != ActivityState.DELETING) {
            boolean wasDirty = this.preWriteField(field);
            this.postWriteField(wasDirty);
        }
    }

    public void makeDirty(PersistenceCapable pc, String fieldName) {
        if (!this.disconnectClone(pc)) {
            int fieldNumber = this.cmd.getAbsolutePositionOfMember(fieldName);
            if (fieldNumber == -1) {
                throw new JDOUserException(LOCALISER.msg("026002", (Object)fieldName, (Object)this.cmd.getFullClassName()));
            }
            this.makeDirty(fieldNumber);
        }
    }

    public PersistenceManager getPersistenceManager(PersistenceCapable pc) {
        if (this.myPC != null && this.disconnectClone(pc)) {
            return null;
        }
        if (this.myOM == null) {
            return null;
        }
        this.myOM.hereIsStateManager(this, this.myPC);
        return (PersistenceManager)this.myOM.getOwner();
    }

    public Object getObjectId(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return null;
        }
        return this.getExternalObjectId(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostStoreNewObjectId(Object id) {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            this.myID = id instanceof OID ? id : OIDFactory.getInstance(this.myOM, this.cmd.getFullClassName(), id);
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                try {
                    this.myID = null;
                    int fieldCount = this.getHighestFieldNumber();
                    for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                        AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                        if (!fmd.isPrimaryKey() || !this.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) continue;
                        this.replaceField(fieldNumber, TypeConversionHelper.convertTo(id, fmd.getType()), true);
                    }
                    Object var6_6 = null;
                    this.myID = this.myOM.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.error(e);
                    Object var6_7 = null;
                    this.myID = this.myOM.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.myID = this.myOM.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
                throw throwable;
            }
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myOM.replaceObjectId(this.myPC, this.myInternalID, this.myID);
        }
    }

    public Object getExternalObjectId(Object obj) {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if ((this.operationalFlags & 2) == 0 && !this.flushedNew && this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS && this.myLC.stateType() == 1 && this.getStoreManager().isStrategyDatastoreAttributed(this.cmd.getIdentityMetaData().getValueStrategy(), true)) {
                this.flush();
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            if ((this.operationalFlags & 2) == 0 && !this.flushedNew && this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS && this.myLC.stateType() == 1) {
                int[] pkFieldNumbers = this.cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
                    if (!this.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false)) continue;
                    this.flush();
                    break;
                }
            }
            if (this.cmd.usesSingleFieldIdentityClass()) {
                return this.myID;
            }
            return this.myOM.getApiAdapter().getNewApplicationIdentityObjectId(this.myPC, this.cmd);
        }
        return this.myID;
    }

    public javax.jdo.spi.StateManager replacingStateManager(PersistenceCapable pc, javax.jdo.spi.StateManager sm) {
        if (this.myLC == null) {
            throw new JDOFatalInternalException("Null LifeCycleState");
        }
        if (this.myLC.stateType() == 11) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myOM == ((AbstractStateManager)sm).myOM) {
                ((JDOStateManagerImpl)sm).disconnect();
                return this;
            }
            if (sm != null) {
                throw new JDOUserException(LOCALISER.msg("026003"));
            }
            if ((this.operationalFlags & 1) == 0) {
                throw new JDOUserException(LOCALISER.msg("026004"));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026005", (Object)StringUtils.toJVMIDString(pc)));
            }
            return null;
        }
        if (pc == this.savedImage) {
            return null;
        }
        return sm;
    }

    public Object getTransactionalObjectId(PersistenceCapable pc) {
        return this.getObjectId(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLevel2CacheForFields(int[] fieldNumbers) {
        Level2Cache l2cache = this.myOM.getObjectManagerFactory().getLevel2Cache();
        if (l2cache != null && this.cmd.isCacheable() && !this.myOM.isObjectModifiedInTransaction(this.myID)) {
            Level2Cache level2Cache = l2cache;
            synchronized (level2Cache) {
                int[] cacheFieldsToLoad;
                CachedPC cachedPC = l2cache.get(this.myID);
                if (cachedPC != null && (cacheFieldsToLoad = JDOStateManagerImpl.getFlagsSetTo(cachedPC.getLoadedFields(), fieldNumbers, false)) != null && cacheFieldsToLoad.length > 0) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("026033", (Object)StringUtils.toJVMIDString(this.myPC), this.myID, (Object)StringUtils.intArrayToString(cacheFieldsToLoad)));
                    Object cachePC = cachedPC.getPersistableObject();
                    JDOStateManagerImpl cacheSM = new JDOStateManagerImpl(this.myOM, this.cmd);
                    cacheSM.initialiseForDetached(cachePC, this.getExternalObjectId(this.myPC), this.getVersion(this.myPC));
                    cacheSM.replaceFields(cacheFieldsToLoad, new CachePopulateFieldManager(this, cachedPC));
                    this.replaceStateManager((PersistenceCapable)cachePC, null);
                }
            }
        }
    }

    private void loadSCONonContainerFields() {
        int[] noncontainerFieldNumbers = this.cmd.getSCONonContainerMemberPositions();
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, noncontainerFieldNumbers, false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
            this.updateLevel2CacheForFields(fieldNumbers);
        }
    }

    protected void loadSpecifiedFields(int[] fieldNumbers) {
        if (this.myOM.getApiAdapter().isDetached(this.myPC)) {
            return;
        }
        if (!this.isEmbedded()) {
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
        }
    }

    public void loadField(int fieldNumber) {
        if (this.loadedFields[fieldNumber]) {
            return;
        }
        this.loadSpecifiedFields(new int[]{fieldNumber});
    }

    public void loadUnloadedFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), false);
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        if (this.preDeleteLoadedFields != null && (this.myLC.isDeleted && this.myOM.isFlushing() || this.activity == ActivityState.DELETING)) {
            fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.preDeleteLoadedFields, fieldNumbers, false);
        }
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
            int[] secondClassMutableFieldNumbers = this.getSecondClassMutableFieldNumbers();
            for (int i = 0; i < secondClassMutableFieldNumbers.length; ++i) {
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if (this.loadingFieldsInFetchPlan) {
            return;
        }
        this.loadingFieldsInFetchPlan = true;
        this.loadUnloadedFieldsInFetchPlan();
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state));
            this.updateLevel2CacheForFields(fieldNumbers);
        }
        this.loadingFieldsInFetchPlan = false;
    }

    public void loadUnloadedFieldsInFetchPlan() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    public void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan fetchPlan) {
        FetchPlan.FetchPlanForClass fpc = fetchPlan.manageFetchPlanForClass(this.cmd);
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, fpc.getFieldsInActualFetchPlan(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = fpc.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    public void unloadField(String fieldName) {
        if (this.pcObjectType != 0) {
            throw new NucleusUserException("Cannot unload field/property of embedded object");
        }
        AbstractMemberMetaData mmd = this.getClassMetaData().getMetaDataForMember(fieldName);
        this.loadedFields[mmd.getAbsoluteFieldNumber()] = false;
    }

    protected void markPKFieldsAsLoaded() {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                this.loadedFields[pkPositions[i]] = true;
            }
        }
    }

    public void refreshFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags(fieldNumbers);
            JDOStateManagerImpl.clearFlags(this.loadedFields, fieldNumbers);
            this.markPKFieldsAsLoaded();
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.setTransactionalVersion(null);
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
            if (this.cmd.hasRelations(this.myOM.getClassLoaderResolver())) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    Object value;
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    int relationType = fmd.getRelationType(this.myOM.getClassLoaderResolver());
                    if (relationType == 0 || !fmd.isCascadeRefresh() || (value = this.provideField(fieldNumbers[i])) == null) continue;
                    if (value instanceof Collection) {
                        SCOUtils.refreshFetchPlanFieldsForCollection(this, ((Collection)value).toArray());
                        continue;
                    }
                    if (value instanceof Map) {
                        SCOUtils.refreshFetchPlanFieldsForMap(this, ((Map)value).entrySet());
                        continue;
                    }
                    if (!(value instanceof PersistenceCapable)) continue;
                    this.myOM.refreshObject(value);
                }
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.getCallbackHandler().postRefresh(this.myPC);
        }
    }

    public void refreshLoadedFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags();
            JDOStateManagerImpl.clearFlags(this.loadedFields);
            this.markPKFieldsAsLoaded();
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    public void unloadNonFetchPlanFields() {
        int[] fpFieldNumbers = this.myFP.getFieldsInActualFetchPlan();
        int[] nonfpFieldNumbers = null;
        if (fpFieldNumbers == null || fpFieldNumbers.length == 0) {
            nonfpFieldNumbers = this.getAllFieldNumbers();
        } else {
            int fieldCount = this.getHighestFieldNumber();
            if (fieldCount == fpFieldNumbers.length) {
                return;
            }
            nonfpFieldNumbers = new int[fieldCount - fpFieldNumbers.length];
            int currentFPFieldIndex = 0;
            int j = 0;
            for (int i = 0; i < fieldCount; ++i) {
                if (currentFPFieldIndex >= fpFieldNumbers.length) {
                    nonfpFieldNumbers[j++] = i;
                    continue;
                }
                if (fpFieldNumbers[currentFPFieldIndex] == i) {
                    ++currentFPFieldIndex;
                    continue;
                }
                nonfpFieldNumbers[j++] = i;
            }
        }
        for (int i = 0; i < nonfpFieldNumbers.length; ++i) {
            this.loadedFields[nonfpFieldNumbers[i]] = false;
        }
    }

    public void loadFieldFromDatastore(int fieldNumber) {
        this.getStoreManager().getPersistenceHandler().fetchObject(this, new int[]{fieldNumber});
    }

    public boolean isLoaded(PersistenceCapable pc, int field) {
        try {
            if (this.disconnectClone(pc)) {
                return true;
            }
            boolean checkRead = true;
            boolean beingDeleted = false;
            if (this.myLC.isDeleted && this.myOM.isFlushing() || this.activity == ActivityState.DELETING) {
                checkRead = false;
                beingDeleted = true;
            }
            if (checkRead) {
                this.transitionReadField(this.loadedFields[field]);
            }
            if (!this.loadedFields[field]) {
                if (this.pcObjectType != 0) {
                    return true;
                }
                if (beingDeleted && this.preDeleteLoadedFields != null && this.preDeleteLoadedFields[field]) {
                    return true;
                }
                if (!beingDeleted && this.myFP.isFieldInActualFetchPlan(field)) {
                    this.loadUnloadedFieldsInFetchPlan();
                } else {
                    this.loadSpecifiedFields(new int[]{field});
                }
            }
            return true;
        }
        catch (NucleusException ne) {
            NucleusLogger.PERSISTENCE.warn("Exception thrown by StateManager.isLoaded", ne);
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    private void writeField(int field, Object newValue) {
        this.replaceField(field, newValue, true);
    }

    public void setBooleanField(PersistenceCapable pc, int field, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue ? Boolean.TRUE : Boolean.FALSE);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
        }
    }

    public void setByteField(PersistenceCapable pc, int field, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Byte(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Byte(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Byte(newValue), true);
        }
    }

    public void setCharField(PersistenceCapable pc, int field, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Character(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Character(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Character(newValue), true);
        }
    }

    public void setDoubleField(PersistenceCapable pc, int field, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Double(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Double(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Double(newValue), true);
        }
    }

    public void setFloatField(PersistenceCapable pc, int field, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Float(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Float(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Float(newValue), true);
        }
    }

    public void setIntField(PersistenceCapable pc, int field, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Integer(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Integer(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Integer(newValue), true);
        }
    }

    public void setLongField(PersistenceCapable pc, int field, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Long(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Long(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Long(newValue), true);
        }
    }

    public void setShortField(PersistenceCapable pc, int field, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, new Short(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, new Short(newValue));
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, new Short(newValue), true);
        }
    }

    public void setStringField(PersistenceCapable pc, int field, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (!this.loadedFields[field] || !JDOStateManagerImpl.equals(currentValue, newValue)) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(field, newValue, true);
        }
    }

    public void setObjectField(PersistenceCapable pc, int field, Object currentValue, Object newValue) {
        JDOStateManagerImpl currentSM;
        if (currentValue != null && currentValue != newValue && currentValue instanceof PersistenceCapable && (currentSM = (JDOStateManagerImpl)this.myOM.findStateManager(currentValue)) != null && currentSM.isEmbedded()) {
            currentSM.removeEmbeddedOwner(this, field);
        }
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            boolean loadedOldValue = false;
            Object oldValue = currentValue;
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(field);
            ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
            int relationType = fmd.getRelationType(clr);
            if (!this.loadedFields[field] && currentValue == null) {
                if (this.myOM.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && (relationType == 2 || relationType == 6)) {
                    this.loadField(field);
                    loadedOldValue = true;
                    oldValue = this.provideField(field);
                }
                if (relationType != 0 && fmd.isDependent() && newValue == null) {
                    this.loadField(field);
                    loadedOldValue = true;
                    oldValue = this.provideField(field);
                }
            }
            boolean equal = false;
            if (oldValue == null && newValue == null) {
                equal = true;
            } else if (oldValue != null && newValue != null) {
                if (oldValue instanceof PersistenceCapable) {
                    if (oldValue == newValue) {
                        equal = true;
                    }
                } else if (oldValue.equals(newValue)) {
                    equal = true;
                }
            }
            if (!this.loadedFields[field] || !equal || fmd.hasArray()) {
                SCO sco;
                Object owner;
                boolean wasDirty = this.preWriteField(field);
                if (oldValue instanceof SCO) {
                    if (oldValue instanceof SCOContainer) {
                        ((SCOContainer)oldValue).load();
                    }
                    ((SCO)oldValue).unsetOwner();
                }
                if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                    throw new JDOUserException(LOCALISER.msg("026007", (Object)sco.getFieldName(), owner));
                }
                this.writeField(field, newValue);
                this.postWriteField(wasDirty);
            } else if (loadedOldValue) {
                boolean wasDirty = this.preWriteField(field);
                this.writeField(field, newValue);
                this.postWriteField(wasDirty);
            }
            if (!equal && this.myOM.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && (relationType == 2 || relationType == 6 || relationType == 4 || relationType == 5)) {
                if (this.relationManager == null) {
                    this.relationManager = new RelationshipManager(this);
                }
                this.relationManager.relationChange(field, oldValue, newValue);
            }
            if (fmd.isDependent() && oldValue != null && newValue == null && oldValue instanceof PersistenceCapable) {
                this.flush();
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026026", oldValue, (Object)fmd.getFullFieldName()));
                this.myOM.deleteObjectInternal(oldValue);
            }
        } else {
            this.replaceField(field, newValue, true);
        }
    }

    public RelationshipManager getRelationshipManager() {
        if (this.relationManager == null && this.myOM.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && !this.myOM.isManagingRelations()) {
            this.relationManager = new RelationshipManager(this);
        }
        return this.relationManager;
    }

    public void checkManagedRelations() {
        if (this.myLC == null || this.myLC.isDeleted()) {
            return;
        }
        if (this.relationManager == null) {
            return;
        }
        this.relationManager.checkConsistency();
    }

    public void processManagedRelations() {
        if (this.myLC == null || this.myLC.isDeleted()) {
            return;
        }
        if (this.relationManager == null) {
            return;
        }
        this.relationManager.process();
    }

    public void clearManagedRelations() {
        if (this.relationManager != null) {
            this.relationManager.clearFields();
            this.relationManager = null;
        }
    }

    public void replaceFieldValue(int fieldNumber, Object newValue) {
        if (this.myLC.isDeleted()) {
            return;
        }
        boolean currentWasDirty = this.preWriteField(fieldNumber);
        this.writeField(fieldNumber, newValue);
        this.postWriteField(currentWasDirty);
    }

    public byte replacingFlags(PersistenceCapable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.jdoDfgFlags;
    }

    public Object provideField(int fieldNumber) {
        return this.provideField(this.myPC, fieldNumber);
    }

    public void replaceField(int fieldNumber, Object value, boolean makeDirty) {
        this.replaceField(this.myPC, fieldNumber, value, makeDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object provideField(PersistenceCapable pc, int fieldNumber) {
        Object obj;
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                pc.jdoProvideField(fieldNumber);
                obj = this.currFM.fetchObjectField(fieldNumber);
                Object var7_6 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.currFM = prevFM;
                throw throwable;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceField(PersistenceCapable pc, int fieldNumber, Object value, boolean makeDirty) {
        if (this.embeddedOwners != null) {
            for (EmbeddedOwnerRelation owner : this.embeddedOwners) {
                JDOStateManagerImpl ownerSM = (JDOStateManagerImpl)owner.sm;
                if (ownerSM == null || ownerSM.cmd == null) continue;
                AbstractMemberMetaData ownerFmd = ownerSM.cmd.getMetaDataForManagedMemberAtAbsolutePosition(owner.fieldNumber);
                if (ownerFmd.getCollection() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOCollection)) continue;
                    ((SCOCollection)ownerField).updateEmbeddedElement(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerFmd.getMap() != null) {
                    Object ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOMap)) continue;
                    if (this.pcObjectType == 3) {
                        ((SCOMap)ownerField).updateEmbeddedKey(this.myPC, fieldNumber, value);
                    }
                    if (this.pcObjectType != 4) continue;
                    ((SCOMap)ownerField).updateEmbeddedValue(this.myPC, fieldNumber, value);
                    continue;
                }
                if ((ownerSM.operationalFlags & 0x20) != 0) continue;
                if (ownerSM.isEmbedded()) {
                    ownerSM.replaceField(owner.fieldNumber, pc, makeDirty);
                    continue;
                }
                if (makeDirty) {
                    boolean wasDirty = ownerSM.preWriteField(owner.fieldNumber);
                    ownerSM.replaceField(owner.fieldNumber, pc, true);
                    ownerSM.postWriteField(wasDirty);
                    continue;
                }
                ownerSM.replaceField(owner.fieldNumber, pc, false);
            }
        }
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                this.currFM.storeObjectField(fieldNumber, value);
                pc.jdoReplaceField(fieldNumber);
                Object var11_12 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.currFM = prevFM;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                this.myPC.jdoProvideFields(fieldNumbers);
                Object var6_5 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.currFM = prevFM;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                int[] fieldsToReplace = fieldNumbers;
                if (!replaceWhenDirty) {
                    int numberToReplace = fieldNumbers.length;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (!this.dirtyFields[fieldNumbers[i]]) continue;
                        --numberToReplace;
                    }
                    if (numberToReplace > 0 && numberToReplace != fieldNumbers.length) {
                        fieldsToReplace = new int[numberToReplace];
                        int n = 0;
                        for (int i = 0; i < fieldNumbers.length; ++i) {
                            if (this.dirtyFields[fieldNumbers[i]]) continue;
                            fieldsToReplace[n++] = fieldNumbers[i];
                        }
                    } else if (numberToReplace == 0) {
                        fieldsToReplace = null;
                    }
                }
                if (fieldsToReplace != null) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
                Object var11_10 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.currFM = prevFM;
                throw throwable;
            }
        }
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm) {
        this.replaceFields(fieldNumbers, fm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.currFMmonitor;
        synchronized (object) {
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            try {
                int[] fieldsToReplace = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
                if (fieldsToReplace != null && fieldsToReplace.length > 0) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
                Object var8_7 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.currFM = prevFM;
                throw throwable;
            }
            if (callPostLoad && this.isFetchPlanLoaded()) {
                this.postLoad();
            }
        }
    }

    public void addEmbeddedOwner(StateManager ownerSM, int ownerFieldNumber) {
        if (ownerSM == null) {
            return;
        }
        if (this.embeddedOwners == null) {
            this.embeddedOwners = new ArrayList<EmbeddedOwnerRelation>();
        }
        this.embeddedOwners.add(new EmbeddedOwnerRelation(ownerSM, ownerFieldNumber));
    }

    public void removeEmbeddedOwner(javax.jdo.spi.StateManager ownerSM, int ownerFieldNumber) {
        if (this.embeddedOwners != null) {
            Iterator<EmbeddedOwnerRelation> iter = this.embeddedOwners.iterator();
            while (iter.hasNext()) {
                EmbeddedOwnerRelation relation = iter.next();
                if (relation.sm != ownerSM || relation.fieldNumber != ownerFieldNumber) continue;
                iter.remove();
                break;
            }
        }
    }

    public StateManager[] getEmbeddedOwners() {
        if (this.embeddedOwners == null) {
            return null;
        }
        StateManager[] owners = new StateManager[this.embeddedOwners.size()];
        for (int i = 0; i < owners.length; ++i) {
            EmbeddedOwnerRelation relation = this.embeddedOwners.get(i);
            owners[i] = relation.sm;
        }
        return owners;
    }

    public void replaceAllLoadedSCOFieldsWithWrappers() {
        boolean[] scoMutableFieldFlags = this.cmd.getSCOMutableMemberFlags();
        for (int i = 0; i < scoMutableFieldFlags.length; ++i) {
            Object value;
            if (!scoMutableFieldFlags[i] || !this.loadedFields[i] || (value = this.provideField(i)) instanceof SCO) continue;
            this.wrapSCOField(i, value, false, false, true);
        }
    }

    public void replaceAllLoadedSCOFieldsWithValues() {
        boolean[] scoMutableFieldFlags = this.cmd.getSCOMutableMemberFlags();
        for (int i = 0; i < scoMutableFieldFlags.length; ++i) {
            Object value;
            if (!scoMutableFieldFlags[i] || !this.loadedFields[i] || !((value = this.provideField(i)) instanceof SCO)) continue;
            this.unwrapSCOField(i, value, true);
        }
    }

    public Object unwrapSCOField(int fieldNumber, Object value, boolean replaceFieldIfChanged) {
        if (value == null) {
            return value;
        }
        if (this.getSecondClassMutableFields()[fieldNumber] && value instanceof SCO) {
            SCO sco = (SCO)value;
            Object unwrappedValue = sco.getValue();
            if (replaceFieldIfChanged) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026030", (Object)StringUtils.toJVMIDString(this.myPC), (Object)this.myOM.getIdentityAsString(this.myID), (Object)fmd.getName()));
                }
                this.replaceField(fieldNumber, unwrappedValue, false);
            }
            return unwrappedValue;
        }
        return value;
    }

    public Object wrapSCOField(int fieldNumber, Object value, boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged) {
        AbstractMemberMetaData fmd;
        if (value == null) {
            return value;
        }
        if (value instanceof PersistenceCapable && (fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getEmbeddedMetaData() != null && fmd.getEmbeddedMetaData().getOwnerMember() != null) {
            JDOStateManagerImpl subSM = (JDOStateManagerImpl)this.myOM.findStateManager(value);
            int ownerAbsFieldNum = subSM.cmd.getAbsolutePositionOfMember(fmd.getEmbeddedMetaData().getOwnerMember());
            if (ownerAbsFieldNum >= 0) {
                this.operationalFlags = (byte)(this.operationalFlags | 0x20);
                subSM.replaceField(ownerAbsFieldNum, this.myPC, true);
                this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFDF);
            }
        }
        if (this.getSecondClassMutableFields()[fieldNumber] && (!(value instanceof SCO) || this.myPC != ((SCO)value).getOwner())) {
            fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (replaceFieldIfChanged && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026029", (Object)StringUtils.toJVMIDString(this.myPC), this.myOM != null ? this.myOM.getIdentityAsString(this.myID) : this.myID, (Object)fmd.getName()));
            }
            return SCOUtils.newSCOInstance(this, fmd, fmd.getType(), value != null ? value.getClass() : null, value, forInsert, forUpdate, replaceFieldIfChanged);
        }
        return value;
    }

    public void runReachability(Set reachables) {
        if (reachables == null) {
            return;
        }
        if (!reachables.contains(this.getInternalObjectId())) {
            this.flush();
            if (this.isDeleted(this.myPC)) {
                return;
            }
            if (this.getObjectManager().isEnlistedInTransaction(this.getInternalObjectId())) {
                this.loadUnloadedFields();
            }
            if (NucleusLogger.REACHABILITY.isDebugEnabled()) {
                NucleusLogger.REACHABILITY.debug(LOCALISER.msg("007000", (Object)StringUtils.toJVMIDString(this.myPC), this.getObjectId(this.myPC), (Object)this.myLC));
            }
            reachables.add(this.getInternalObjectId());
            int[] loadedFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), true);
            if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                this.provideFields(loadedFieldNumbers, new ReachabilityFieldManager(this, reachables));
            }
        }
    }

    public void makePersistent() {
        if (this.myLC.isDeleted() && !this.myOM.getOMFContext().getApiAdapter().allowPersistOfDeletedObject()) {
            return;
        }
        if (this.dirty && !this.myLC.isDeleted && this.myLC.isTransactional && this.myOM.isDelayDatastoreOperationsEnabled()) {
            this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
            return;
        }
        this.getCallbackHandler().prePersist(this.myPC);
        if (this.flushedNew) {
            this.registerTransactional();
            return;
        }
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        if (this.myID == null) {
            this.setIdentity(false);
        }
        this.dirty = true;
        if (this.myOM.isDelayDatastoreOperationsEnabled()) {
            this.myOM.markDirty(this, false);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026028", (Object)StringUtils.toJVMIDString(this.myPC)));
            }
            this.registerTransactional();
            if (this.myLC.isTransactional && this.myLC.isDeleted()) {
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
            this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
        } else {
            this.internalMakePersistent();
            this.registerTransactional();
        }
    }

    private void internalMakePersistent() {
        this.activity = ActivityState.INSERTING;
        boolean[] tmpDirtyFields = this.dirtyFields;
        try {
            block5: {
                try {
                    this.getCallbackHandler().preStore(this.myPC);
                    if (this.myID == null) {
                        this.setIdentity(true);
                    }
                    this.clearDirtyFlags();
                    this.getStoreManager().getPersistenceHandler().insertObject(this);
                    this.flushedNew = true;
                    this.getCallbackHandler().postStore(this.myPC);
                    if (this.isEmbedded()) break block5;
                    this.myOM.putObjectIntoCache(this);
                }
                catch (NotYetFlushedException ex) {
                    this.dirtyFields = tmpDirtyFields;
                    this.myOM.markDirty(this, false);
                    this.dirty = true;
                    throw ex;
                }
            }
            Object var4_2 = null;
            this.activity = ActivityState.NONE;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.activity = ActivityState.NONE;
            throw throwable;
        }
    }

    public boolean isInserting() {
        return this.activity == ActivityState.INSERTING;
    }

    public boolean isDeleting() {
        return this.activity == ActivityState.DELETING;
    }

    public boolean isDetaching() {
        return (this.operationalFlags & 8) != 0;
    }

    public boolean isWaitingToBeFlushedToDatastore() {
        return this.myLC.stateType() == 1 && !this.flushedNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActivityState(ActivityState activityState) {
        this.activity = activityState;
        if (activityState == ActivityState.INSERTING_CALLBACKS && this.insertionNotifyList != null) {
            List<StateManager> list = this.insertionNotifyList;
            synchronized (list) {
                for (StateManager notifySM : this.insertionNotifyList) {
                    ((JDOStateManagerImpl)notifySM).insertionCompleted(this);
                }
                this.insertionNotifyList.clear();
                this.insertionNotifyList = null;
            }
        }
    }

    public void addInsertionNotifier(StateManager sm, ActivityState activityState) {
        if (this.insertionNotifyList == null) {
            this.insertionNotifyList = new ArrayList<StateManager>();
        }
        this.insertionNotifyList.add(sm);
    }

    public void updateFieldAfterInsert(Object pc, int fieldNumber) {
        FieldContainer cont;
        JDOStateManagerImpl otherSM = (JDOStateManagerImpl)this.myOM.findStateManager(pc);
        otherSM.addInsertionNotifier(this, ActivityState.INSERTING_CALLBACKS);
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            this.fieldsToBeUpdatedAfterObjectInsertion = new HashMap<javax.jdo.spi.StateManager, FieldContainer>();
        }
        if ((cont = this.fieldsToBeUpdatedAfterObjectInsertion.get(otherSM)) == null) {
            cont = new FieldContainer(fieldNumber);
        } else {
            cont.set(fieldNumber);
        }
        this.fieldsToBeUpdatedAfterObjectInsertion.put(otherSM, cont);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026021", (Object)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), (Object)StringUtils.toJVMIDString(this.myPC)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertionCompleted(StateManager sm) {
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            return;
        }
        FieldContainer fldCont = this.fieldsToBeUpdatedAfterObjectInsertion.get(sm);
        if (fldCont != null) {
            this.dirty = true;
            int[] fieldsToUpdate = fldCont.getFields();
            for (int i = 0; i < fieldsToUpdate.length; ++i) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026022", (Object)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldsToUpdate[i]).getFullFieldName(), (Object)this.myOM.getIdentityAsString(this.myID)));
                }
                this.dirtyFields[fieldsToUpdate[i]] = true;
            }
            this.fieldsToBeUpdatedAfterObjectInsertion.remove(sm);
            if (this.fieldsToBeUpdatedAfterObjectInsertion.size() == 0) {
                this.fieldsToBeUpdatedAfterObjectInsertion = null;
            }
            try {
                this.updatingForPostInsert = true;
                this.flush();
                Object var6_5 = null;
                this.updatingForPostInsert = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.updatingForPostInsert = false;
                throw throwable;
            }
        }
    }

    public boolean isUpdatingFieldForPostInsert() {
        return this.updatingForPostInsert;
    }

    public void setAssociatedValue(Object key, Object value) {
        if (this.associatedValuesMap == null) {
            this.associatedValuesMap = new HashMap();
        }
        this.associatedValuesMap.put(key, value);
    }

    public Object getAssociatedValue(Object key) {
        if (this.associatedValuesMap == null) {
            return null;
        }
        return this.associatedValuesMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransactional() {
        this.preStateChange();
        try {
            if (this.myLC == null) {
                this.initializeSM(5);
                this.setRestoreValues(true);
            } else {
                this.myLC = this.myLC.transitionMakeTransactional(this, true);
            }
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransient(FetchPlanState state) {
        if ((this.operationalFlags & 4) != 0) {
            return;
        }
        try {
            this.operationalFlags = (byte)(this.operationalFlags | 4);
            if (state == null) {
                int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getSecondClassMutableFieldNumbers(), true);
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    this.provideFields(fieldNumbers, new UnsetOwners());
                }
            } else {
                this.loadUnloadedFieldsInFetchPlan();
                int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), true);
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    this.replaceFields(fieldNumbers, new MakeTransientFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state));
                }
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionMakeTransient(this, state != null, this.myOM.isRunningDetachAllOnCommit());
                Object var4_4 = null;
                this.postStateChange();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.postStateChange();
                throw throwable;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFFB);
            throw throwable;
        }
        this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFFB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(FetchPlanState state) {
        ApiAdapter api = this.myOM.getApiAdapter();
        if (this.myLC.isDeleted() || api.isDetached(this.myPC) || (this.operationalFlags & 8) != 0) {
            return;
        }
        boolean detachable = api.isDetachable(this.myPC);
        if (detachable) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010009", (Object)StringUtils.toJVMIDString(this.myPC), (Object)("" + state.getCurrentFetchDepth())));
            }
            this.getCallbackHandler().preDetach(this.myPC);
        }
        try {
            this.operationalFlags = (byte)(this.operationalFlags | 8);
            if ((this.myOM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                this.loadUnloadedFieldsInFetchPlan();
            }
            if ((this.myOM.getFetchPlan().getDetachmentOptions() & 2) != 0) {
                this.unloadNonFetchPlanFields();
                int[] unloadedFields = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getAllFieldNumbers(), false);
                if (unloadedFields != null && unloadedFields.length > 0) {
                    PersistenceCapable dummyPC = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
                    this.myPC.jdoCopyFields((Object)dummyPC, unloadedFields);
                    this.replaceStateManager(dummyPC, null);
                }
            }
            DetachFieldManager detachFieldManager = new DetachFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state, false);
            for (int i = 0; i < this.loadedFields.length; ++i) {
                if (!this.loadedFields[i]) continue;
                try {
                    detachFieldManager.fetchObjectField(i);
                    continue;
                }
                catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eofpge) {
                    Object value = this.provideField(i);
                    if (!api.isPersistable(value)) continue;
                    StateManager valueSM = this.myOM.findStateManager(value);
                    if (api.isDetached(value) || valueSM != null && valueSM.isDetaching()) continue;
                    String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i).getName();
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026032", (Object)StringUtils.toJVMIDString(this.myPC), (Object)this.myOM.getIdentityAsString(this.myID), (Object)fieldName));
                    }
                    this.unloadField(fieldName);
                }
            }
            if (detachable) {
                this.myLC = this.myLC.transitionDetach(this);
                this.myPC.jdoReplaceFlags();
                ((Detachable)this.myPC).jdoReplaceDetachedState();
                this.getCallbackHandler().postDetach(this.myPC, this.myPC);
                PersistenceCapable toCheckPC = this.myPC;
                Object toCheckID = this.myID;
                this.disconnect();
                if (!toCheckPC.jdoIsDetached()) {
                    throw new NucleusUserException(LOCALISER.msg("026025", (Object)toCheckPC.getClass().getName(), toCheckID));
                }
            } else {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("026031", (Object)this.myPC.getClass().getName(), (Object)this.myOM.getIdentityAsString(this.myID)));
                this.makeTransient(null);
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFF7);
            throw throwable;
        }
        this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFF7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object detachCopy(FetchPlanState state) {
        PersistenceCapable detachedPC;
        if (this.myLC.isDeleted()) {
            throw new NucleusUserException(LOCALISER.msg("026023", (Object)this.myPC.getClass().getName(), this.myID));
        }
        if (this.myOM.getApiAdapter().isDetached(this.myPC)) {
            throw new NucleusUserException(LOCALISER.msg("026024", (Object)this.myPC.getClass().getName(), this.myID));
        }
        if (this.dirty) {
            this.myOM.flushInternal(false);
        }
        if ((this.operationalFlags & 8) != 0) {
            return this.referencedPC;
        }
        this.referencedPC = detachedPC = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        boolean detachable = this.myOM.getApiAdapter().isDetachable(this.myPC);
        PersistenceCapable persistenceCapable = this.referencedPC;
        synchronized (persistenceCapable) {
            block17: {
                if (detachable) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010010", (Object)StringUtils.toJVMIDString(this.myPC), (Object)("" + state.getCurrentFetchDepth()), (Object)StringUtils.toJVMIDString(detachedPC)));
                    }
                    this.getCallbackHandler().preDetach(this.myPC);
                }
                try {
                    try {
                        this.operationalFlags = (byte)(this.operationalFlags | 8);
                        if ((this.myOM.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                            this.loadUnloadedFieldsInFetchPlan();
                        }
                        if (this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(9)) {
                            this.myLC = this.myLC.transitionReadField(this, true);
                        }
                        JDOStateManagerImpl smDetachedPC = new JDOStateManagerImpl(this.myOM, this.cmd);
                        smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(this.myPC), this.getVersion(this.myPC));
                        smDetachedPC.referencedPC = this.myPC;
                        smDetachedPC.replaceFields(this.getFieldsNumbersToDetach(), new DetachFieldManager(this, this.getSecondClassMutableFields(), this.myFP, state, true));
                        smDetachedPC.referencedPC = null;
                        if (detachable) {
                            detachedPC.jdoReplaceFlags();
                            ((Detachable)detachedPC).jdoReplaceDetachedState();
                        } else {
                            smDetachedPC.makeTransient(null);
                        }
                        this.replaceStateManager(detachedPC, null);
                    }
                    catch (Exception e) {
                        NucleusLogger.PERSISTENCE.debug("DETACH ERROR : Error thrown while detaching " + StringUtils.toJVMIDString(this.myPC) + " (id=" + this.myID + ")", e);
                        Object var7_8 = null;
                        this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFF7);
                        this.referencedPC = null;
                        break block17;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFF7);
                    this.referencedPC = null;
                    throw throwable;
                }
                this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFF7);
                this.referencedPC = null;
            }
            if (detachable && !this.myOM.getApiAdapter().isDetached(detachedPC)) {
                throw new NucleusUserException(LOCALISER.msg("026025", (Object)detachedPC.getClass().getName(), this.myID));
            }
            if (!detachable) return detachedPC;
            this.getCallbackHandler().postDetach(this.myPC, detachedPC);
            return detachedPC;
        }
    }

    private int[] getFieldsNumbersToDetach() {
        int[] allFieldNumbers;
        int[] loadedFieldNumbers;
        int[] fieldsToDetach = this.myFP.getFieldsInActualFetchPlan();
        if ((this.myOM.getFetchPlan().getDetachmentOptions() & 2) == 0 && (loadedFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, allFieldNumbers = this.getAllFieldNumbers(), true)) != null && loadedFieldNumbers.length > 0) {
            int i;
            boolean[] flds = new boolean[allFieldNumbers.length];
            for (i = 0; i < fieldsToDetach.length; ++i) {
                flds[fieldsToDetach[i]] = true;
            }
            for (i = 0; i < loadedFieldNumbers.length; ++i) {
                flds[loadedFieldNumbers[i]] = true;
            }
            fieldsToDetach = JDOStateManagerImpl.getFlagsSetTo(flds, true);
        }
        return fieldsToDetach;
    }

    public Object getReferencedPC() {
        return this.referencedPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(boolean embedded) {
        if ((this.operationalFlags & 0x10) != 0) {
            return;
        }
        this.operationalFlags = (byte)(this.operationalFlags | 0x10);
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myOM.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore")) {
                try {
                    this.getStoreManager().getPersistenceHandler().locateObject(this);
                    persistent = true;
                }
                catch (NucleusObjectNotFoundException onfe) {}
            } else {
                persistent = true;
            }
            this.getCallbackHandler().preAttach(this.myPC);
            this.replaceStateManager(this.myPC, this);
            this.retrieveDetachState(this);
            if (!persistent) {
                this.makePersistent();
            }
            this.myLC = this.myLC.transitionAttach(this);
            this.myOM.putObjectIntoCache(this);
            int[] attachFieldNumbers = this.getFieldNumbersOfLoadedOrDirtyFields(this.loadedFields, this.dirtyFields);
            if (attachFieldNumbers != null) {
                this.provideFields(attachFieldNumbers, new AttachFieldManager(this, this.getSecondClassMutableFields(), this.dirtyFields, persistent, true, false));
            }
            this.getCallbackHandler().postAttach(this.myPC, this.myPC);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFEF);
            throw throwable;
        }
        this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFEF);
    }

    public Object attachCopy(Object obj, boolean embedded) {
        if ((this.operationalFlags & 0x10) != 0) {
            return this.myPC;
        }
        this.operationalFlags = (byte)(this.operationalFlags | 0x10);
        PersistenceCapable detachedPC = (PersistenceCapable)obj;
        try {
            try {
                boolean persistent = false;
                if (embedded) {
                    persistent = true;
                } else if (!this.myOM.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore")) {
                    try {
                        this.getStoreManager().getPersistenceHandler().locateObject(this);
                        persistent = true;
                    }
                    catch (NucleusObjectNotFoundException onfe) {}
                } else {
                    persistent = true;
                }
                this.getCallbackHandler().preAttach(detachedPC);
                if (this.myOM.getApiAdapter().isDeleted(detachedPC)) {
                    this.myLC = this.myLC.transitionDeletePersistent(this);
                }
                if (!(this.myOM.getTransaction().getOptimistic() || this.myLC != this.myOM.getApiAdapter().getLifeCycleState(4) && this.myLC != this.myOM.getApiAdapter().getLifeCycleState(9))) {
                    this.myLC = this.myLC.transitionMakeTransactional(this, persistent);
                }
                if (persistent) {
                    this.loadSCONonContainerFields();
                }
                JDOStateManagerImpl smDetachedPC = new JDOStateManagerImpl(this.myOM, this.cmd);
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(detachedPC), null);
                smDetachedPC.referencedPC = this.myPC;
                this.referencedPC = detachedPC;
                this.retrieveDetachState(smDetachedPC);
                if (!persistent) {
                    this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, false);
                    this.makePersistent();
                }
                this.internalAttachCopy(this, smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, true);
                this.replaceStateManager(detachedPC, null);
                smDetachedPC.referencedPC = null;
                this.referencedPC = null;
                this.getCallbackHandler().postAttach(this.myPC, detachedPC);
            }
            catch (NucleusException ne) {
                NucleusLogger.PERSISTENCE.debug("Unexpected exception thrown in attach", ne);
                throw ne;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFEF);
            throw throwable;
        }
        this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFEF);
        return this.myPC;
    }

    private void internalAttachCopy(StateManager sm, StateManager smDetached, boolean[] loadedFields, boolean[] dirtyFields, boolean persistent, Object version, boolean cascade) {
        int[] attachFieldNumbers = this.getFieldNumbersOfLoadedOrDirtyFields(loadedFields, dirtyFields);
        sm.setVersion(version);
        if (attachFieldNumbers != null) {
            boolean[] fieldsToAttach = dirtyFields;
            String attachPolicy = this.myOM.getAttachPolicy();
            if (attachPolicy.equals("attach-all")) {
                fieldsToAttach = new boolean[dirtyFields.length];
                for (int i = 0; i < dirtyFields.length; ++i) {
                    fieldsToAttach[i] = loadedFields[i] || dirtyFields[i];
                }
                smDetached.provideFields(attachFieldNumbers, new AttachFieldManager(sm, this.getSecondClassMutableFields(), fieldsToAttach, persistent, cascade, true));
            } else {
                smDetached.provideFields(attachFieldNumbers, new AttachFieldManager(sm, this.getSecondClassMutableFields(), dirtyFields, persistent, cascade, true));
            }
        }
    }

    private int[] getFieldNumbersOfLoadedOrDirtyFields(boolean[] loadedFields, boolean[] dirtyFields) {
        int numFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numFields;
        }
        int[] fieldNumbers = new int[numFields];
        int n = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            fieldNumbers[n++] = this.getAllFieldNumbers()[i];
        }
        return fieldNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (!this.myLC.isDeleted()) {
            if (this.myOM.isDelayDatastoreOperationsEnabled()) {
                this.getCallbackHandler().preDelete(this.myPC);
                this.myOM.markDirty(this, false);
                if (this.myLC.stateType() == 2 || this.myLC.stateType() == 3 || this.myLC.stateType() == 4 || this.myLC.stateType() == 9 || this.myLC.stateType() == 10) {
                    this.loadUnloadedFields();
                }
                this.provideFields(this.getAllFieldNumbers(), new DeleteFieldManager(this));
                this.dirty = true;
                this.preStateChange();
                try {
                    this.preDeleteLoadedFields = new boolean[this.loadedFields.length];
                    for (int i = 0; i < this.preDeleteLoadedFields.length; ++i) {
                        this.preDeleteLoadedFields[i] = this.loadedFields[i];
                    }
                    this.myLC = this.myLC.transitionDeletePersistent(this);
                    Object var3_3 = null;
                    this.postStateChange();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.postStateChange();
                    throw throwable;
                }
            }
            this.getCallbackHandler().preDelete(this.myPC);
            this.dirty = true;
            this.preStateChange();
            try {
                this.preDeleteLoadedFields = new boolean[this.loadedFields.length];
                for (int i = 0; i < this.preDeleteLoadedFields.length; ++i) {
                    this.preDeleteLoadedFields[i] = this.loadedFields[i];
                }
                this.myLC = this.myLC.transitionDeletePersistent(this);
                Object var5_6 = null;
                this.postStateChange();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.postStateChange();
                throw throwable;
            }
            this.internalDeletePersistent();
            this.getCallbackHandler().postDelete(this.myPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeletePersistent() {
        if (this.isDeleting()) {
            throw new NucleusUserException(LOCALISER.msg("026008"));
        }
        this.activity = ActivityState.DELETING;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myOM.flushInternal(false);
            }
            this.getStoreManager().getPersistenceHandler().deleteObject(this);
            this.preDeleteLoadedFields = null;
            Object var2_1 = null;
            this.activity = ActivityState.NONE;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.activity = ActivityState.NONE;
            throw throwable;
        }
    }

    public void locate() {
        this.getStoreManager().getPersistenceHandler().locateObject(this);
    }

    public void nullifyFields() {
        if (!this.myLC.isDeleted() && !this.myOM.getApiAdapter().isDetached(this.myPC)) {
            this.replaceFields(this.getNonPrimaryKeyFieldNumbers(), new NullifyRelationFieldManager(this));
            this.flush();
        }
    }

    public void validate() {
        if (!this.myLC.isTransactional) {
            int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.myFP.getFieldsInActualFetchPlan(), false);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.getNonPrimaryKeyFields(), fieldNumbers, true);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.getSecondClassMutableFields(), fieldNumbers, false);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.transitionReadField(false);
                fieldNumbers = this.myFP.getFieldsInActualFetchPlan();
                if (fieldNumbers != null) {
                    boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
                    this.setTransactionalVersion(null);
                    this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
                    if (callPostLoad) {
                        this.postLoad();
                    }
                }
            } else {
                this.getStoreManager().getPersistenceHandler().locateObject(this);
                this.transitionReadField(false);
            }
        }
    }

    protected void preStateChange() {
        this.changingState = true;
    }

    protected void postStateChange() {
        this.changingState = false;
        if (this.postLoadPending && this.isFetchPlanLoaded()) {
            this.postLoadPending = false;
            this.postLoad();
        }
    }

    private boolean preWriteField(int field) {
        boolean wasDirty = this.dirty;
        if (this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS) {
            if (!wasDirty) {
                this.getCallbackHandler().preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[field] = true;
            this.loadedFields[field] = true;
        }
        return wasDirty;
    }

    private void postWriteField(boolean wasDirty) {
        if (this.dirty && !wasDirty) {
            this.getCallbackHandler().postDirty(this.myPC);
        }
        if (this.activity == ActivityState.NONE && (this.operationalFlags & 2) == 0 && (!this.myLC.isTransactional || this.myLC.isPersistent)) {
            if ((this.operationalFlags & 8) != 0 && this.referencedPC == null) {
                return;
            }
            this.myOM.markDirty(this, true);
        }
    }

    private void postLoad() {
        if (this.changingState) {
            this.postLoadPending = true;
        } else {
            if (this.jdoDfgFlags == 1 && this.myLC.isTransactional()) {
                this.jdoDfgFlags = (byte)-1;
                this.myPC.jdoReplaceFlags();
            }
            this.getCallbackHandler().postLoad(this.myPC);
        }
    }

    public void setStoringPC() {
        this.storingPC = true;
    }

    public void unsetStoringPC() {
        this.storingPC = false;
    }

    public void preSerialize(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return;
        }
        this.retrieve(false);
        this.myLC = this.myLC.transitionSerialize(this);
        if (!this.storingPC && pc instanceof Detachable && !this.myLC.isDeleted && this.myLC.isPersistent) {
            if (this.myLC.isDirty) {
                this.flush();
            }
            ((Detachable)pc).jdoReplaceDetachedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.dirty) {
            if ((this.operationalFlags & 2) != 0) {
                return;
            }
            if (this.activity == ActivityState.INSERTING || this.activity == ActivityState.INSERTING_CALLBACKS) {
                return;
            }
            this.operationalFlags = (byte)(this.operationalFlags | 2);
            try {
                if (this.myLC.stateType() == 1 && !this.flushedNew) {
                    if (!this.isEmbedded()) {
                        this.internalMakePersistent();
                    } else {
                        this.getCallbackHandler().preStore(this.myPC);
                        if (this.myID == null) {
                            this.setIdentity(true);
                        }
                        this.getCallbackHandler().postStore(this.myPC);
                    }
                    this.dirty = false;
                } else if (this.myLC.stateType() == 8) {
                    this.getCallbackHandler().preDelete(this.myPC);
                    if (!this.isEmbedded()) {
                        this.internalDeletePersistent();
                    }
                    this.getCallbackHandler().postDelete(this.myPC);
                } else if (this.myLC.stateType() == 7) {
                    if (this.flushedNew) {
                        this.getCallbackHandler().preDelete(this.myPC);
                        if (!this.isEmbedded()) {
                            this.internalDeletePersistent();
                        }
                        this.flushedNew = false;
                        this.getCallbackHandler().postDelete(this.myPC);
                    } else {
                        this.dirty = false;
                    }
                } else {
                    int[] dirtyFieldNumbers;
                    if (!this.isDeleting()) {
                        this.getCallbackHandler().preStore(this.myPC);
                        if (this.myID == null) {
                            this.setIdentity(true);
                        }
                    }
                    if ((dirtyFieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.dirtyFields, true)) == null) {
                        throw new NucleusException(LOCALISER.msg("026010")).setFatal();
                    }
                    if (!this.isEmbedded()) {
                        this.getStoreManager().getPersistenceHandler().updateObject(this, dirtyFieldNumbers);
                        this.myOM.putObjectIntoCache(this);
                    }
                    this.clearDirtyFlags();
                    this.getCallbackHandler().postStore(this.myPC);
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFFD);
                throw throwable;
            }
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFFD);
            {
            }
        }
    }

    private void initializeSM(int newState) {
        JDOStateManagerImpl thisSM = this;
        this.myLC = this.myOM.getOMFContext().getApiAdapter().getLifeCycleState(newState);
        try {
            if (this.myLC.isPersistent()) {
                this.myOM.addStateManager(this);
            }
            this.replaceStateManager(this.myPC, thisSM);
        }
        catch (SecurityException e) {
            throw new NucleusUserException(e.getMessage());
        }
        catch (NucleusException ne) {
            if (this.myOM.getStateManagerById(this.myID) == this) {
                this.myOM.removeStateManager(this);
            }
            throw ne;
        }
    }

    protected boolean disconnectClone(PersistenceCapable pc) {
        if ((this.operationalFlags & 8) != 0) {
            return false;
        }
        if (pc != this.myPC) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026001", (Object)StringUtils.toJVMIDString(pc), (Object)this));
            }
            pc.jdoReplaceFlags();
            this.replaceStateManager(pc, null);
            return true;
        }
        return false;
    }

    private void unsetOwnerInSCOFields() {
        int[] fieldNumbers = JDOStateManagerImpl.getFlagsSetTo(this.loadedFields, this.getSecondClassMutableFieldNumbers(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.provideFields(fieldNumbers, new UnsetOwners());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026011", (Object)StringUtils.toJVMIDString(this.myPC), (Object)this));
        }
        if (this.postLoadPending) {
            this.changingState = false;
            this.postLoadPending = false;
            this.postLoad();
        }
        this.unsetOwnerInSCOFields();
        this.myOM.removeStateManager(this);
        this.jdoDfgFlags = 0;
        this.myPC.jdoReplaceFlags();
        this.operationalFlags = (byte)(this.operationalFlags | 1);
        try {
            this.replaceStateManager(this.myPC, null);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFFE);
            throw throwable;
        }
        this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFFE);
        if (this.associatedValuesMap != null) {
            this.associatedValuesMap.clear();
            this.associatedValuesMap = null;
        }
        this.clearSavedFields();
        this.myOM = null;
        this.myFP = null;
        this.myPC = null;
        this.myID = null;
        this.myLC = null;
        this.cmd = null;
    }

    public void registerTransactional() {
        this.myOM.addStateManager(this);
    }

    public void retrieveDetachState(StateManager sm) {
        if (sm.getObject() instanceof Detachable) {
            ((JDOStateManagerImpl)sm).operationalFlags = (byte)(((JDOStateManagerImpl)sm).operationalFlags | 0xFFFFFF80);
            ((Detachable)sm.getObject()).jdoReplaceDetachedState();
            ((JDOStateManagerImpl)sm).operationalFlags = (byte)(((JDOStateManagerImpl)sm).operationalFlags & 0x7F);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.operationalFlags = (byte)(this.operationalFlags | 0x40);
            try {
                ((Detachable)this.getObject()).jdoReplaceDetachedState();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFBF);
                throw throwable;
            }
            this.operationalFlags = (byte)(this.operationalFlags & 0xFFFFFFBF);
            {
            }
        }
    }

    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        if ((this.operationalFlags & 0x40) != 0) {
            return null;
        }
        if ((this.operationalFlags & 0xFFFFFF80) != 0) {
            BitSet jdoLoadedFields = (BitSet)currentState[2];
            for (int i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = jdoLoadedFields.get(i);
            }
            BitSet jdoModifiedFields = (BitSet)currentState[3];
            for (int i = 0; i < this.dirtyFields.length; ++i) {
                this.dirtyFields[i] = jdoModifiedFields.get(i);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.getVersion(this.myPC);
        BitSet loadedState = new BitSet();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) {
                loadedState.set(i);
                continue;
            }
            loadedState.clear(i);
        }
        state[2] = loadedState;
        BitSet modifiedState = new BitSet();
        for (int i = 0; i < this.dirtyFields.length; ++i) {
            if (this.dirtyFields[i]) {
                modifiedState.set(i);
                continue;
            }
            modifiedState.clear(i);
        }
        state[3] = modifiedState;
        return state;
    }

    private static void dumpPC(PersistenceCapable pc, PrintWriter out) {
        out.println(StringUtils.toJVMIDString(pc));
        if (pc == null) {
            return;
        }
        out.print("jdoStateManager = " + JDOStateManagerImpl.peekField(pc, "jdoStateManager"));
        out.print("jdoFlags = ");
        Object flagsObj = JDOStateManagerImpl.peekField(pc, "jdoFlags");
        if (flagsObj instanceof Byte) {
            out.println(JDOStateManagerImpl.jdoFlagsToString((Byte)flagsObj));
        } else {
            out.println(flagsObj);
        }
        Class<?> c = pc.getClass();
        do {
            String[] fieldNames = HELPER.getFieldNames(c);
            for (int i = 0; i < fieldNames.length; ++i) {
                out.print(fieldNames[i]);
                out.print(" = ");
                out.println(JDOStateManagerImpl.peekField(pc, fieldNames[i]));
            }
        } while ((c = c.getSuperclass()) != null && PersistenceCapable.class.isAssignableFrom(c));
    }

    public void dump(PrintWriter out) {
        out.println("myPM = " + this.myOM);
        out.println("myID = " + this.myID);
        out.println("myLC = " + this.myLC);
        out.println("cmd = " + this.cmd);
        out.println("srm = " + this.getStoreManager());
        out.println("fieldCount = " + this.getHighestFieldNumber());
        out.println("dirty = " + this.dirty);
        out.println("flushing = " + ((this.operationalFlags & 2) != 0));
        out.println("changingState = " + this.changingState);
        out.println("postLoadPending = " + this.postLoadPending);
        out.println("disconnecting = " + ((this.operationalFlags & 1) != 0));
        out.println("dirtyFields = " + StringUtils.booleanArrayToString(this.dirtyFields));
        out.println("getSecondClassMutableFields() = " + StringUtils.booleanArrayToString(this.getSecondClassMutableFields()));
        out.println("getAllFieldNumbers() = " + StringUtils.intArrayToString(this.getAllFieldNumbers()));
        out.println("secondClassMutableFieldNumbers = " + StringUtils.intArrayToString(this.getSecondClassMutableFieldNumbers()));
        out.println();
        out.println("jdoFlags = " + JDOStateManagerImpl.jdoFlagsToString(this.jdoDfgFlags));
        out.println("loadedFields = " + StringUtils.booleanArrayToString(this.loadedFields));
        out.print("myPC = ");
        JDOStateManagerImpl.dumpPC(this.myPC, out);
        out.println();
        out.println("savedFlags = " + JDOStateManagerImpl.jdoFlagsToString(this.savedFlags));
        out.println("savedLoadedFields = " + StringUtils.booleanArrayToString(this.savedLoadedFields));
        out.print("savedImage = ");
        JDOStateManagerImpl.dumpPC(this.savedImage, out);
    }

    private static String jdoFlagsToString(byte flags) {
        switch (flags) {
            case 1: {
                return "LOAD_REQUIRED";
            }
            case -1: {
                return "READ_OK";
            }
            case 0: {
                return "READ_WRITE_OK";
            }
        }
        return "???";
    }

    static {
        HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
        HELPER = NucleusJDOHelper.getJDOImplHelper();
    }

    private class FieldContainer {
        boolean[] fieldsToUpdate;

        public FieldContainer(int fieldNumber) {
            this.fieldsToUpdate = new boolean[JDOStateManagerImpl.this.getAllFieldNumbers().length];
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public void set(int fieldNumber) {
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public int[] getFields() {
            return AbstractStateManager.getFlagsSetTo(this.fieldsToUpdate, true);
        }
    }

    private class EmbeddedOwnerRelation {
        private StateManager sm;
        private int fieldNumber;

        public EmbeddedOwnerRelation(StateManager ownerSM, int ownerFieldNumber) {
            this.sm = ownerSM;
            this.fieldNumber = ownerFieldNumber;
        }
    }
}

