/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;
    final String nameOfFile2Compress;
    final String nameOfCompressedFile;

    public Compressor(CompressionMode compressionMode, String nameOfFile2Compress, String nameOfCompressedFile) {
        this.compressionMode = compressionMode;
        this.nameOfFile2Compress = nameOfFile2Compress;
        this.nameOfCompressedFile = nameOfCompressedFile;
    }

    public Compressor(CompressionMode compressionMode, String nameOfFile2Compress) {
        this(compressionMode, nameOfFile2Compress, nameOfFile2Compress);
    }

    public void compress() {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(this.nameOfFile2Compress, this.nameOfCompressedFile);
                break;
            }
            case ZIP: {
                this.zipCompress(this.nameOfFile2Compress, this.nameOfCompressedFile);
            }
        }
    }

    private void zipCompress(String nameOfFile2zip, String nameOfZippedFile) {
        File zippedFile;
        File file2zip = new File(nameOfFile2zip);
        if (!file2zip.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2zip + "] does not exist.", this));
            return;
        }
        if (!nameOfZippedFile.endsWith(".zip")) {
            nameOfZippedFile = nameOfZippedFile + ".zip";
        }
        if ((zippedFile = new File(nameOfZippedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + nameOfZippedFile + "] exist already.", this));
            return;
        }
        try {
            int n;
            FileOutputStream fos = new FileOutputStream(nameOfZippedFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            FileInputStream fis = new FileInputStream(nameOfFile2zip);
            ZipEntry zipEntry = new ZipEntry(file2zip.getName());
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                zos.write(inbuf, 0, n);
            }
            fis.close();
            zos.close();
            if (!file2zip.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2zip + "].", this));
            }
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2zip + "] into [" + nameOfZippedFile + "].", this, e));
        }
    }

    private void gzCompress(String nameOfFile2gz, String nameOfgzedFile) {
        File gzedFile;
        File file2gz = new File(nameOfFile2gz);
        if (!file2gz.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2gz + "] does not exist.", this));
            return;
        }
        if (!nameOfgzedFile.endsWith(".gz")) {
            nameOfgzedFile = nameOfgzedFile + ".gz";
        }
        if ((gzedFile = new File(nameOfgzedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + nameOfgzedFile + "] exist already.", this));
            return;
        }
        try {
            int n;
            FileOutputStream fos = new FileOutputStream(nameOfgzedFile);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            FileInputStream fis = new FileInputStream(nameOfFile2gz);
            byte[] inbuf = new byte[8102];
            while ((n = fis.read(inbuf)) != -1) {
                gzos.write(inbuf, 0, n);
            }
            fis.close();
            gzos.close();
            if (!file2gz.delete()) {
                this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2gz + "].", this));
            }
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2gz + "] into [" + nameOfgzedFile + "].", this, e));
        }
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.Compress";
    }
}

