/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.MappedStoreManager;

class KeyRegistry {
    private final Map<Object, Key> parentKeyMap = new IdentityHashMap<Object, Key>();

    KeyRegistry() {
    }

    void registerKey(MappedStoreManager storeMgr, StateManager stateMgr, DatastoreFieldManager fieldMgr) {
        DatastoreTable dt = (DatastoreTable)storeMgr.getDatastoreClass(fieldMgr.getClassMetaData().getFullClassName(), fieldMgr.getClassLoaderResolver());
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        Key key = fieldMgr.getEntity().getKey();
        for (AbstractMemberMetaData dependent : dt.getSameEntityGroupMemberMetaData()) {
            stateMgr.provideFields(new int[]{dependent.getAbsoluteFieldNumber()}, (FieldManager)sfv);
            List<Object> childValue = sfv.fetchObjectField(dependent.getAbsoluteFieldNumber());
            if (childValue == null) continue;
            if (childValue instanceof Object[]) {
                childValue = Arrays.asList((Object[])childValue);
            }
            if (childValue instanceof Iterable) {
                for (Object element : (Iterable)childValue) {
                    this.parentKeyMap.put(element, key);
                }
                continue;
            }
            this.parentKeyMap.put(childValue, key);
        }
    }

    Key getRegisteredKey(Object object) {
        return this.parentKeyMap.get(object);
    }

    void clear() {
        this.parentKeyMap.clear();
    }
}

