/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.version.undo;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.version.undo.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Remove
extends Change {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)Remove.class);
    private final Component component;
    private final MarkupContainer container;

    Remove(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("argument component must be not null");
        }
        this.component = component;
        this.container = component.getParent();
        if (this.container == null) {
            throw new IllegalArgumentException("component must have a parent");
        }
        if (log.isDebugEnabled()) {
            log.debug("RECORD REMOVE: removed " + component.getPath() + " (" + Classes.simpleName(component.getClass()) + "@" + component.hashCode() + ") from parent");
        }
    }

    public void undo() {
        if (log.isDebugEnabled()) {
            log.debug("UNDO REMOVE: re-adding " + this.component.getPath() + " (" + Classes.simpleName(this.component.getClass()) + "@" + this.component.hashCode() + ") to parent");
        }
        this.container.internalAdd(this.component);
    }

    public String toString() {
        return "Remove[component: " + this.component.getPath() + "]";
    }
}

