/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.net.URL;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.UrlResourceStream;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamLocator
implements IResourceStreamLocator {
    private static final Logger log = LoggerFactory.getLogger((Class)ResourceStreamLocator.class);
    private IResourceFinder finder;

    public ResourceStreamLocator() {
    }

    public ResourceStreamLocator(IResourceFinder finder) {
        this.finder = finder;
    }

    public IResourceStream locate(Class clazz, String path) {
        IResourceStream stream = this.locateByResourceFinder(clazz, path);
        if (stream != null) {
            return stream;
        }
        stream = this.locateByClassLoader(clazz, path);
        if (stream != null) {
            return stream;
        }
        return null;
    }

    public IResourceStream locate(Class clazz, String path, String style, Locale locale, String extension) {
        ResourceNameIterator iter = new ResourceNameIterator(path, style, locale, extension);
        while (iter.hasNext()) {
            String newPath = (String)iter.next();
            IResourceStream stream = this.locate(clazz, newPath);
            if (stream == null) continue;
            stream.setLocale(iter.getLocale());
            return stream;
        }
        return null;
    }

    protected IResourceStream locateByClassLoader(Class clazz, String path) {
        URL url;
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to locate resource '" + path + "' using classloader " + classLoader);
        }
        if ((url = classLoader.getResource(path)) != null) {
            return new UrlResourceStream(url);
        }
        return null;
    }

    protected IResourceStream locateByResourceFinder(Class clazz, String path) {
        if (this.finder == null) {
            this.finder = Application.get().getResourceSettings().getResourceFinder();
        }
        if (log.isDebugEnabled()) {
            log.debug("Attempting to locate resource '" + path + "' on path " + this.finder);
        }
        return this.finder.find(clazz, path);
    }
}

