/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.resource.locator.ExtensionResourceNameIterator;
import org.apache.wicket.util.resource.locator.LocaleResourceNameIterator;
import org.apache.wicket.util.resource.locator.StyleAndVariationResourceNameIterator;
import org.apache.wicket.util.string.Strings;

public class ResourceNameIterator
implements Iterator {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("_[a-zA-Z]{2}($|(?=_))");
    private final Locale locale;
    private final String extensions;
    private final Iterator styleIterator;
    private LocaleResourceNameIterator localeIterator;
    private Iterator extenstionsIterator;
    private Locale currentLocale;
    private final HashSet isoCountries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
    private final HashSet isoLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));

    public ResourceNameIterator(String path, String style, Locale locale, String extensions) {
        this.locale = locale;
        if (extensions == null) {
            this.extensions = Strings.afterLast(path, '.');
            path = Strings.beforeLast(path, '.');
        } else {
            this.extensions = extensions;
        }
        Matcher matcher = LOCALE_PATTERN.matcher(path);
        if (matcher.find()) {
            String s;
            String language = null;
            String country = null;
            String variant = null;
            int firstValidLocalePatternFragment = -1;
            do {
                if (!Character.isLowerCase((s = matcher.group().substring(1, 3)).charAt(0)) || !this.isoLanguages.contains(s)) continue;
                language = s;
                firstValidLocalePatternFragment = matcher.start();
                break;
            } while (matcher.find());
            if (language != null) {
                if (matcher.find()) {
                    do {
                        if (!Character.isUpperCase((s = matcher.group().substring(1, 3)).charAt(0)) || !this.isoCountries.contains(s)) continue;
                        country = s;
                        break;
                    } while (matcher.find());
                }
                if (country != null && matcher.find()) {
                    variant = path.substring(matcher.start());
                }
                path = path.substring(0, firstValidLocalePatternFragment);
                this.localeIterator = new LocaleResourceNameIterator(path, new Locale(language, country != null ? country : "", variant != null ? variant : ""));
            }
        }
        this.styleIterator = new StyleAndVariationResourceNameIterator(path, style, null);
    }

    public final Locale getLocale() {
        return this.currentLocale;
    }

    public boolean hasNext() {
        String newPath;
        if (this.extenstionsIterator != null) {
            if (this.extenstionsIterator.hasNext()) {
                return true;
            }
            this.extenstionsIterator = null;
        }
        if (this.localeIterator != null) {
            while (this.localeIterator.hasNext()) {
                newPath = (String)this.localeIterator.next();
                this.currentLocale = this.localeIterator.getLocale();
                this.extenstionsIterator = new ExtensionResourceNameIterator(newPath, this.extensions);
                if (!this.extenstionsIterator.hasNext()) continue;
                return true;
            }
            this.localeIterator = null;
        }
        while (this.styleIterator.hasNext()) {
            newPath = (String)this.styleIterator.next();
            this.localeIterator = new LocaleResourceNameIterator(newPath, this.locale);
            while (this.localeIterator.hasNext()) {
                newPath = (String)this.localeIterator.next();
                this.currentLocale = this.localeIterator.getLocale();
                this.extenstionsIterator = new ExtensionResourceNameIterator(newPath, this.extensions);
                if (!this.extenstionsIterator.hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    public Object next() {
        if (this.extenstionsIterator != null) {
            return this.extenstionsIterator.next();
        }
        throw new WicketRuntimeException("Illegal call of next(). Iterator not properly initialized");
    }

    public void remove() {
    }
}

