/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import junit.framework.Assert;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.Revision;
import org.apache.wicket.util.license.AbstractLicenseHeaderHandler;

class PropertiesLicenseHeaderHandler
extends AbstractLicenseHeaderHandler {
    public PropertiesLicenseHeaderHandler(String[] ignoreFiles) {
        super(ignoreFiles);
    }

    protected String getLicenseHeaderFilename() {
        return "propertiesLicense.txt";
    }

    public boolean checkLicenseHeader(File file) {
        Revision revision = null;
        try {
            String header = this.extractLicenseHeader(file, 0, 14);
            revision = Diff.diff(this.getLicenseHeader().split(LINE_ENDING), header.split(LINE_ENDING));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return revision.size() == 0;
    }

    public String[] getSuffixes() {
        return new String[]{"properties"};
    }

    public boolean addLicenseHeader(File file) {
        this.prependLicenseHeader(file);
        return true;
    }
}

