/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.wicket.markup.html.WebResource;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class ByteArrayResource
extends WebResource {
    private static final long serialVersionUID = 1L;
    private final String contentType;
    private final byte[] array;
    private final Locale locale;
    private final Time lastModified = Time.now();
    private final String filename;

    public ByteArrayResource(String contentType, byte[] array) {
        this.contentType = contentType;
        this.array = array;
        this.locale = null;
        this.filename = null;
    }

    public ByteArrayResource(String contentType, byte[] array, String filename) {
        this.contentType = contentType;
        this.array = array;
        this.filename = filename;
        this.locale = null;
    }

    public ByteArrayResource(String contentType, byte[] array, Locale locale) {
        this.contentType = contentType;
        this.array = array;
        this.locale = locale;
        this.filename = null;
    }

    public ByteArrayResource(String contentType, byte[] array, Locale locale, String filename) {
        this.contentType = contentType;
        this.array = array;
        this.locale = locale;
        this.filename = filename;
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        if (this.filename != null) {
            response.setAttachmentHeader(this.filename);
        }
    }

    public IResourceStream getResourceStream() {
        return new IResourceStream(){
            private static final long serialVersionUID = 1L;
            private transient InputStream inputStream = null;

            public void close() throws IOException {
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
            }

            public String getContentType() {
                return ByteArrayResource.this.contentType;
            }

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                if (this.inputStream == null) {
                    this.inputStream = new ByteArrayInputStream(ByteArrayResource.this.array);
                }
                return this.inputStream;
            }

            public Time lastModifiedTime() {
                return ByteArrayResource.this.lastModified;
            }

            public long length() {
                return ByteArrayResource.this.array.length;
            }

            public Locale getLocale() {
                return ByteArrayResource.this.locale;
            }

            public void setLocale(Locale locale) {
            }
        };
    }
}

