/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.convert.IConverter;

public final class AutoComponentResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private final Map nestedComponents = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        Component component;
        WicketTag wicketTag;
        if (tag instanceof WicketTag && (wicketTag = (WicketTag)tag).isComponentTag() && (component = this.createComponent(container, wicketTag)) != null) {
            if (component instanceof Border) {
                this.nestedComponents.put(((Border)component).getBodyContainer(), container);
            } else {
                this.nestedComponents.put(component, container);
            }
            try {
                container.autoAdd(component, markupStream);
            }
            finally {
                this.nestedComponents.remove(component);
            }
            return true;
        }
        if (tag.getId() != null && this.nestedComponents.containsKey(container)) {
            MarkupContainer parent = (MarkupContainer)this.nestedComponents.get(container);
            while (parent != null) {
                component = parent.get(tag.getId());
                if (component != null) {
                    component.render(markupStream);
                    return true;
                }
                if (!this.nestedComponents.containsKey(parent = parent.getParent())) continue;
                parent = (MarkupContainer)this.nestedComponents.get(parent);
            }
        }
        return false;
    }

    private final Component createComponent(MarkupContainer container, WicketTag tag) {
        Component component;
        String classname;
        String componentId = tag.getNameAttribute();
        if (componentId == null) {
            componentId = "anonymous-" + container.getPage().getAutoIndex();
        }
        if ((classname = tag.getAttributes().getString("class")) == null || classname.trim().length() == 0) {
            throw new MarkupException("Tag <wicket:component> must have attribute 'class'");
        }
        try {
            Class componentClass = container.getSession().getClassResolver().resolveClass(classname);
            Constructor constructor = componentClass.getConstructor(String.class);
            component = (Component)constructor.newInstance(componentId);
        }
        catch (ClassNotFoundException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new MarkupException("Unable to create Component from wicket tag: Cause: " + e.getMessage());
        }
        Iterator iter = tag.getAttributes().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("name".equalsIgnoreCase(key) || "class".equalsIgnoreCase(key)) continue;
            this.invokeSetter(component, key, value, container.getLocale());
        }
        return component;
    }

    private final void invokeSetter(Object object, String name, String value, Locale locale) {
        String methodName = "set" + name;
        Method[] methods = object.getClass().getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            method = methods[i];
        }
        if (method == null) {
            throw new MarkupException("Unable to initialize Component. Method with name " + methodName + " not found");
        }
        Class<?>[] parameterClasses = method.getParameterTypes();
        if (parameterClasses.length != 1) {
            throw new MarkupException("Unable to initialize Component. Method with name " + methodName + " must have one and only one parameter");
        }
        Class<?> paramClass = parameterClasses[0];
        try {
            IConverter converter = Application.get().getConverterLocator().getConverter(paramClass);
            Object param = converter.convertToObject(value, locale);
            if (param == null) {
                throw new MarkupException("Unable to convert value '" + value + "' into " + paramClass + ". May be there is no converter for that type registered?");
            }
            method.invoke(object, param);
        }
        catch (IllegalAccessException ex) {
            throw new MarkupException("Unable to initialize Component. Failure while invoking method " + methodName + ". Cause: " + ex);
        }
        catch (InvocationTargetException ex) {
            throw new MarkupException("Unable to initialize Component. Failure while invoking method " + methodName + ". Cause: " + ex);
        }
        catch (NumberFormatException ex) {
            throw new MarkupException("Unable to initialize Component. Failure while invoking method " + methodName + ". Cause: " + ex);
        }
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("component");
    }
}

