/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.application.WildcardMatcherHelper;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.ModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger((Class)ReloadingClassLoader.class);
    private static final Set urls = new HashSet();
    private static final List patterns = new ArrayList();
    private IChangeListener listener;
    private final Duration pollFrequency = Duration.seconds(3);
    private final ModificationWatcher watcher;

    protected boolean tryClassHere(String name) {
        boolean tryHere;
        if (name != null && (name.startsWith("java.") || name.startsWith("javax.servlet"))) {
            return false;
        }
        if (patterns == null || patterns.size() == 0) {
            tryHere = true;
        } else {
            tryHere = false;
            Iterator includesIterator = patterns.iterator();
            while (includesIterator.hasNext()) {
                String rawpattern = (String)includesIterator.next();
                if (rawpattern.length() <= 1) continue;
                boolean isInclude = rawpattern.substring(0, 1).equals("+");
                String pattern = rawpattern.substring(1);
                if (WildcardMatcherHelper.match(pattern, name) == null) continue;
                tryHere = isInclude;
            }
        }
        return tryHere;
    }

    public static void includePattern(String pattern) {
        patterns.add("+" + pattern);
    }

    public static void excludePattern(String pattern) {
        patterns.add("-" + pattern);
    }

    public static List getPatterns() {
        return patterns;
    }

    public static void addLocation(URL url) {
        urls.add(url);
    }

    public static Set getLocations() {
        return urls;
    }

    /*
     * WARNING - void declaration
     */
    private static void addClassLoaderUrls(ClassLoader loader) {
        if (loader != null) {
            void var1_1;
            try {
                Enumeration<URL> resources = loader.getResources("");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (var1_1.hasMoreElements()) {
                URL location = (URL)var1_1.nextElement();
                ReloadingClassLoader.addLocation(location);
            }
        }
    }

    public ReloadingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        ReloadingClassLoader.addClassLoaderUrls(parent);
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            this.addURL((URL)i.next());
        }
        this.watcher = new ModificationWatcher(this.pollFrequency);
    }

    public final URL getResource(String name) {
        URL resource = this.findResource(name);
        ClassLoader parent = this.getParent();
        if (resource == null && parent != null) {
            resource = parent.getResource(name);
        }
        return resource;
    }

    public final Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            ClassLoader parent;
            block7: {
                parent = this.getParent();
                if (this.tryClassHere(name)) {
                    try {
                        clazz = this.findClass(name);
                        this.watchForModifications(clazz);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (parent != null) break block7;
                        throw cnfe;
                    }
                }
            }
            if (clazz == null) {
                if (parent == null) {
                    throw new ClassNotFoundException(name);
                }
                clazz = parent.loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public void setListener(IChangeListener listener) {
        this.listener = listener;
    }

    private void watchForModifications(Class clz) {
        Iterator locationsIterator = urls.iterator();
        File clzFile = null;
        while (locationsIterator.hasNext()) {
            URL location = (URL)locationsIterator.next();
            String clzLocation = location.getFile() + clz.getName().replaceAll("\\.", "/") + ".class";
            log.debug("clzLocation=" + clzLocation);
            File finalClzFile = clzFile = new org.apache.wicket.util.file.File(clzLocation);
            if (clzFile.exists()) {
                log.info("Watching changes of class " + clzFile);
                this.watcher.add((IModifiable)((Object)clzFile), new IChangeListener((org.apache.wicket.util.file.File)finalClzFile){
                    private final /* synthetic */ org.apache.wicket.util.file.File val$finalClzFile;
                    {
                        this.val$finalClzFile = val$finalClzFile;
                    }

                    public void onChange() {
                        log.info("Class file " + this.val$finalClzFile + " has changed, reloading");
                        try {
                            ReloadingClassLoader.this.listener.onChange();
                        }
                        catch (Exception e) {
                            log.error("Could not notify listener", (Throwable)e);
                            ReloadingClassLoader.this.watcher.remove(this.val$finalClzFile);
                        }
                    }
                });
                break;
            }
            log.debug("Class file does not exist: " + clzFile);
        }
        if (clzFile != null && !clzFile.exists()) {
            log.debug("Could not locate class " + clz.getName());
        }
    }

    public void destroy() {
        this.watcher.destroy();
    }

    static {
        ReloadingClassLoader.addClassLoaderUrls(ReloadingClassLoader.class.getClassLoader());
        ReloadingClassLoader.excludePattern("org.apache.wicket.*");
        ReloadingClassLoader.includePattern("org.apache.wicket.examples.*");
    }
}

