/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@GoogleInternal
public final class Comparators {
    public static final Ordering<Object> STRING_FORM_ORDER = new ToStringOrder();

    private Comparators() {
    }

    public static <T extends Comparable> Ordering<T> naturalOrder() {
        return Ordering.natural();
    }

    public static <T> Ordering<T> nullLeastOrder(Comparator<T> comparator) {
        return Ordering.from(comparator).nullsFirst();
    }

    public static <T extends Comparable> Ordering<T> nullLeastOrder() {
        return Ordering.natural().nullsFirst();
    }

    public static <T> Ordering<T> nullGreatestOrder(Comparator<T> comparator) {
        return Ordering.from(comparator).nullsLast();
    }

    public static <T extends Comparable> Ordering<T> nullGreatestOrder() {
        return Ordering.natural().nullsLast();
    }

    public static <T> Ordering<T> compound(Comparator<? super T> first, Comparator<? super T> second) {
        return Ordering.from(first).compound(second);
    }

    public static <T> Ordering<T> compound(Comparator<? super T> first, Comparator<? super T> second, Comparator<? super T> third) {
        return Ordering.from(first).compound(second).compound(third);
    }

    public static <T> Ordering<T> compound(Comparator<? super T> first, Comparator<? super T> second, Comparator<? super T> third, Comparator<? super T> fourth) {
        return Ordering.from(first).compound(second).compound(third).compound(fourth);
    }

    public static <T> Ordering<T> compound(Comparator<? super T> first, Comparator<? super T> second, Comparator<? super T> third, Comparator<? super T> fourth, Comparator<? super T> ... rest) {
        Comparator<? super T> firstT = first;
        Comparator<? super T> secondT = second;
        Comparator<? super T> thirdT = third;
        Comparator<? super T> forthT = fourth;
        ArrayList<Comparator<? super T>> list = new ArrayList<Comparator<? super T>>();
        list.addAll(Arrays.asList(firstT, secondT, thirdT, forthT));
        list.addAll(Arrays.asList(rest));
        return Ordering.compound(list);
    }

    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return Ordering.compound(comparators);
    }

    public static <F, T extends Comparable> Ordering<F> fromFunction(Function<F, T> function) {
        return Ordering.natural().onResultOf(function);
    }

    public static <F, T> Ordering<F> fromFunction(Function<F, T> function, Comparator<? super T> comparator) {
        return Ordering.from(comparator).onResultOf(function);
    }

    public static final <T> Ordering<T> toStringOrder() {
        return STRING_FORM_ORDER;
    }

    public static <T extends Comparable> T min(T a, T b) {
        return Ordering.natural().min(a, b);
    }

    public static <T extends Comparable> T max(T a, T b) {
        return Ordering.natural().max(a, b);
    }

    public static <T> T min(Comparator<? super T> comparator, @Nullable T a, @Nullable T b) {
        return Ordering.from(comparator).min(a, b);
    }

    public static <T> T max(Comparator<? super T> comparator, @Nullable T a, @Nullable T b) {
        return Ordering.from(comparator).max(a, b);
    }

    public static <T> Ordering<T> givenOrder(List<T> valuesInOrder) {
        return Ordering.givenOrder(valuesInOrder);
    }

    public static <T> Ordering<T> givenOrder(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.givenOrder(leastValue, remainingValuesInOrder);
    }

    public static int compare(byte a, byte b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(char a, char b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(short a, short b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    @Deprecated
    public static int compare(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    @Deprecated
    public static int compare(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    public static int compare(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToStringOrder
    extends Ordering<Object>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private ToStringOrder() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }

        private Object readResolve() {
            return STRING_FORM_ORDER;
        }

        public String toString() {
            return "toStringOrder()";
        }
    }
}

