%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Making the CLFS System Bootable</title>
@y
  <title>CLFS システムのブート設定</title>
@z

@x
    <secondary>bootable</secondary>
@y
    <secondary>ブート設定</secondary>
@z

@x
  <para os="a">Your shiny new CLFS system is almost complete. One of the last
  things to do is to ensure that the system can be properly booted. The
  instructions below apply only to computers of x86 and x86_64 architecture,
  meaning mainstream PCs. Information on <quote>boot loading</quote> for
  other architectures should be available in the usual resource-specific
  locations for those architectures.</para>
@y
  <para os="a">
  輝かしいあなたの CLFS システムはあと少しで完成です。
  ここですべきことはまず、システムを適切に起動できるようにすることです。
  これ以降に示す手順は x86 および x86_64 アーキテクチャー向け、いわば主流のコンピューター向けのものです。
  他のアーキテクチャーに対する<quote>ブートローディング</quote>の情報については、個々のアーキテクチャーのリソース関連の説明を参照してください。
  </para>
@z

@x
  <para os="b">Boot loading can be a complex area, so a few cautionary words
  are in order. Be familiar with the current boot loader and any other
  operating systems present on the hard drive(s) that need to be bootable.
  Make sure that an emergency boot disk is ready to <quote>rescue</quote>
  the computer if the computer becomes unusable (un-bootable).</para>
@y
  <para os="b">
  ブートローディングというものは複雑に入り組んでいます。
  そこで注意すべき点を順に説明していきます。
  ご自身が現時点で利用しているブートローダーが何であるのか、あるいはブートを必要とする他のオペレーティングシステムがハードドライブに存在しているかどうかについては、よく確認しておいてください。
  またコンピューターが利用不能に (ブート不能に)
  なってしまうことに備えて、コンピューターを<quote>復旧 (resucue)</quote>するブートディスクの生成も忘れないでください。
  </para>
@z

@x
    <para>The following command will overwrite the current boot loader.
    Do not run the command if this is not desired, for example, if using
    a third party boot manager to manage the Master Boot Record (MBR).
    In this scenario, it would make more sense to install GRUB into the
    <quote>boot sector</quote> of the CLFS partition. In this case, this
    next command would become <userinput>grub-install /dev/sda2</userinput>
    .</para>
@y
    <para>
    以下に示すコマンドを実行すると、現在のブートローダーを上書きします。
    上書きするのが不適当であるならコマンドを実行しないでください。
    例えばマスターブートレコード (Master Boot Record; MBR) を管理するサードパーティ製のブートマネージャーソフトウェアを利用している場合などがこれに該当します。
    ここでは CLFS パーティションの<quote>ブートセクター</quote>に GRUB をインストールします。
    その場合、以下のコマンドは <userinput>grub-install /dev/sda2</userinput> となります。
    </para>
@z

@x
  <para os="e">Instruct GRUB to install itself into the MBR of
  <filename class="partition">sda</filename>:</para>
@y
  <para os="e">
  <filename class="partition">sda</filename> の MBR に GRUB をインストールするには以下を実行します。
  </para>
@z

@x
  <para os="c">Next, we need to generate a configuration for GRUB.
  In previous versions of grub we could create the configuration manually
  here, but with GRUB2 we can generate <filename>grub.cfg</filename>
  automatically. You can do this with the following command:</para>
@y
  <para os="c">
  次には GRUB の設定ファイルを生成する必要があります。
  GRUB の以前のバージョンでは設定ファイルを手動で生成することが必要でした。
  しかし GRUB2 では <filename>grub.cfg</filename> を自動生成できるようになっています。
  以下のコマンドにより実現します。
  </para>
@z