%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The Bzip2 package contains programs for compressing and
    decompressing files. Compressing text files with <command>bzip2</command>
    yields a much better compression percentage than with the traditional
    <command>gzip</command>.</para>
@y
    <para>
    Bzip2 パッケージはファイル圧縮、伸長 (解凍) を行うプログラムを提供します。
    これまでよく用いられてきた <command>gzip</command> に比べて <command>bzip2</command> の方が圧縮率の高いファイルを生成できます。
    </para>
@z

@x
    <title>Installation of Bzip2</title>
@y
    <title>&InstallationOf1;Bzip2 &InstallationOf2;</title>
@z

@x
    <para os="s1">By default Bzip2 creates some symlinks that use absolute
    pathnames. The following sed will cause them to be created with relative
    paths instead:</para>
@y
    <para os="s1">
    デフォルトにおいて Bzip2 は絶対パスを含むシンボリックリンクを生成します。
    以下の sed コマンドはそれを相対パスとなるように変更するものです。
    </para>
@z

@x
    <para os="s3">Make Bzip2 install its manpages in
    <filename class="directory">/usr/share/man</filename> instead of
    <filename class="directory">/usr/man</filename>:</para>
@y
    <para os="s3">
    Bzip2 の man ページのインストールディレクトリを <filename
    class="directory">/usr/man</filename> ではなく <filename
    class="directory">/usr/share/man</filename> となるようにします。
    </para>
@z

@x
    <para os="a">The Bzip2 package does not contain a <command>configure</command>
    script. Compile it with:</para>
@y
    <para os="a">
    Bzip2 パッケージに <command>configure</command> スクリプトはありません。
    ビルドは以下のようにします。
    </para>
@z

@x
    <para os="c">The <parameter>-f</parameter> flag will cause Bzip2 to be built
    using a different <filename>Makefile</filename> file, in this case the
    <filename>Makefile-libbz2_so</filename> file, which creates a dynamic
    <filename class="libraryfile">libbz2.so</filename> library and links the
    Bzip2 utilities against it.</para>
@y
    <para os="c">
    <parameter>-f</parameter> フラグは Bzip2 のビルドにあたって通常の <filename>Makefile</filename> ファイルではなく <filename>Makefile-libbz2_so</filename> ファイルを利用することを指示します。
    これはダイナミックライブラリ <filename class="libraryfile">libbz2.so</filename> をビルドし Bzip2 の各種プログラムをこれにリンクします。
    </para>
@z

@x
    <para os="d">Recompile the package using a non-shared library and test it:</para>
@y
    <para os="d">
    共有ライブラリは使わずに再度ビルドを行います。
    同時にテストも行われます。
    </para>
@z

@x
    <para os="g">Install the programs:</para>
@y
    <para os="g">&InstallThePackage;</para>
@z

@x
    <para os="i">Install the shared <command>bzip2</command> binary into the
    <filename class="directory">/bin</filename> directory, make
    some necessary symbolic links, and clean up:</para>
@y
    <para os="i">
    実行モジュール <command>bzip2-shared</command> を <filename
    class="directory">/bin</filename> ディレクトリにインストールします。
    また必要なシンボリックを生成し整理します。
    </para>
@z

@x
    <title>Contents of Bzip2</title>
@y
    <title>&ContentsOf1;Bzip2 &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed libraries</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledLibrary;</segtitle>
@z

@x
        <seg>bunzip2 (link to bzip2), bzcat (link to bzip2), bzcmp (link to
        bzdiff), bzdiff, bzegrep (link to bzgrep), bzfgrep (link to bzgrep),
        bzgrep, bzip2, bzip2recover, bzless (link to bzmore), bzmore</seg>
        <seg>libbz2.a, libbz2.so (link to libbz2.so.1.0), libbz2.so.1.0 (link to
        libbz2.so.&bzip2-version;), libbz2.so.&bzip2-version;</seg>
@y
        <seg>bunzip2 (&LinkTo1;bzip2 &LinkTo2;), bzcat (&LinkTo1;bzip2 &LinkTo2;),
        bzcmp (&LinkTo1;bzdiff &LinkTo2;), bzdiff, bzegrep (&LinkTo1;bzgrep &LinkTo2;),
        bzfgrep (&LinkTo1;bzgrep &LinkTo2;),
        bzgrep, bzip2, bzip2recover, bzless (&LinkTo1;bzmore &LinkTo2;), bzmore</seg>
        <seg>libbz2.a, libbz2.so (&LinkTo1;libbz2.so.1.0 &LinkTo2;),
        libbz2.so.1.0 (&LinkTo1;libbz2.so.&bzip2-version; &LinkTo2;), libbz2.so.&bzip2-version;</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x bunzip2
          <para>Decompresses bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルを解凍します。</para>
@z

@x bzcat
          <para>Decompresses to standard output</para>
@y
          <para>解凍結果を標準出力に出力します。</para>
@z

@x bzcmp
          <para>Runs <command>cmp</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>cmp</command> を実行します。</para>
@z

@x bzdiff
          <para>Runs <command>diff</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>diff</command> を実行します。</para>
@z

@x bzegrep
          <para>Runs <command>egrep</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>egrep</command> を実行します。</para>
@z

@x bzfgrep
          <para>Runs <command>fgrep</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>fgrep</command> を実行します。</para>
@z

@x bzgrep
          <para>Runs <command>grep</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>grep</command> を実行します。</para>
@z

@x bzip2
          <para>Compresses files using the Burrows-Wheeler block sorting text
          compression algorithm with Huffman coding; the compression rate is
          better than that achieved by more conventional compressors using
          <quote>Lempel-Ziv</quote> algorithms, like <command>gzip</command></para>
@y
          <para>
          ブロックソート法 (バロウズ-ホイラー変換) とハフマン符号化法を用いてファイル圧縮を行います。
          圧縮率は、従来用いられてきた<quote>Lempel-Ziv</quote>アルゴリズムによるもの、例えば <command>gzip</command> コマンドによるものに比べて高いものです。
          </para>
@z

@x bzip2recover
          <para>Tries to recover data from damaged bzipped files</para>
@y
          <para>
          壊れた bzip2 ファイルの復旧を試みます。
          </para>
@z

@x bzless
          <para>Runs <command>less</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>less</command> を実行します。</para>
@z

@x bzmore
          <para>Runs <command>more</command> on bzipped files</para>
@y
          <para>bzip2 で圧縮されたファイルに対して <command>more</command> を実行します。</para>
@z

@x libbz2*
          <para>The library implementing lossless, block-sorting data
          compression, using the Burrows-Wheeler algorithm</para>
@y
          <para>
          ブロックソート法 (バロウズ-ホイラー変換) による可逆的なデータ圧縮を提供するライブラリ。
          </para>
@z