%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Cross GCC-&gcc-version; - Static</title>
@y
  <title>クロス GCC-&gcc-version; - スタティック</title>
@z

@x
    <secondary>cross tools, static</secondary>
@y
    <secondary>&CrossTools;, スタティック</secondary>
@z

@x
    <title>Installation of Cross GCC Compiler with Static libgcc
    and no Threads</title>
@y
    <title>
    クロス GCC コンパイラー (スタティック libgcc、Threads なし) のインストール
    </title>
@z

@x
    <para os="e">Here we will compile GCC, as a cross-compiler that will create
    executables for our target architecture, statically so that it will not
    need to look for Glibc's startfiles, which do not yet exist in
    <filename class="directory">/tools</filename>. We will use this
    cross-compiler, plus the cross-linker we have just installed with Binutils,
    to compile Glibc. After Glibc is installed into
    <filename class="directory">/tools</filename>, we can rebuild GCC
    so that it will then be able to build executables that link against the
    libraries in <filename class="directory">/tools</filename>.</para>
@y
    <para os="e">
    ターゲットアーキテクチャーの実行モジュールを生成する、クロスコンパイラーとしての GCC をビルドします。
    スタティックに生成するので Glibc のスタートファイルを参照することはありません。
    そもそもこのスタートファイルは <filename class="directory">/tools</filename> ディレクトリに存在していません。
    このクロスコンパイラーと Binutils にてインストールしたクロスリンカーを使って、この後に Glibc をビルドします。
    そして Glibc を <filename class="directory">/tools</filename> ディレクトリにインストールした後に GCC を再ビルドします。
    こうすることで <filename class="directory">/tools</filename> ディレクトリ内にあるライブラリをリンクする実行モジュールのビルドが可能となります。
    </para>
@z

@x
    <para os="aa">Make a couple of essential adjustments to GCC's specs
    to ensure GCC uses our build environment:</para>
@y
    <para os="aa">
    GCC のスペックに対して必要な調整を行い、GCC が当環境内で稼動できるようにします。
    </para>
@z

@x
    <para os="ag">Change the StartFile Spec so that GCC looks in 
<filename class="directory">/tools</filename>:</para>
@y
    <para os="ag">
    StartFile Spec ファイルを変更して GCC が <filename class="directory">/tools</filename> を参照するようにします。
    </para>
@z

@x
    <para os="t1">We will create a dummy <filename>limits.h</filename> so
    the build will not use the one provided by the host distro:</para>
@y
    <para os="t1">
    ダミーの <filename>limits.h</filename> ファイルを生成します。
    これはビルド時にホストシステムにある同ファイルを利用しないようにするためです。
    </para>
@z

@x
      <title>The meaning of the new configure options:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --build=${CLFS_HOST}
          <para>This specifies the system on which the cross-compiler is being
          built.</para>
@y
          <para>
          クロスコンパイラーをビルドするシステムを指定します。
          </para>
@z

@x --with-local-prefix=/tools
          <para>The purpose of this switch is to remove <filename
          class="directory">/usr/local/include</filename> from
          <command>gcc</command>'s include search path. This is not
          absolutely essential, however, it helps to minimize the
          influence of the host system.</para>
@y
          <para>
          このスイッチは <command>gcc</command> のインクルード探索パスから <filename
          class="directory">/usr/local/include</filename> を取り除くのが目的です。
          これは絶対に必要なものではなく、ホストシステムの影響を最小にするためのものです。
          </para>
@z

@x --with-native-system-headers-dir=/tools/include
          <para>This switch ensures that GCC will search for the system headers
           in <filename class="directory">/tools/include</filename> and that
           host system headers will not be searched.</para>
@y
          <para>
          このスイッチはシステムヘッダーファイルを <filename
          class="directory">/tools/include</filename> ディレクトリから探索するようにするものであり、ホストシステムのヘッダーファイルを探さないようにします。
          </para>
@z

@x --disable-shared
          <para>This tells GCC not to create a shared library.</para>
@y
          <para>
          共有ライブラリは生成しないようにします。
          </para>
@z

@x --without-headers
          <para>Disables GCC from using the target's Libc when cross compiling.</para>
@y
          <para>
          クロスコンパイル時なのでターゲットの Libc ヘッダーは用いないようにします。
          </para>
@z

@x --with-newlib
          <para>This causes GCC to enable the <envar>inhibit_libc</envar> flag,
          which prevents <filename class="libraryfile">libgcc</filename>
          from building code that uses libc support.</para>
@y
          <para>
          <envar>inhibit_libc</envar> フラグを有効にします。
          これは <filename class="libraryfile">libgcc</filename> のビルドにおいて libc をサポートするコードは生成しないようにします。
          </para>
@z

@x --disable-decimal-float
          <para>Disables support for the C decimal floating point extension.</para>
@y
          <para>
          C の 10進浮動小数点制御を無効にします。
          </para>
@z

@x --disable-lib*
          <para>These options prevent GCC from building a number of libraries
          that are not needed at this time.</para>
@y
          <para>
          これらのオプションはこの時点では必要ない多くのライブラリを生成しないようにします。
          </para>
@z

@x --disable-threads
          <para>This will prevent GCC from looking for the multi-thread
          include files, since they haven't been created for this architecture
          yet. GCC will be able to find the multi-thread information after
          the Glibc headers are created.</para>
@y
          <para>
          マルチスレッドのインクルードファイルを探索しないようにします。
          この時点においてそのアーキテクチャーのファイルが生成されていないためです。
          GCC がマルチスレッドの情報を利用できるようになるには、この後に Glibc のヘッダーファイルが生成されてからです。
          </para>
@z

@x --with-system-zlib
          <para>This tells GCC to link to the system-installed zlib instead
          of the one in its source tree.</para>
@y
          <para>
          システムに既にインストールされている Zlib ライブラリをリンクすることを指示するものであり、ソースツリー内に同梱されているものを用いないようにします。
          </para>
@z

@x --enable-languages=c
          <para>This option ensures that only the C compiler is built.</para>
@y
          <para>
          C コンパイラーのみをビルドすることを指示します。
          </para>
@z

@x --with-glibc-version=&glibc-version;
          <para>Needed when bootstrapping a cross toolchain without the header
          files avilable for building the initial bootstrap compiler.</para>
@y
          <para>
          クロスツールチェーンをブートストラップするために必要で、初期のブートストラップコンパイラーを構築するために必要なヘッダーファイルがなくても実現できるようにします。
          </para>
@z

@x
    <para os="an">Continue with compiling the package:</para>
@y
    <para os="an">&CompileThePackage;</para>
@z

@x
      <title>The meaning of the new make options:</title>
@y
      <title>&MeaningOfOption1;make &MeaningOfOption2;</title>
@z

@x all-gcc all-target-libgcc
          <para>Compiles only the parts of GCC that are needed at this time,
          rather than the full package.</para>
@y
          <para>
          GCC はこの段階において一部分が必要なのであって、パッケージすべてを必要としていません。
          </para>
@z

@x
    <para os="aq">Install the package:</para>
@y
    <para os="aq">&InstallThePackage;</para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-gcc" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-gcc" role=""/>&Details2;
    </para>
@z