%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Boot-scripts for CLFS &boot-scripts-clfs-version;</title>
@y
  <title>CLFS &boot-scripts-clfs-version; 用の Boot-scripts</title>
@z

@x
    <primary sortas="a-Boot-scripts">Boot-scripts</primary>
@y
    <primary sortas="a-Boot-scripts">Boot-scripts</primary>
@z

@x
    <para>The Boot-scripts package contains a set of scripts to
    start/stop the CLFS system at bootup/shutdown.</para>
@y
    <para>
    Boot-scripts パッケージは CLFS システムの起動、終了とともに実行する一連のスクリプトを提供します。
    </para>
@z

@x
    <title>Installation of Boot-scripts</title>
@y
    <title>&InstallationOf1;Boot-scripts &InstallationOf2;</title>
@z

@x
    <para os="a">Install the package:</para>
@y
    <para os="a">&InstallThePackage;</para>
@z

@x
  <para os="c">The <command>setclock</command> script reads the time from the
  hardware clock, also known as the BIOS or the Complementary Metal Oxide
  Semiconductor (CMOS) clock. If the hardware clock is set to UTC, this
  script will convert the hardware clock's time to the local time using
  the <filename>/tools/etc/sysconfig/clock</filename> file (which tells the
  <command>hwclock</command> program which timezone the user is in). There
  is no way to detect whether or not the hardware clock is set to UTC, so
  this needs to be configured manually.</para>
@y
  <para os="c">
  <command>setclock</command> スクリプトはハードウェアクロックから時刻を読み取ります。
  ハードウェアクロックは BIOS クロック、あるいは CMOS (Complementary Metal Oxide Semiconductor) クロックとしても知られているものです。
  ハードウェアクロックが UTC に設定されていると <command>setclock</command> スクリプトは <filename>/etc/localtime</filename> ファイルを参照して、ハードウェアクロックの示す時刻をローカル時刻に変換します。
  <filename>/etc/localtime</filename> ファイルは <command>hwclock</command> プログラムに対して、ユーザーがどのタイムゾーンに位置するかを伝えます。
  ハードウェアクロックが UTC に設定されているかどうかを知る方法はないので、手動で設定を行う必要があります。
  </para>
@z

@x
  <para os="d">If you do not know whether or not the hardware clock is set to UTC,
  you can find out after you have booted the new machine by running the
  <userinput>hwclock --localtime  --show</userinput> command, and if
  necessary editing the <filename>/tools/etc/sysconfig/clock</filename> file.
  The worst that will happen if you make a wrong guess here is that the
  time displayed will be wrong.</para>
@y
  <para os="d">
  ハードウェアクロックが UTC に設定されているかどうか分からない場合は、新たなシステムの起動後に <userinput>hwclock --localtime --show</userinput> を実行すれば確認できます。
  必要なら <filename>/tools/etc/sysconfig/clock</filename> ファイルを編集してください。
  ここで設定した内容に誤りがあれば表示される時刻表示が誤ったものとなります。
  </para>
@z

@x
  <para os="e">Change the value of the <envar>UTC</envar> variable below
  to a value of <option>0</option> (zero) if the hardware clock
  is <emphasis>not</emphasis> set to UTC time.</para>
@y
  <para os="e">
  ハードウェアクロックが UTC 時刻として設定<emphasis>されていない</emphasis>場合は、以下に示す変数 <envar>UTC</envar> の値を <parameter>0</parameter> (ゼロ) にしてください。
  </para>
@z

@x
    <title>Contents of Boot-scripts</title>
@y
    <title>&ContentsOf1;Boot-scripts &ContentsOf2;</title>
@z

@x
      <segtitle>Installed scripts</segtitle>
@y
      <segtitle>&InstalledScripts;</segtitle>
@z

@x
        <seg>checkfs, cleanfs, functions, halt, localnet, mountfs, mountkernfs,
        rc, reboot, sendsignals, setclock, swap, and udev.</seg>
@y
        <seg>checkfs, cleanfs, functions, halt, localnet, mountfs, mountkernfs,
        rc, reboot, sendsignals, setclock, swap, udev.</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x checkfs
          <para>Checks the integrity of the file systems before they are
          mounted (with the exception of journal and network based file
          systems)</para>
@y
          <para>
          ファイルシステムがマウントされる前にその整合性をチェックします。
          (ただしジャーナルファイルシステムとネットワークベースのファイルシステムは除きます。)
          </para>
@z

@x cleanfs
          <para>Removes files that should not be preserved between reboots,
          such as those in <filename class="directory">/run/</filename>
          and <filename class="directory">/var/lock/</filename>; it re-creates
          <filename>/run/utmp</filename> and removes the possibly present
          <filename>/etc/nologin</filename>, <filename>/fastboot</filename>,
          and <filename>/forcefsck</filename> files</para>
@y
          <para>
          リブートの際に不要となるファイルを削除します。
          例えば <filename class="directory">/run/</filename> ディレクトリや <filename
          class="directory">/var/lock/</filename> ディレクトリの配下にあるファイルです。
          <filename>/run/utmp</filename> ファイルは再生成されます。
          また <filename>/etc/nologin</filename>、<filename>/fastboot</filename>、<filename>/forcefsck</filename> がおそらく存在しており、これらは削除されます。
          </para>
@z

@x functions
          <para>Contains common functions, such as error and status checking,
          that are used by several boot-scripts</para>
@y
          <para>
          共通的な関数を提供します。
          例えばエラーやステータスのチェックなどであり、これはブートスクリプトの多くが利用します。
          </para>
@z

@x halt
          <para>Halts the system</para>
@y
          <para>
          システムを停止します。
          </para>
@z

@x localnet
          <para>Sets up the system's hostname and local loopback device</para>
@y
          <para>
          システムのホスト名とローカルループバックデバイスを設定します。
          </para>
@z

@x mountfs
          <para>Mounts all file systems, except ones that are marked
          <emphasis>noauto</emphasis> or are network based</para>
@y
          <para>
          ファイルシステムをすべてマウントします。
          ただし <emphasis>noauto</emphasis> が設定されているものやネットワークベースのファイルシステムは除きます。
          </para>
@z

@x mountkernfs
          <para>Mounts virtual kernel file systems, such as
          <systemitem class="filesystem">proc</systemitem></para>
@y
          <para>
          仮想カーネルファイルシステムをマウントします。
          例えば <systemitem class="filesystem">proc</systemitem> などです。
          </para>
@z

@x rc
          <para>The master run-level control script; it is responsible for
          running all the other boot-scripts one-by-one, in a sequence
          determined by the name of the symbolic links being processed</para>
@y
          <para>
          ランレベルを制御するマスタースクリプト。
          他のブートスクリプトを一つずつ実行します。
          その際には実行されるシンボリックの名前によって実行順序を決定します。
          </para>
@z

@x reboot
          <para>Reboots the system</para>
@y
          <para>
          システムを再起動します。
          </para>
@z

@x sendsignals
          <para>Makes sure every process is terminated before the system reboots
          or halts</para>
@y
          <para>
          システムが再起動または停止する前に、プロセスすべてが停止していることを確認します。
          </para>
@z

@x setclock
          <para>Resets the kernel clock to local time in case the hardware clock
          is not set to UTC time</para>
@y
          <para>
          ハードウェアクロックが UTC 時刻に設定されていなければ、カーネルクロックをローカル時刻としてリセットします。
          </para>
@z

@x swap
          <para>Enables and disables swap files and partitions</para>
@y
          <para>
          スワップファイルやスワップパーティションを有効または無効にします。
          </para>
@z

@x udev
          <para>Starts and stops the Eudev daemon</para>
@y
          <para>
          Eudev デーモンの起動、停止を行います。
          </para>
@z