%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>temporary system</secondary>
@y
    <secondary>&TemporarySystem;</secondary>
@z

@x
    <title>Installation of VIM</title>
@y
    <title>&InstallationOf1;VIM &InstallationOf2;</title>
@z

@x
    <para os="a">We will cross-compile Vim so that we can have a text editor in
    <filename class="directory">/tools</filename>. Vim is not technically
    necessary in the temporary system, in that it is not there to satisfy any
    package dependencies in the final system, but we believe that a text editor
    is an extremely useful tool to have there.<!-- If you prefer a different
    editor, you may check the hints project at <ulink url="&hints-root;" />
    for information on cross-compiling other text editors. (placeholder - 
    uncomment this sentence if/when such information actually exists)--></para>
@y
    <para os="a">
    Vim をクロスコンパイルします。
    このテキストエディターを <filename class="directory">/tools</filename> ディレクトリにインストールします。
    技術的に言えば Vim は一時システムには不要です。
    一時システムになかったとしても、最終システムにおけるパッケージの依存関係には何ら影響しません。
    しかしテキストエディターというものは極めて有用なツールであることからビルドしておくことにします。
    <!-- If you prefer a different
    editor, you may check the hints project at <ulink url="&hints-root;" />
    for information on cross-compiling other text editors. (placeholder - 
    uncomment this sentence if/when such information actually exists)-->
    </para>
@z

@x
    <para os="c1">The <command>configure</command> script is full of logic
    that aborts at the first sign of cross compiling. Work around this by
    setting the cached values of several tests with the following
    command:</para>
@y
    <para os="c1">
    <command>configure</command> スクリプトには、クロスコンパイルであることが検出された時点で処理中断する箇所がいくつもあります。
    これを回避するために数種のテストに対応するキャッシュ値を以下のコマンドにより設定します。
    </para>
@z

@x
    <para os="b">Change the default location of
    the <filename>vimrc</filename> configuration file to <filename
    class="directory">/tools/etc</filename>:</para>
@y
    <para os="b">
    設定ファイル <filename>vimrc</filename> のインストール先を、デフォルトのものでなく <filename
    class="directory">/tools/etc</filename> にします。
    </para>
@z

@x
      <title>The meaning of the new configure options:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x --enable-gui=no --disable-gtktest --disable-xim --disable-gpm --without-x --disable-netbeans
          <para>These options prevent Vim from trying to link to libraries
          that might be on the host but won't exist inside the temporary
          build environment.</para>
@y
          <para>
          これらのオプションは、一時システム内に存在していないライブラリであるにも関わらず、ホストシステムに存在するために Vim がリンクしてしまうことを回避します。
          </para>
@z

@x --with-tlib=ncurses
          <para>Tells Vim to use Ncurses as its terminal library.</para>
@y
          <para>
          端末ライブラリとして Ncurses を用いることを指示します。
          </para>
@z

@x
    <para os="tv1">Create a temporary vimrc to make it function more the way you may
    expect it to. This is explained more in the final system:</para>
@y
    <para os="tv1">
    vimrc ファイルを一時的に生成し各種機能を実現します。
    これに関しては最終システムの手順において詳しく説明します。
    </para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-vim" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-vim" role=""/>&Details2;
    </para>
@z