%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Static Networking Configuration</title>
@y
  <title>スタティックなネットワーク設定</title>
@z

@x
    <title>Creating the Static Network Interface Configuration Files</title>
@y
    <title>スタティックネットワークインターフェイス向け設定ファイルの生成</title>
@z

@x
    <para>Which interfaces are brought up and down by the network script
    depends on the files and directories in the <filename
    class="directory">/etc/sysconfig</filename> hierarchy.
    This directory should contain a sub-directory for each interface to be
    configured, such as <filename>ifconfig.xyz</filename>, where
    <quote>xyz</quote> is a network interface name. Inside this directory
    would be files defining the attributes to this interface, such as its IP
    address(es), subnet masks, and so forth.</para>
@y
    <para>
    どのネットワークインターフェースが起動したり停止したりするかは <filename
    class="directory">/etc/sysconfig/</filename> ディレクトリ配下のファイルの指定によります。
    このディレクトリには、設定を行ないたい各ネットワークインターフェースに対するファイル <filename>ifconfig.xyz</filename> を準備します。
    この<quote>xyz</quote>はネットワークカードインターフェース名 (例えば eth0 など) です。
    このファイルにはネットワークインターフェースの属性、つまり IP アドレスやサブネットマスクなどを定義します。
    </para>
@z

@x
    <note><para>Udev may assign random Network Card Interface names
    for some network cards such as enp2s1. If you are not sure what
    your Network Card Interface name is, you can always run
    <command>ip l</command> after you have booted your system. Again,
    it is important that <filename>ifconfig.xyz</filename> is named
    after correct Network Card Interface name (e.g.
    <filename>ifconfig.enp2s1</filename> or
    <filename>ifconfig.eth0</filename>) or systemd will fail to bring
    up your network interface.</para></note>
@y
    <note><para>
    Udev はシステムの物理的な特性に従った enp2s1 などのような名称をネットワークカードインターフェースに割り当てます。
    インタフェース名がよく分からない場合は、システム起動直後に <command>ip l</command> を実行すれば確認することができます。
    繰り返しますが <filename>ifconfig.xyz</filename> という名称はネットワークカードインターフェースを示す正しい名称 (つまり <filename>ifconfig.enp2s1</filename> や <filename>ifconfig.eth0</filename>) としなければなりません。
    これを行っていない場合には、systemd によるネットワークインターフェースの初期化がなされないことになります。
    </para></note>
@z

@x
    <para>The following command creates a sample <filename>ipv4</filename>
    file for the <emphasis>eth0</emphasis> device:</para>
@y
    <para>
    以下のコマンドは <emphasis>eth0</emphasis> デバイスに対しての <filename>ipv4</filename> のサンプル設定ファイルを生成します。
    </para>
@z

@x
    <para os="var-ob">The values of these variables must be changed in every
    file to match the proper setup.</para>
@y
    <para os="var-ob">
    各変数の値は、このような設定ファイルの個々において適切なものに書き換えてください。
    </para>
@z

@x
    <para os="var-i">The <envar>IFACE</envar> variable defines the interface
    name, for example, eth0. It is required for all network device configuration
    files.</para>
@y
    <para os="var-i">
    変数 <envar>IFACE</envar> はインターフェース名を定義します。
    例えば eth0 です。
    ネットワークデバイスの設定ファイルにはこれを必ず記述します。
    </para>
@z

@x
    <para os="var-s">The <envar>SERVICE</envar> variable defines the method used
    for obtaining the IP address. The CLFS-Network-Scripts package has a modular
    IP assignment format, and creating additional files in the <filename
    class="directory">/lib/services</filename>
    directory allows other IP assignment methods.</para>
@y
    <para os="var-s">
    変数 <envar>SERVICE</envar> は IP アドレスの取得方式を定義します。
    CLFS ネットワークスクリプトパッケージにはモジュール化した IP アドレス割り当てフォーマットがあります。
    <filename class="directory">/lib/services</filename> ディレクトリ内に設定ファイルを置くことで、別の IP アドレス割り当て方式を採用することもできます。
    </para>
@z

@x
    <para>The <envar>GATEWAY</envar> variable should contain the default
    gateway IP address, if one is present. If not, then comment out the
    variable entirely.</para>
@y
    <para>
    変数 <envar>GATEWAY</envar> はデフォルトゲートウェイが存在する場合に、その IP アドレスを設定します。
    存在しない場合はこの変数設定全体をコメントにしてください。
    </para>
@z

@x
    <para>The <envar>PREFIX</envar> variable needs to contain the number of
    bits used in the subnet. Each octet in an IP address is 8 bits. If the
    subnet's netmask is 255.255.255.0, then it is using the first three octets
    (24 bits) to specify the network number. If the netmask is 255.255.255.240,
    it would be using the first 28 bits.  Prefixes longer than 24 bits are
    commonly used by DSL and cable-based Internet Service Providers (ISPs).
    In this example (PREFIX=24), the netmask is 255.255.255.0. Adjust the
    <envar>PREFIX</envar> variable according to your specific subnet.</para>
@y
    <para>
    変数 <envar>PREFIX</envar> はサブネットマスクにて用いられるビット数を指定します。
    IP アドレスの各オクテット (octet) は 8 ビットで構成されます。
    例えばサブネットマスクが 255.255.255.0 である場合、ネットワーク番号 (network number) を特定するには最初の三つのオクテット (24ビット) が用いられることを意味します。
    もし 255.255.255.240 であるなら、最初の 28 ビットということになります。
    24 ビットを超えるプレフィックスは、通常は DSL やケーブルを用いたインターネットサービスプロバイダー (Internet Service Provider; ISP) がよく利用しています。
    上の例 (PREFIX=24) では、サブネットマスクは 255.255.255.0 となります。
    <envar>PREFIX</envar> 変数の値は、ネットワーク環境に応じて変更してください。
    </para>
@z

@x
    <para>For more information see the <command>ifup</command> man page.</para>
@y
    <para>
    詳しくは <command>ifup</command> の man ページを参照してください。
    </para>
@z

@x
    <para>To configure another DHCP Interface, Follow <xref linkend="ch-network-dhcpcd"/>.</para>
@y
    <para>
    これ以外に DHCP インターフェースを設定する場合は <xref linkend="ch-network-dhcpcd"/> に進んでください。
    </para>
@z

@x
    <title>Configuring the Network Interface at boot</title>
@y
    <title>ネットワークインターフェースの起動時設定</title>
@z

@x
    <para>Enabling of the Network Interface configuration is
    done per interface. To enable Network Interface
    configuration at boot, run:</para>
@y
    <para>
    ネットワークインターフェースに対する設定は各インターフェースごとに行います。
    ネットワークインターフェースの設定を起動時に有効とするためには以下を実行します。
    </para>
@z

@x
    <para>To disable previously enabled Network Interface
    configuration at boot, run:</para>
@y
    <para>
    逆にネットワークインターフェースの設定を起動時に無効にするには以下を実行します。
    </para>
@z

@x
    <para>To manually start the Network Interface configuration,
    run:</para>
@y
    <para>
    ネットワークインターフェースの設定を手動で有効にするには以下を実行します。
    </para>
@z

@x
    <para>Replace eth0 with the correct Network Interface
    name as described on the beginning of this page.</para>
@y
    <para>
    上で説明しているように eth0 の部分はネットワークインターフェース名に合わせて書き換えてください。
    </para>
@z