%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The Vim package contains a powerful text editor.</para>
@y
    <para>
    Vim パッケージは強力なテキストエディターを提供します。
    </para>
@z

@x
    <title>Installation of Vim</title>
@y
    <title>&InstallationOf1;Vim &InstallationOf2;</title>
@z

@x
      <title>Alternatives to Vim</title>
@y
      <title>Vim 以外の選択</title>
@z

@x
      <para>If you prefer another editor&mdash;such as Emacs, Joe, or
      Nano&mdash;please refer to <ulink
      url="&cblfs-root;index.php/Category:Text_Editors"/>
      for suggested installation instructions.</para>
@y
      <para>
      もし Emacs、Joe、Nano など他のエディターを用いたい場合は <ulink
      url="&cblfs-root;index.php/Category:Text_Editors"/> に示される手順に従ってインストールしてください。
      </para>
@z

@x
    <para os="p1">The following patch merges all updates from the &vim-version; Branch
    from the Vim developers:</para>
@y
    <para os="p1">
    以下のパッチは Vim 開発者が提供する &vim-version; ブランチ以降のアップデートを集めたものです。
    </para>
@z

@x
    <para os="b">Change the default location of
    the <filename>vimrc</filename> configuration file to <filename
    class="directory">/etc</filename>:</para>
@y
    <para os="b">
    設定ファイル <filename>vimrc</filename> のインストール先を、デフォルトのものでなく <filename
    class="directory">/etc</filename> にします。
    </para>
@z

@x
    <para os="d">Prepare Vim for compilation:</para>
@y
    <para os="d">&PreparePackage1;Vim &PreparePackage2;</para>
@z

@x
    <para os="g">Compile the package:</para>
@y
    <para os="g">&CompileThePackage;</para>
@z

@x
    <para os="i">To test the results, issue:</para>
@y
    <para os="i">
    ビルド結果をテストする場合は以下を実行します。
    </para>
@z

@x
    <para os="i3">However, this test suite outputs a lot of binary data to the
    screen, which can cause issues with the settings of the current terminal.
    This can be resolved by redirecting the output to a log file.</para>
@y
    <para os="i3">
    ただしこのテストスイートでは画面上にたくさんのバイナリデータを出力します。
    これは端末画面の設定によっては問題を引き起こします。
    これを避けるには出力をリダイレクトしてログファイルに出力するようにしてください。
    </para>
@z

@x
    <para os="j">Install the package:</para>
@y
    <para os="j">&InstallThePackage;</para>
@z

@x
    <para os="l">Many users are accustomed to using <command>vi</command>
    instead of <command>vim</command>. Some programs, such as
    <command>vigr</command> and <command>vipw</command>, also use
    <command>vi</command>. Create a symlink to permit execution of
    <command>vim</command> when users habitually enter <command>vi</command>
    and allow programs that use <command>vi</command> to work:</para>
@y
    <para os="l">
    ユーザーにとっては <command>vim</command> よりも <command>vi</command> というコマンドを使い慣れているかもしれません。
    <command>vigr</command> や <command>vipw</command> というプログラムは <command>vi</command> を使っています。
    そこでシンボリックリンクを生成し <command>vi</command> と入力しても <command>vim</command> が実行されるようにし、また <command>vi</command> を使っている各種プログラムも正常動作するようにします。
    </para>
@z

@x
<para os="n">By default, Vim's documentation is installed in
<filename class="directory">/usr/share/vim</filename>.  The following symlink
allows the documentation to be accessed via
<filename class="directory">/usr/share/doc/vim-&vim-version;</filename>, making
it consistent with the location of documentation for other packages:</para>
@y
<para os="n">
デフォルトでは Vim のドキュメントが <filename
class="directory">/usr/share/vim</filename> にインストールされます。
以下のようなシンボリックリンクを生成することで <filename
class="directory">/usr/share/doc/vim-&vim-version;</filename> へアクセスしてもドキュメントが参照できるようにし、他のパッケージが配置するドキュメントの場所と整合を取ります。
</para>
@z

@x
    <para os="p">If an X Window System is going to be installed on the CLFS
    system, you may want to recompile Vim after installing X. Vim
    comes with a GUI version of the editor that requires X and some
    additional libraries to be installed. For more information, refer to the
    Vim documentation and the Vim installation page in CBLFS at <ulink
    url="&cblfs-root;index.php/Vim"/>.</para>
@y
    <para os="p">
    CLFS システムに対して X ウィンドウシステムをインストールする場合 X のインストールの後で Vim を再コンパイルする必要があります。
    Vim には GUI 版があり X や他のライブラリがインストールされていて 初めて構築できるためです。
    この作業の詳細については Vim のドキュメントと CBLFS ブックの <ulink
    url="&cblfs-root;index.php/Vim"/> に示されている Vim のインストール説明のページを参照してください。
    </para>
@z

@x
    <title>Configuring Vim</title>
@y
    <title>&Configuring1;Vim &Configuring2;</title>
@z

@x
    <para>By default, <command>vim</command> runs in vi-incompatible mode.
    This may be new to users who have used other editors in the past. The
    <quote>nocompatible</quote> setting is included below to highlight the
    fact that a new behavior is being used. It also reminds those who would
    change to <quote>compatible</quote> mode that it should be the first
    setting in the configuration file. This is necessary because it changes
    other settings, and overrides must come after this setting. Create a
    default <command>vim</command> configuration file by running the
    following:</para>
@y
    <para>
    デフォルトで <command>vim</command> は Vi 非互換モード (vi-incompatible mode) で起動します。
    他のエディターを使ってきたユーザーにとっては、よく分からないものかもしれません。
    以下の設定における<quote>nocompatible</quote>(非互換) は、Vi の新しい機能を利用することを意味しています。
    もし<quote>compatible</quote>(互換) モードに変更したい場合は、この設定ファイルの冒頭にて行っておくことが必要です。
    このモード設定は他の設定を置き換えるものとなることから、まず初めに行っておかなければならないものだからです。
    以下のコマンドを実行して <command>vim</command> の設定ファイルを生成します。
    </para>
@z

@x
    <para>The <parameter>set nocompatible</parameter> makes
    <command>vim</command> behave in a more useful way (the default) than
    the vi-compatible manner. Remove the <quote>no</quote> to keep the
    old <command>vi</command> behavior. The <parameter>set
    backspace=2</parameter> allows backspacing over line breaks,
    autoindents, and the start of insert. The <parameter>syntax
    on</parameter> enables vim's syntax highlighting. Finally, the
    <emphasis>if</emphasis> statement with the <parameter>set
    background=dark</parameter> corrects <command>vim</command>'s guess
    about the background color of some terminal emulators. This gives the
    highlighting a better color scheme for use on the black background of
    these programs.</para>
@y
    <para>
    <parameter>set nocompatible</parameter> と設定しておくと vi 互換モードでの動作に比べて有用な動作となります。(これがデフォルトになっています。)
    その設定の記述から<quote>no</quote>の文字を取り除けば、旧来の <command>vi</command> コマンドの動作となります。
    <parameter>set backspace=2</parameter> を設定しておくと、行を超えてもバックスペースキーによる編集が可能となります。
    またインデントが自動的に行われ、コマンド起動時には自動的に挿入モードとなります。
    <parameter>syntax on</parameter> パラメーターを指定すれば vim の文法ハイライト (syntax highlighting) 機能が有効になります。
    最後にある <emphasis>if</emphasis> 文は、<parameter>set background=dark</parameter> を指定した場合に、特定の端末エミュレーター上において <command>vim</command> が背景色を誤って認識しないようにするためのものです。
    エミュレーターの背景色が黒色であった場合に、より適切なハイライトが実現できます。
    </para>
@z

@x
    <para>Documentation for other available options can be obtained by
    running the following command:</para>
@y
    <para>
    この他に利用できるオプションについては、以下のコマンドを実行することで出力される説明を参照してください。
    </para>
@z

@x
    <title>Contents of Vim</title>
@y
    <title>&ContentsOf1;Vim &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed directory</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>efm_filter.pl, efm_perl.pl, ex (link to vim), less.sh, mve.awk,
        pltags.pl, ref, rview (link to vim), rvim (link to vim), shtags.pl,
        tcltags, vi (link to vim), view (link to vim), vim, vim132, vim2html.pl,
        vimdiff (link to vim), vimm, vimspell.sh, vimtutor, xxd</seg>
        <seg>/usr/share/vim</seg>
@y
        <seg>efm_filter.pl, efm_perl.pl, ex (&LinkTo1;vim &LinkTo2;), less.sh, mve.awk,
        pltags.pl, ref, rview (&LinkTo1;vim &LinkTo2;), rvim (&LinkTo1;vim &LinkTo2;), shtags.pl,
        tcltags, vi (&LinkTo1;vim &LinkTo2;), view (&LinkTo1;vim &LinkTo2;), vim, vim132, vim2html.pl,
        vimdiff (&LinkTo1;vim &LinkTo2;), vimm, vimspell.sh, vimtutor, xxd</seg>
        <seg>/usr/share/vim</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x efm_filter.pl
          <para>A filter for creating an error file that can be read
          by <command>vim</command></para>
@y
          <para>
          <command>vim</command> によって読み取り可能なエラーファイルを生成するためのフィルター。
          </para>
@z

@x efm_perl.pl
          <para>Reformats the error messages of the Perl interpreter for use
          with the <quote>quickfix</quote> mode of <command>vim</command></para>
@y
          <para>
          <command>vim</command> の <quote>quickfix</quote> モードにおいて利用される Perl インタープリターのエラーメッセージを整形します。
          </para>
@z

@x ex
          <para>Starts <command>vim</command> in ex mode</para>
@y
          <para>
          <command>vim</command> を ex モードで起動します。
          </para>
@z

@x less.sh
          <para>A script that starts <command>vim</command> with less.vim</para>
@y
          <para>
          less.vim を使って <command>vim</command> を起動するためのスクリプト。
          </para>
@z

@x mve.awk
          <para>Processes <command>vim</command> errors</para>
@y
          <para>
          <command>vim</command> エラーを処理します。
          </para>
@z

@x pltags.pl
          <para>Creates a tags file for Perl code for use by
          <command>vim</command></para>
@y
          <para>
          <command>vim</command> にて利用される Perl コードに対してのタグファイルを生成します。
          </para>
@z

@x ref
          <para>Checks the spelling of arguments</para>
@y
          <para>
          引数のスペルをチェックします。
          </para>
@z

@x rview
          <para>Is a restricted version of <command>view</command>; no shell
          commands can be started and <command>view</command> cannot be
          suspended</para>
@y
          <para>
          <command>view</command> の機能限定版。
          シェルは起動できず、サスペンドも行うことはできません。
          </para>
@z

@x rvim
          <para>Is a restricted version of <command>vim</command>; no shell
          commands can be started and <command>vim</command> cannot be
          suspended</para>
@y
          <para>
          <command>vim</command> の機能限定版。
          シェルは起動できず、サスペンドも行うことはできません。
          </para>
@z

@x shtags.pl
          <para>Generates a tags file for Perl scripts</para>
@y
          <para>
          Perl スクリプトに対するタグファイルを生成します。
          </para>
@z

@x tcltags
          <para>Generates a tags file for TCL code</para>
@y
          <para>
          TCL コードに対するタグファイルを生成します。
          </para>
@z

@x view
          <para>Starts <command>vim</command> in read-only mode</para>
@y
          <para>
          <command>vim</command> を読み込み専用モード (read-only mode) で起動します。
          </para>
@z

@x vi
          <para>Link to <command>vim</command></para>
@y
          <para>
          <command>vim</command> へのリンク。
          </para>
@z

@x vim
          <para>Is the editor</para>
@y
          <para>
          エディター。
          </para>
@z

@x vim132
          <para>Starts <command>vim</command> with the terminal in 132-column
          mode</para>
@y
          <para>
          132カラムの端末において <command>vim</command> を起動します。
          mode
          </para>
@z

@x vim2html.pl
          <para>Converts Vim documentation to HypterText Markup Language
          (HTML)</para>
@y
          <para>
          Vim のドキュメントを HTML 形式に変換します。
          </para>
@z

@x vimdiff
          <para>Edits two or three versions of a file with <command>vim</command>
          and show differences</para>
@y
          <para>
          <command>vim</command> により、同一ファイルにおける２つまたは３つの版を同時に編集し、差異を表示します。
          </para>
@z

@x vimm
          <para>Enables the DEC locator input model on a remote terminal</para>
@y
          <para>
          リモート端末上において DEC ロケーター入力モデル (DEC locator input model) を有効にします。
          </para>
@z

@x vimspell.sh
          <para>Spell checks a file and generates the syntax statements
          necessary to highlight in <command>vim</command>. This script
          requires the old Unix <command>spell</command> command, which
          is provided neither in CLFS nor in CBLFS</para>
@y
          <para>
          スペルチェックを行い、<command>vim</command> 上での文法ハイライトを行います。
          このスクリプトではかつての Unix コマンド <command>spell</command> が必要ですが、これは CLFS や CBLFS では取り扱っていません。
          </para>
@z

@x vimtutor
          <para>Teaches the basic keys and commands of
          <command>vim</command></para>
@y
          <para>
          <command>vim</command> の基本的なキー操作とコマンドについて教えてくれます。
          </para>
@z

@x xxd
          <para>Creates a hex dump of the given file; it can
          also do the reverse, so it can be used for binary patching</para>
@y
          <para>
          指定されたファイルの内容を 16進数ダンプとして変換します。
          逆の変換も行うことができるため、バイナリパッチにも利用されます。
          </para>
@z