%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating Essential Symlinks</title>
@y
  <title>重要なシンボリックリンクの生成</title>
@z

@x
  <para os="a">Some programs use hard-wired paths to files which do not exist
  yet. In order to satisfy these programs, create a number of symbolic
  links which will be replaced by real files throughout the course of
  the next chapter after the software has been installed.</para>
@y
  <para os="a">
  プログラムの中には固定的に他のファイルへのパスを保持しているものがあります。
  そのパスは今の時点ではまだ存在していません。
  このようなプログラムを正しく動作させるため、シンボリックリンクをいくつか作成します。
  このリンクは次章の作業を通じて各種ソフトウェアをインストールしていくことで、その実体であるファイルに置き換えられていきます。
  </para>
@z

@x
    <title>The purpose of each link:</title>
@y
    <title>各リンクの目的:</title>
@z

@x /bin/bash
        <para>Many <command>bash</command> scripts specify
        <filename>/bin/bash</filename>.</para>
@y
        <para>
        <command>bash</command> スクリプトはたいていが <filename>/bin/bash</filename> を指定しています。
        </para>
@z

@x /bin/cat
        <para>This pathname is hard-coded into Glibc's configure script.</para>
@y
        <para>
        このパス名は Glibc の configure スクリプトにおいてハードコーディングされています。
        </para>
@z

@x /bin/echo
        <para>This is to satisfy one of the tests in Glibc's test suite, which
        expects <filename>/bin/echo</filename>.</para>
@y
        <para>
        Glibc のテストスイート内における1つのテストが <filename>/bin/echo</filename> を用いているためです。
        </para>
@z

@x /bin/grep
        <para>This to avoid a hard-coded
        <filename class="directory">/tools</filename> reference in Libtool.</para>
@y
        <para>
        Libtool においてハードコーディングされた <filename class="directory">/tools</filename> を無効にするためです。
        </para>
@z

@x /bin/login
        <para>The <command>agetty</command> program expects to find
        <command>login</command> in <filename class="directory">/bin</filename>.</para>
@y
        <para>
        <command>agetty</command> プログラムが <command>login</command> を <filename class="directory">/bin</filename> ディレクトリ内にあるものとしているからです。
        </para>
@z

@x /bin/pwd
        <para>Some <command>configure</command> scripts, particularly Glibc's,
        have this pathname hard-coded.</para>
@y
        <para>
        <command>configure</command> スクリプト、特に Glibc におけるものがこのパス名をハードコーディングしているためです。
        </para>
@z

@x /bin/stty
        <para>This pathname is hard-coded into Expect, therefore it is needed
        for Binutils and GCC test suites to pass.</para>
@y
        <para>
        Expect においてこのパス名がハードコーディングされています。
        したがって Binutils や GCC のテストスィートを成功させるために必要となります。
        </para>
@z

@x /usr/bin/file
        <para>Binutils' <command>configure</command> scripts specify this
        command location.</para>
@y
        <para>
        Binutils の <command>configure</command> スクリプトがこのコマンドパスを用いています。
        </para>
@z

@x /usr/lib/libgcc_s.so{,.1}
        <para>Glibc needs this for the pthreads library to work.</para>
@y
        <para>
        Glibc では pthreads ライブラリを動作させるためにこれが必要となります。
        </para>
@z

@x /usr/lib/libstdc++{,.6}
        <para>This is needed by several tests in Glibc's test suite, as well as
        for C++ support in GMP.</para>
@y
        <para>
        Glibc のテストスイート内のテストにてこれを必要とするものがあります。
        また GMP の C++ サポートにおいても必要とするものがあります。
        </para>
@z

@x /usr/lib/libstdc++.la
        <para>This prevents a <filename class="directory">/tools</filename>
        reference that would otherwise be in
        <filename>/usr/lib/libstdc++.la</filename> after GCC is installed.</para>
@y
        <para>
        GCC をインストールした後は <filename
        class="directory">/tools</filename> への参照は無くして <filename>/usr/lib/libstdc++.la</filename> とする必要があります。
        </para>
@z

@x /bin/sh
        <para>Many shell scripts hard-code <filename>/bin/sh</filename>.</para>
@y
        <para>
        シェルスクリプトは多くが <filename>/bin/sh</filename> を指定しています。
        </para>
@z

@x /sbin/init
        <para>This is where the kernel expects to find <command>init</command>.</para>
@y
        <para>
        カーネルは <command>init</command> がこのパス名であることを前提としています。
        </para>
@z

@x /etc/{login.{access,defs},limits}
        <para>These are configuration files used by Shadow and are expected to
        be found in <filename class="directory">/etc</filename>, for programs
        such as <command>login</command> and <command>su</command> to work.</para>
@y
        <para>
        このファイルは Shadow が利用する設定ファイルであり <filename
        class="directory">/etc</filename> ディレクトリにある必要があります。
        例えば <command>login</command> や <command>su</command> といったプログラムがこのことを必要としています。
        </para>
@z

@x
  <para os="d">Historically, Linux maintains a list of the mounted file systems
  in the file <filename>/etc/mtab</filename>. Modern kernels maintain this list
  internally and expose it to the user via the
  <filename class="directory">/proc</filename> filesystem. To satisfy utilities
  that expect the presence of <filename>/etc/mtab</filename>, create the
  following symbolic link:</para>
@y
  <para os="d">
  Linux のこれまでの経緯として、マウントされているファイルシステムの情報は <filename>/etc/mtab</filename> ファイルに保持されています。
  最新の Linux であれば、内部的にこのファイルを管理し、ユーザーに対しては <filename
  class="directory">/proc</filename> ファイルシステムを通じて情報提示しています。
  <filename>/etc/mtab</filename> ファイルの存在を前提としているプログラムが正常動作するように、以下のシンボリックリンクを作成します。
  </para>
@z