%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Creating a New Partition</title>
@y
  <title>新しいパーティションの生成</title>
@z

@x
  <para os="a">Like most other operating systems, CLFS is usually installed
  on a dedicated partition. The recommended approach to building a CLFS
  system is to use an available empty partition or, if you have enough
  unpartitioned space, to create one. However, if you're building for a
  different architecture you can simply build everything in
  <quote>/mnt/clfs</quote> (or whatever directory you want to use) and
  transfer it to your target machine. If you do not plan to use a separate
  partition for building CLFS, you can skip the rest of this chapter and
  continue on to <xref linkend="chapter-getting-materials"/>.</para>
@y
  <para os="a">
  どのようなオペレーティングシステムでも同じことが言えますが、本システムでもインストール先は専用のパーティションを用いることにします。
  CLFS システムを構築していくには、利用可能な空のパーティションか、あるいはパーティション化していないものをパーティションとして生成して利用することにします。
  ただし異なるアーキテクチャーのシステムをビルドする場合は、単純に "/mnt/clfs" (あるいはあなたが定める別のディレクトリ) にてビルドすればよく、ターゲットマシンに向けてすべてを転送するだけ済みます。
  CLFS のビルドにあたってパーティションを分けるつもりがない場合は、本章の残りの記述は読み飛ばして<xref
  linkend="chapter-getting-materials"/>に進んでいただいて構いません。
  </para>
@z

@x
  <para os="b">A minimal system requires around 6 gigabytes (GB).
  This is enough to store all the source tarballs and compile the packages. The CLFS
  system itself will not take up this  much room. A large portion of this requirement
  is to provide sufficient free temporary storage. Compiling packages can require a
  lot of disk space which will be reclaimed after the package is installed. If the
  CLFS system is intended to be the primary Linux system,  additional software will
  probably be installed which will require additional space (2-10 GB). </para>
@y
  <para os="b">
  最小限のシステムであれば 6 GB 程度のディスク容量があれば十分です。
  これだけあればパッケージやソースの収容に十分で、そこでコンパイル作業を行っていくことができます。
  CLFS システムそのものがそれだけの容量を要するわけではありません。
  これだけの容量は十分なテンポラリ領域のために必要となるものです。
  パッケージをインストールした後はテンポラリ領域は開放されますが、コンパイルの間は多くの領域を利用します。
  主要なシステムとして CLFS を構築するなら、さらにソフトウェアをインストールすることになるはずなので、さらなる容量 (2～10GB) が必要となります。
  </para>
@z

@x
  <para os="c">Because there is not always enough Random Access Memory (RAM)
  available for compilation processes, it is a good idea to use a small disk
  partition as swap space. This is used by the kernel to store seldom-used
  data and leave more memory available for active processes. The swap
  partition for a CLFS system can be the same as the one used by the host
  system, in which case it is not necessary to create another one.</para>
@y
  <para os="c">
  コンパイル処理において十分なランダムアクセスメモリ (Random Access Memory;
  RAM) を確保できるとは限りませんので、スワップ (<systemitem
  class="filesystem">swap</systemitem>) 領域をパーティションとして設けるのが普通です。
  この領域へは利用頻度が低いデータを移すことで、アクティブな処理プロセスがより多くのメモリを確保できるようにカーネルが制御します。
  <systemitem class="filesystem">swap</systemitem> パーティションは CLFS システムのものとホストシステムのものを共有することもできます。
  その場合は新しいパーティションを作る必要はありません。
  </para>
@z

@x
  <para os="d">As the <systemitem class="username">root</systemitem> user,
  start a disk partitioning program such as <command>cfdisk</command>
  or <command>fdisk</command> with a command line option naming the hard
  disk on which the new partition will be created&mdash;for example
  <filename class="devicefile">/dev/sda</filename> for the primary
  Integrated Drive Electronics (IDE) or Serial ATA (SATA) disk. Create a Linux
  native partition and a swap partition, if needed. Please refer to
  <filename>cfdisk(8)</filename> or <filename>fdisk(8)</filename> if you
  do not yet know how to use the programs.</para>
@y
  <para os="d">
  ディスクのパーティション生成は <systemitem
  class="username">root</systemitem> ユーザーになって <command>cfdisk</command> コマンドや <command>fdisk</command> コマンドを使って行います。
  コマンドラインオプションにはパーティションを生成するハードディスク名を指定します。
  例えば IDE (Integrated Drive Electronics) ディスクや Serial ATA (SATA) ディスクであれば <filename
  class="devicefile">/dev/sda</filename> といったものになります。
  そして Linux ネイティブパーティションと、必要なら <systemitem
  class="filesystem">swap</systemitem> パーティションを生成します。
  プログラムの利用方法について不明であれば <filename>cfdisk(8)</filename> や <filename>fdisk(8)</filename> を参照してください。
  </para>
@z

@x
  <para os="e">Remember the designation of the new partition (e.g.,
  <filename class="devicefile">sda5</filename>). This book will refer to
  this as the CLFS partition. Also, remember the designation of the swap
  partition. These names will be needed later for the
  <filename>/etc/fstab</filename> file.</para>
@y
  <para os="e">
  新しく生成したパーティションの名前を覚えておいてください。
  (例えば <filename class="devicefile">sda5</filename> など。) 本書ではこのパーティションを CLFS パーティションとして説明していきます。
  また <systemitem class="filesystem">swap</systemitem> パーティションの名前も忘れないでください。
  これらの名前は、後に生成する <filename>/etc/fstab</filename> ファイルに記述するために必要となります。
  </para>
@z