%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Setting Up the Environment</title>
@y
  <title>環境設定</title>
@z

@x
  <para os="a">Set up a good working environment by creating two new startup
  files for the <command>bash</command> shell. While logged in as user
  <systemitem class="username">clfs</systemitem>, issue the following
  command to create a new <filename>.bash_profile</filename>:</para>
@y
  <para>
  作業しやすい動作環境とするために <command>bash</command> シェルに対するスタートアップファイルを二つ作成します。
  <systemitem class="username">clfs</systemitem> ユーザーでログインして、以下のコマンドによって <filename>.bash_profile</filename> ファイルを生成します。
  </para>
@z

@x
  <para os="c">When logged on as user <systemitem class="username">clfs</systemitem>,
  the initial shell is usually a <emphasis>login</emphasis> shell which
  reads the <filename>/etc/profile</filename> of the host (probably
  containing some settings and environment variables) and then
  <filename>.bash_profile</filename>. The
  <command>exec env -i.../bin/bash</command> command in the
  <filename>.bash_profile</filename> file replaces the running shell with
  a new one with a completely empty environment, except for the
  <envar>HOME</envar>, <envar>TERM</envar>, and <envar>PS1</envar> variables.
  This ensures that no unwanted and potentially hazardous environment
  variables from the host system leak into the build environment. The
  technique used here achieves the goal of ensuring a clean environment.</para>
@y
  <para os="c">
  <systemitem class="username">clfs</systemitem> ユーザーとしてログインした時、起動されるシェルは普通は<emphasis>ログイン</emphasis> シェルとなります。
  この時、ホストシステムの <filename>/etc/profile</filename> ファイル (おそらく環境変数がいくつか定義されている) と <filename>.bash_profile</filename> が読み込まれます。
  <filename>.bash_profile</filename> ファイル内の <command>exec env -i.../bin/bash</command> というコマンドが、起動しているシェルを全くの空の環境として起動し直し <envar>HOME</envar>、<envar>TERM</envar>、<envar>PS1</envar> という環境変数だけを設定します。
  これはホストシステム内の不要な設定や危険をはらんだ設定を、ビルド環境に持ち込まないようにするためです。
  このようにすることできれいな環境作りを実現できます。
  </para>
@z

@x
  <para os="d">The new instance of the shell is a <emphasis>non-login</emphasis>
  shell, which does not read the <filename>/etc/profile</filename> or
  <filename>.bash_profile</filename> files, but rather reads the
  <filename>.bashrc</filename> file instead. Create the
  <filename>.bashrc</filename> file now:</para>
@y
  <para os="d">
  新しく起動するシェルはログインシェルではなくなります。
  したがってこのシェルは <filename>/etc/profile</filename> ファイルや <filename>.bash_profile</filename> ファイルは読み込まず、代わりに <filename>.bashrc</filename> ファイルを読み込みます。
  そこで以下のようにして <filename>.bashrc</filename> ファイルを生成します。
  </para>
@z

@x
  <para os="f">The <command>set +h</command> command turns off
  <command>bash</command>'s hash function. Hashing is ordinarily a useful
  feature&mdash;<command>bash</command> uses a hash table to remember the
  full path of executable files to avoid searching the <envar>PATH</envar>
  time and again to find the same executable. However, the new tools should
  be used as soon as they are installed. By switching off the hash function,
  the shell will always search the <envar>PATH</envar> when a program is to
  be run. As such, the shell will find the newly compiled tools in
  <filename class="directory">/cross-tools</filename> as soon as they are
  available without remembering a previous version of the same program in a
  different location.</para>
@y
  <para os="f">
  <command>set +h</command> コマンドは <command>bash</command> のハッシュ機能を無効にします。
  通常このハッシュ機能は有用なものです。
  実行ファイルのフルパスをハッシュテーブルに記憶しておき、再度そのパスを探し出す際に <envar>PATH</envar> 変数の探査を省略します。
  しかしこれより作り出すツール類はインストール直後にすぐ利用していきます。
  ハッシュ機能を無効にすることで、プログラム実行が行われる際に、シェルは必ず <envar>PATH</envar> を探しにいきます。
  つまり <filename class="directory">/cross-tools</filename> ディレクトリ以下に新たに構築したツール類は必ず実行されるようになるわけです。
  そのツールの古いバージョンがどこか別のディレクトリにあったとしても、その場所を覚えていて実行されるということがなくなります。
  </para>
@z

@x
  <para os="g">Setting the user file-creation mask (umask) to 022 ensures that
  newly created files and directories are only writable by their owner,
  but are readable and executable by anyone (assuming default modes are
  used by the open(2) system call, new files will end up with permission
  mode 644 and directories with mode 755).</para>
@y
  <para os="g">
  ユーザーのファイル生成マスク (file-creation mask; umask) を 022 にセットするのは、新たなファイルやディレクトリの生成はその所有者にのみ許可し、他者は読み取りと実行を可能とするためです。
  (システムコール <function>open(2)</function> にてデフォルトモードが適用される場合、新規生成ファイルのパーミッションモードは 644、同じくディレクトリは 755 となります。)
  </para>
@z

@x
  <para os="h">The <envar>CLFS</envar> variable should be set to the
  chosen mount point.</para>
@y
  <para os="h">
  環境変数 <envar>CLFS</envar> は常に指定したマウントポイントを指し示すように設定します。
  </para>
@z

@x
  <para os="i">The <envar>LC_ALL</envar> variable controls the localization
  of certain programs, making their messages follow the conventions of a
  specified country. Setting <envar>LC_ALL</envar> to <quote>POSIX</quote>
  or <quote>C</quote> (the two are equivalent) ensures that everything will
  work as expected in the temporary build environment.</para>
@y
  <para os="i">
  <envar>LC_ALL</envar> 変数は特定のプログラムが扱う国情報を制御します。
  そのプログラムが出力するメッセージを、指定された国情報に基づいて構成します。
  <envar>LC_ALL</envar> 変数は<quote>POSIX</quote>か<quote>C</quote>にセットしてください。(両者は同じです。)
  そのようにセットしておけば一時ビルド環境下での作業が問題なく進められます。
  </para>
@z

@x
  <para os="j">By putting <filename class="directory">/cross-tools/bin</filename>
  at the beginning of the <envar>PATH</envar>, the cross-compiler
  built in <xref linkend="chapter-cross-tools"/> will be picked up by
  the build process for the temp-system packages before anything that
  may be installed on the host. This, combined with turning off
  hashing, helps to ensure that you will be using the cross-compile
  tools to build the temp-system in /tools.</para>
@y
  <para os="j">
  <filename class="directory">/cross-tools/bin</filename> ディレクトリを <envar>PATH</envar> 変数の先頭に設定します。
  こうすることで一時システムにおける各パッケージのビルド時には <xref linkend="chapter-cross-tools"/> において構築するクロスコンパイラーが利用されることになります。
  つまりホストシステム内にあるコンパイラーが用いられないようにします。
  この設定は、ハッシュ機能をオフとしたことと連携し、クロスコンパイルツールを用いて /tools ディレクトリ内に一時システムを構築していくものとなります。
  </para>
@z

@x
  <para os="k">The <envar>CFLAGS</envar>, <envar>CXXFLAGS</envar> and
  <envar>PKG_CONFIG_PATH</envar> variables should not be set while building the
  temporary system, so we unset them.</para>
@y
  <para os="k">
  <envar>CFLAGS</envar>、<envar>CXXFLAGS</envar>、<envar>PKG_CONFIG_PATH</envar> の各変数は、一時システムの構築時には設定すべきではありません。
  そこでそれらは非設定とします。
  </para>
@z

@x
  <para os="l">Finally, to have the environment fully prepared for building the
  temporary tools, source the just-created user profile:</para>
@y
  <para os="l">
  一時的なツールを構築する準備の最後として、今作り出したユーザープロファイルを source によって取り込みます。
  </para>
@z