%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <secondary>cross tools</secondary>
@y
    <secondary>&CrossTools;</secondary>
@z

@x
    <title>Installation of Glibc</title>
@y
    <title>&InstallationOf1;Glibc &InstallationOf2;</title>
@z

@x
    <para os="da">It should be noted that compiling Glibc in any way other than
    the method suggested in this book puts the stability of the system at
    risk.</para>
@y
    <para os="da">
    Glibc のビルドを本書とは異なる方法で行った場合には、システムの安定性を損なう可能性がありますから注意してください。
    </para>
@z

@x
      <title>The meaning of the new configure options:</title>
@y
      <title>&MeaningOfOption1;configure &MeaningOfOption2;</title>
@z

@x BUILD_CC="gcc"
          <para>This sets Glibc to use the current compiler on our system. This is
          used to create the tools Glibc uses during its build.</para>
@y
          <para>
          Glibc に対して現時点でのコンパイラーを用いることを指示します。
          Glibc 構築においてそのコンパイラーを使ったツールビルドを行います。
          </para>
@z

@x CC="${CLFS_TARGET}-gcc"
          <para>This forces Glibc to use the GCC compiler that we made for our target
          architecture.</para>
@y
          <para>
          Glibc が利用する GCC コンパイラーは、ターゲットアーキテクチャー用に生成してきたものとすることを指示します。
          </para>
@z

@x AR="${CLFS_TARGET}-ar"
          <para>This forces Glibc to use the <command>ar</command> utility
          we made for our target architecture.</para>
@y
          <para>
          Glibc が利用する <command>ar</command> ユーティリティーは、ターゲットアーキテクチャー用に生成してきたものとすることを指示します。
          </para>
@z

@x RANLIB="${CLFS_TARGET}-ranlib"
          <para>This forces Glibc to use the <command>ranlib</command> utility
          we made for our target architecture.</para>
@y
          <para>
          Glibc が利用する <command>ranlib</command> ユーティリティーは、ターゲットアーキテクチャー用に生成してきたものとすることを指示します。
          </para>
@z

@x --enable-kernel=&glibc-kernel-version;
          <para>This tells Glibc to compile the library with support
          for &glibc-kernel-version; and later Linux kernels.</para>
@y
          <para>
          Linux カーネル &glibc-kernel-version; 以上のサポートを行うよう指示します。
          </para>
@z

@x --with-binutils=/cross-tools/bin
          <para>This tells Glibc to use the Binutils that are specific to
          our target architecture.</para>
@y
          <para>
          目的のアーキテクチャー用に作り出した Binutils を Glibc において利用することを指示します。
          </para>
@z

@x --with-headers=/tools/include
          <para>This tells Glibc to compile itself against the headers
          recently installed to the <filename class="directory">/tools</filename>
          directory, so that it knows exactly what features the kernel has
          and can optimize itself accordingly.</para>
@y
          <para>
          これまでに <filename class="directory">/tools</filename> にインストールしたヘッダーファイルを用いて Glibc をビルドすることを指示します。
          こうすればカーネルにどのような機能があるか、どのようにして処理効率化を図れるかなどの情報を Glibc が得られることになります。
          </para>
@z

@x --enable-obsolete-rpc
          <para>This tells Glibc to install rpc headers that are not installed
          by default but may be needed by other packages.</para>
@y
          <para>
          rpc ヘッダーファイルをインストールすることを指示します。
          これはデフォルトではインストールされませんが、一部のパッケージがこれを必要としています。
          </para>
@z

@x
    <para os="dh">During this stage the following warning might appear:</para>
@y
    <para os="dh">
    ビルド中には以下のようなメッセージが出力されるかもしれません。
    </para>
@z

@x
    <para os="dj">The missing or incompatible <command>msgfmt</command> program is
    generally harmless. This <command>msgfmt</command> program is part of the
    Gettext package which the host distribution should provide. You might also
    see a similar (also harmless) message about missing
    <command>autoconf</command>.</para>
@y
    <para os="dj">
    <command>msgfmt</command> プログラムがない場合 (missing) や互換性がない場合 (incompatible) でも特に問題はありません。
    <command>msgfmt</command> プログラムは Gettext パッケージが提供するもので、ホストシステムに含まれているかもしれません。
    同様の (問題がない) メッセージは <command>autoconf</command> がインストールされていない場合も発生します。
    </para>
@z

@x
    <para os="dk">Compile the package:</para>
@y
    <para os="dk">&CompileThePackage;</para>
@z

@x
    <para os="dm">Install the package:</para>
@y
    <para os="dm">&InstallThePackage;</para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-glibc" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-glibc" role=""/>&Details2;
    </para>
@z