﻿(function() {

function escapeID(str) {
	return str.replace('customfield', '___ckeditorfield___');
}

CKEDITOR.plugins.add('movabletype', {

lang : [ 'en', 'ja' ],

init : function(editor) {
	var blog_id = (function() {
		var input = document.getElementById('blog-id');
		if (input) {
			return input.value;
		}
		else {
			return 0;
		}
	})();

	function myOpenDialog(mode, param) {
		if ('jQuery' in window && 'mtAddEdgeClass' in jQuery) {
			jQuery.fn.mtDialog.open(
				ScriptURI + '?' + '__mode=' + mode + '&amp;' + param
			);
		}
		else {
			openDialog(false, mode, param);
		}
	}

	var mode_dislog_list_asset = 'dialog_list_asset';
	if (CKEditorMTVersion < 5.1) {
		mode_dislog_list_asset = 'list_assets';
	}
	editor.addCommand('mt_insert_image', {
		exec: function() {
			var id = escapeID(editor.element['$'].id);

			myOpenDialog(
				mode_dislog_list_asset,
				'_type=asset&amp;edit_field=' + id + '&amp;blog_id=' + blog_id +
				'&amp;dialog_view=1&amp;filter=class&amp;filter_val=image'
			);
		}
	});

	editor.addCommand('mt_insert_file', {
		exec: function() {
			var id = escapeID(editor.element['$'].id);

			myOpenDialog(
				mode_dislog_list_asset,
				'_type=asset&amp;edit_field=' + id + '&amp;blog_id=' + blog_id +
				'&amp;dialog_view=1'
			);
		}
	});

	editor.ui.addButton('mt_insert_image', {
		label : editor.lang.movabletype.insert_image,
		command : 'mt_insert_image',
		icon: this.path + 'img/insert_image.gif'
	});
	editor.ui.addButton('mt_insert_file', {
		label : editor.lang.movabletype.insert_file,
		command : 'mt_insert_file',
		icon: this.path + 'img/insert_file.gif'
	});
}

});

})();
