use strict;
use warnings;
use Module::Build;

our $VERSION = '0.1.2';
our $MODULE = 'ckeditor_plugins_mobilepictogram';

my $class = Module::Build->subclass(
	code => q{
		# Don't make blib
		# sub ACTION_code {};
		# Don't make blib
		sub ACTION_docs {};
		# Don't make META.yml
		sub ACTION_distmeta {
			# no warning on ACTION_distdir
			$_[0]->{metafile} = 'MANIFEST';
		};
		# Don't add MEATA.yml to MANIFEST
		sub ACTION_manifest {
			$_[0]->{metafile} = 'MANIFEST',
			$_[0]->SUPER::ACTION_manifest(@_);
		};
		sub dist_dir {
			'ckeditor';
		}
		sub ACTION_dist {
			my ($self) = @_;

			$_[0]->SUPER::ACTION_dist(@_);

			my $dist_dir = $self->dist_dir;
			rename(
				$dist_dir . '.tar.gz',
				$self->{properties}{dist_name} . '-' . $self->{properties}{dist_version} . '.src.tar.gz'
			);
			system('tar zxf ' . $self->{properties}{dist_name} . '-' . $self->{properties}{dist_version} . '.src.tar.gz');
			system(
				'zip -r ' . $self->{properties}{dist_name} . '-' . $self->{properties}{dist_version} . '.src.zip ' . $dist_dir
			);
		}

		sub ACTION_distdir {
			my ($self) = @_;

			$_[0]->SUPER::ACTION_distdir(@_);

			my $dist_dir = $self->dist_dir;

			use File::Path;
			mkpath('ckeditor_build/_source/plugins');

			rename(
				$dist_dir,
				'ckeditor_build/_source/plugins/mobilepictogram'
			);
			rename('ckeditor_build', $dist_dir);
		}

		sub ACTION_package {
			my ($self) = @_;

			$self->ACTION_dist(@_);
			system('tar zxf ' . $self->{properties}{dist_name} . '-' . $self->{properties}{dist_version} . '.src.tar.gz');
			system('ckreleaser plugin.release ckeditor/ ckeditor/release 1 package');
			rename('ckeditor/release/release', 'ckeditor/release/ckeditor');
			system('rm -fr ckeditor/release/ckeditor/_source');
			system('tar zcvf ' . $self->{properties}{dist_name} . '-' . $self->{properties}{dist_version} . '.tar.gz -C ckeditor/release ckeditor');
			system(
				'chdir ckeditor/release; zip -r ../../' .
				$self->{properties}{dist_name} . '-' . $self->{properties}{dist_version} . '.zip ' .
				' ckeditor'
			);
			system('rm -fr ckeditor');
		}
	}
);

my $builder = $class->new(
	dist_name           => $MODULE,
    dist_author         => 'Taku Amano <taku@toi-planning.net>',
    dist_version        => $VERSION,
    module_name         => $MODULE,
    license             => 'mit',
    add_to_cleanup      => [ "$MODULE-*" ],
);

$builder->create_build_script();
