//
//  main.c
//  libtest
//
//  Created by 西田　耀 on 13/02/25.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include <stdio.h>
#include "chnlib.h"
#include <time.h>

int main(int argc, const char * argv[])
{
    int i;
    CHNLIB_RandomGeneratorMT *mt;
    CHNLIB_UUID *uuid, *uuid2;
    
    mt = CHNLIB_RandomGeneratorMT_Initialise();
    CHNLIB_RandomGeneratorMT_SetSeed(mt, (int)&mt ^ time(NULL));
    
    for(i = 0; i < 1024; i++){
        uuid = CHNLIB_GenerateUUIDVersion4WithRandomGeneratorMT(mt);
        CHNLIB_UUID_Print(uuid);
        printf(":0x%08X\n", CHNLIB_StructureHeader_GetHash(uuid));
        release(uuid);
    }
    
    uuid = CHNLIB_GenerateUUIDVersion4WithRandomGeneratorMT(mt);
    putc('\n', stdout);
    CHNLIB_UUID_Print(uuid);
    
    uuid2 = CHNLIB_UUID_Copy(uuid);
    putc('\n', stdout);
    CHNLIB_UUID_Print(uuid2);
    
    if(CHNLIB_UUID_IsEqualToUUID(uuid, uuid2)){
        printf("\neq\n");
    } else{
        printf("\nNOTeq\n");
    }
    release(uuid2);
    
    uuid2 = CHNLIB_GenerateUUIDVersion4WithRandomGeneratorMT(mt);
    putc('\n', stdout);
    CHNLIB_UUID_Print(uuid2);
    
    if(CHNLIB_UUID_IsEqualToUUID(uuid, uuid2)){
        printf("\neq\n");
    } else{
        printf("\nNOTeq\n");
    }
    release(uuid2);
    
    return 0;
}

