//
//  chnlib03.c
//  AI003
//
//  Created by 西田　耀 on 13/02/09.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

//動作環境に応じて変更が必要な関数群
//Unix(Mac OSX), Windowsでの動作が想定されている

//
//Include headers
//

#include <stdio.h>
#include "chnlib.h"

#ifdef CHNLIB_MAKE_GCC_MAC
#include <unistd.h>
//+---int chdir(const char *path);  カレントディレクトリの変更
//+---char *getcwd(char *buf, size_t size); 現在のカレントディレクトリを取得
#define CHNLIB_PATH_SEPARATOR   '/'
#endif


#ifdef CHNLIB_MAKE_BCC_WIN
#include <direct.h>
#define getcwd(a,b)	_getcwd(a,b)
//+---int _chdir(const char *dirname);
//+---char *_getcwd(char *buffer, int maxlen);
#define CHNLIB_PATH_SEPARATOR   '\'
#endif


//
//Functions
//

void CHNLIB_Environment_SetCurrentWorkingDirectory(const char apppath[])
{
    //カレントディレクトリを実行ファイルのディレクトリに変更
    char path[FILENAME_MAX];
    int i, last;

    snprintf(path, sizeof(path), "%s", apppath);
    last = 0;
    for(i = 0; i < FILENAME_MAX; i++){
        if(path[i] == '\0'){
            break;
        }
        if(path[i] == '/'){
            last = i;
        }
    }
    path[last + 1] = '\0';
    //printf("%s\n", path);
    chdir(path);
    getcwd(path, sizeof(path));
    //printf("%s\n", path);
    
    return;
}

const char *CHNLIB_Environment_GetFilenameFromPath(const char path[])
{
    //path文字列から、ファイル名を指し示す文字列の先頭部分のポインタを返す。
    int i, p;
    
    if(path == NULL){
        return NULL;
    }
    
    p = 0;
    for(i = 0; path[i] != '\0'; i++){
        if(path[i] == CHNLIB_PATH_SEPARATOR){
            p = i + 1;
        }
    }
    
    return &path[p];
}
