//
//  AppDelegate.h
//  SimpleHTMLEditor
//
//  Created by 西田　耀 on 13/04/13.
//  Copyright (c) 2013年 CHNOSProject. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

@interface AppDelegate : NSObject <NSApplicationDelegate, NSWindowDelegate>
{
    IBOutlet NSWindow *mainWindow;
    IBOutlet NSTextField *addressBar;
    IBOutlet WebView *mainWebView;
    IBOutlet NSTextView *sourceEditor;
    IBOutlet NSTextField *editingFileURILabel;
    IBOutlet NSMenuItem *MenuItem_SaveAs;
    IBOutlet NSTextView *logViewer;
}
- (IBAction)addressBarURIChanged:(id)sender;
- (IBAction)openCurrentURIForEdit:(id)sender;
- (void)openCurrentURIForEdit_sheetClosed:(id)sheet returnCode:(int)returnCode contextInfo:(id)contextInfo;
- (void)openCurrentURIForEdit_ReadURI;
- (void)webView:(WebView *)sender didStartProvisionalLoadForFrame:(WebFrame *)frame;
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)sender;
- (IBAction)saveEditingDocumentForFile:(id)sender;
- (IBAction)revertToSaved:(id)sender;
- (void)revertToSaved_sheetClosed:(id)sheet returnCode:(int)returnCode contextInfo:(id)contextInfo;
- (IBAction)clearLogView:(id)sender;
@end
