//
//  wlfilter.c
//  AI003
//
//  Created by 西田　耀 on 13/05/20.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include <stdio.h>
#include "core.h"

int AI_Think_CandidateWordList_Filter00(CHNLIB_UIPArray **candidatewordlist)
{
    //[UTF-8]
    //AI_Think_SlideLookUpWordByHistoryで返されたArray内の候補単語に対して、フィルターをかける。
    //00:長い単語に含まれており、かつ出現頻度が長い単語と等しい単語を削除
    int i, i_max;
    CHNLIB_String *nowstr, *basestr;
    int basestrCoC;     //CountOfContainInHistoryStrings
    
    i_max = CHNLIB_UIPArray_GetNumberOfDatas(*candidatewordlist);
    basestr = CHNLIB_UIPArray_GetPointerByIndex(*candidatewordlist, 0);
    basestrCoC = CHNLIB_UIPArray_GetData32ByIndex(*candidatewordlist, 0);
    for(i = 1; i < i_max; i++){
        nowstr = CHNLIB_UIPArray_GetPointerByIndex(*candidatewordlist, i);
        if(CHNLIB_UTF8_GetCountOfContain(CHNLIB_String_GetReferencePointerOfCString(basestr), CHNLIB_String_GetReferencePointerOfCString(nowstr)) > 0){
            //nowstrはbasestrに含まれている
            if(basestrCoC == CHNLIB_UIPArray_GetData32ByIndex(*candidatewordlist, i)){
                //かつ出現頻度が等しいので不要な単語
                //出現頻度を0にして、後で削除する。
                CHNLIB_UIPArray_SetData32ByIndex(*candidatewordlist, i, 0);
            }
        }
        
        if(CHNLIB_UIPArray_GetData32ByIndex(*candidatewordlist, i) != 0){
            //単語は削除されなかった、つまり異なる単語なので、basestrを更新
            basestr = nowstr;
            basestrCoC = CHNLIB_UIPArray_GetData32ByIndex(*candidatewordlist, i);
        }
    }
    
    for(i = 1; i < i_max; i++){
        if(CHNLIB_UIPArray_GetData32ByIndex(*candidatewordlist, i) == 0){
            //削除対象
            CHNLIB_UIPArray_RemoveByIndex(candidatewordlist, i);
            i--;
            i_max--;
        }
    }
    
    return 0;
}

int AI_Think_CandidateWordList_Filter01(CHNLIB_UIPArray **candidatewordlist, int length)
{
    //[UTF-8]
    //AI_Think_SlideLookUpWordByHistoryで返されたArray内の候補単語に対して、フィルターをかける。
    //01:length以下の文字数の単語を削除
    
    int i, i_max;
    
    i_max = CHNLIB_UIPArray_GetNumberOfDatas(*candidatewordlist);
    for(i = 0; i < i_max; i++){
        if(CHNLIB_UTF8_GetStringLengthByCharacter(CHNLIB_String_GetReferencePointerOfCString(CHNLIB_UIPArray_GetPointerByIndex(*candidatewordlist, i))) <= length){
            CHNLIB_UIPArray_RemoveByIndex(candidatewordlist, i);
            i--;
            i_max--;
        }
    }
    
    return 0;
}

int AI_Think_CandidateWordList_Filter02(CHNLIB_UIPArray **candidatewordlist, uint count)
{
    //[UTF-8]
    //AI_Think_SlideLookUpWordByHistoryで返されたArray内の候補単語に対して、フィルターをかける。
    //02:count以下の出現回数の単語を削除
    
    int i, i_max;
    
    i_max = CHNLIB_UIPArray_GetNumberOfDatas(*candidatewordlist);
    for(i = 0; i < i_max; i++){
        if(CHNLIB_UIPArray_GetData32ByIndex(*candidatewordlist, i) <= count){
            CHNLIB_UIPArray_RemoveByIndex(candidatewordlist, i);
            i--;
            i_max--;
        }
    }
    
    return 0;
}
