//
//  think.c
//  AI002
//
//  Created by 西田　耀 on 13/01/01.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include "core.h"

void AI_ThinkMain(void)
{
    char line[AI_MAX_STRINGLENGTH];
    int i, j, k;
    AI_Array *separated, *meanlist;
    int passthink;
    
    line[0] = '\0';
    separated = AI_Array_Initialize();

    
    for(;;){
        passthink = False;
        AI_ReadInput(line, sizeof(line), stdin);
        
        if(line[0] == ':' && line[1] == ':'){
            //システムコマンド解釈
            passthink = True;
            AI_Array_GetSeparatedStringByArray(&separated, &AI_SystemStringList, &line[2]);
            if(AI_String_CompareString_Strict((const char *)AI_Array_GetPointerByIndex(separated, 0), "info")){
                AI_Command_System_info(separated);
            } else if(AI_String_CompareString_Strict((const char *)AI_Array_GetPointerByIndex(separated, 0), "setmode")){
                AI_Command_System_setmode(separated);
            } else if(AI_String_CompareString_Strict((const char *)AI_Array_GetPointerByIndex(separated, 0), "exit")){
                return;
            } else if(AI_String_CompareString_Strict((const char *)AI_Array_GetPointerByIndex(separated, 0), "save")){
                AI_Memory_SaveMemory((const char *)AI_Array_GetPointerByIndex(separated, 2));
            } else{
                passthink = False;
            }
            AI_Array_FreePointer(separated);
            AI_Array_Free(&separated);
        }
        if(!passthink){
            AI_Think_GetSeparatedStringByMemory(&separated, line);
            switch(AI_MainMemory.mode){
                case 0:
                    AI_Speak("mode 0\nInput:");
                    j = AI_Array_GetNumberOfTags(separated);
                    for(i = 0; i < j; i++){
                        printf("%s(0x%08X) ", AI_Array_GetPointerByIndex(separated, i), AI_Array_GetDataIDByIndex(separated, i));
                    }
                    printf("\n");
                    meanlist = AI_Memory_Expression_GetMeanFromSeparatedString(separated);
                    if(AI_Array_GetIndexByDataID(meanlist, AI_SYSDATAID_M_DEFINE) != AI_ARRAY_INDEX_NOTFOUND){
                        AI_Speak("OK.\n");
                    } else{
                        AI_Speak("BAD.\n");
                    }
                    AI_Array_Free(&meanlist);
                    break;
                case 1:
                    k = (AI_String_GetLength(line) % 10) + 1;
                    AI_Speak("");
                    for(j = 0; j < k; j++){
                        i = rand() % AI_Array_GetNumberOfTags(AI_MainMemory.list_word);
                        printf("%s ", AI_Array_GetPointerByIndex(AI_MainMemory.list_word, i));
                    }
                    printf("\n");
                    break;
                default:
                    AI_Speak("default\n");
                    break;
            }
            AI_Array_FreePointer(separated);
            AI_Array_Free(&separated);
        }
    }
    
    return;
}

int AI_Think_GetSeparatedStringByMemory(AI_Array **separated, const char s[])
{
    return AI_Array_GetSeparatedStringByArray(separated, AI_MainMemory.list_word, s);
}


