//
//  string.c
//  AI002
//
//  Created by 西田　耀 on 13/01/01.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include "core.h"

void AI_String_DeleteCRLF(char s[])
{
    //末尾のLF, CR/LFを\0に置換する
    int i, crlf;
    
    crlf = -1;
    for(i = 0; s[i] != '\0'; i++){
        if(s[i] == '\n'){
            if(crlf == -1 || crlf + 1 != i){
                crlf = i;
            }
        }
        if(s[i] == '\r'){
            if(crlf == -1 || crlf + 1 != i){
                crlf = i;
            }
        }
    }
    if(crlf != -1){
        for(i = crlf; s[i] != '\0'; i++){
            s[i] = '\0';
        }
    }
    return;
}

char *AI_String_ExtractByLength(const char s[], int start, int len)
{
    //s[start]からs[start + len - 1]の文字を含む文字列を、新たにメモリを確保して書き込み、その先頭アドレスを返す。
    //lenに満たずにsが終端文字を迎えた場合は、sの終端文字直前までの文字列がコピーされる。
    char *str;
    int i;
    
    if(s == NULL){
        AI_SpeakError("Null s[]\n", NULL);
        return NULL;
    }
    
    i = AI_String_GetLength(s) + 1;
    
    if(i > (len + 1)){
        i = len + 1;
    }
    
    str = malloc(i);
    
    if(str == NULL){
        AI_SpeakError("Allocation error.", NULL);
        exit(EXIT_FAILURE);
    }
    
    for(i = 0; s[i + start] != '\0'; i++){
        if(len <= 0){
            break;
        }
        len--;
        str[i] = s[i + start];
    }
    str[i] = '\0';
    
    return str;
}

int AI_String_GetLength(const char s[])
{
    //終端文字を含めない時の、文字列のバイト数を返す。
    int i;
    
    for(i = 0; s[i] != 0x00; i++){
        
    }
    
    return i;
}

int AI_String_CompareString(const char s[], const char search[])
{
    //s[]の先頭からsearch[]と比較し、searchの終端まで一致したらTrue, 一致しなかったらFalseを返す。
    //終端文字'\0'はカウントしない。
    //search[]に含まれる文字（終端文字除く）がすべて入っていれば一致とみなす。
    int i;
    
    if(s == NULL || search == NULL){
        debug("Null str.\n", NULL);
        return False;
    }
    
    for(i = 0; search[i] != '\0'; i++){
        if(s[i] != search[i]){
            return False;
        }
    }
    return True;
}

int AI_String_CompareString_Strict(const char s[], const char search[])
{
    //二つの文字列が終端文字までを含めて完全に一致するかどうか調べる。一致していればTrueを返す。
    int i;
    
    if(s == NULL || search == NULL){
        debug("Null str.\n", NULL);
        return False;
    }
    
    for(i = 0; search[i] != '\0'; i++){
        if(s[i] != search[i]){
            return False;
        }
    }
    if(s[i] != '\0'){
        return False;
    }
    return True;
}

int AI_String_SearchLocationFromArray(const char s[], AI_Array *start, int *location)
{
    //s[]に含まれている中で最も左側にあるArrayの文字列((char *)pointer)のArrayにおける添字と、その文字列が開始する場所を返す。
    //locaton!=NULLの時、*locationに、発見された文字列の最初のバイトのsにおける添字が代入される。
    //Arrayの文字列がすべて見つからなかった場合、AI_ARRAY_INDEX_NOTFOUNDを返す。そのときの*locatonには0が代入される。
    int i, j, j_max;
    
    j_max = AI_Array_GetNumberOfTags(start);
    for(i = 0; s[i] != '\0'; i++){
        for(j = 0; j < j_max; j++){
            if(AI_String_CompareString(&s[i], (char *)AI_Array_GetPointerByIndex(start, j))){
                if(location != NULL){
                    *location = i;
                }
                return j;
            }
            
        }
    }
    if(location != NULL){
        *location = 0;
    }
    return AI_ARRAY_INDEX_NOTFOUND;
}



