//
//  mem_m.c
//  AI002
//
//  Created by 西田　耀 on 13/01/03.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#include "core.h"

AI_Memory_DataTag_M *AI_Memory_DataTag_M_Allocate(void)
{
    AI_Memory_DataTag_M *tag;
    
    tag = (AI_Memory_DataTag_M *)malloc(sizeof(AI_Memory_DataTag_M));
    
    if(tag == NULL){
        AI_SpeakError("Allocation error.\n", NULL);
        exit(EXIT_FAILURE);
    }
    
    memset(tag, 0, sizeof(AI_Memory_DataTag_M));
    tag->type = 'M';
    
    return tag;
}

void AI_Memory_DataTag_M_Free(AI_Memory_DataTag_M *tag)
{
    if(tag->description != NULL){
        free(tag->description);
    }
    free(tag);
    return;
}

void AI_Memory_DataTag_M_ReadSaveData(const char line[])
{
    AI_Array *separated;
    AI_Memory_DataTag_M *tagM;
    
    separated = AI_Array_Initialize();
    AI_Array_GetSeparatedStringByArray(&separated, &AI_SystemStringList, line);
    
    tagM = AI_Memory_DataTag_M_Allocate();
    tagM->dataID = AI_Memory_AddRootData(AI_strtol(line, NULL, 0), tagM);
    if(tagM->dataID == AI_DATAID_NULL){
        //add failed.
        AI_Memory_DataTag_M_Free(tagM);
    } else{
        tagM->description = AI_String_ExtractByLength(AI_Array_GetPointerByIndex(separated, 2), 0, AI_MAX_STRINGLENGTH);
        AI_Array_AppendLast(&AI_MainMemory.list_mean, tagM->dataID, tagM->description);
    }
    
    AI_Array_FreePointer(separated);
    AI_Array_Free(&separated);
    
    return;
}

void AI_Memory_DataTag_M_WriteSaveData(FILE *fp, AI_Memory_DataTag_M *tag)
{
    fprintf(fp, "M0x%08X:%s\n", tag->dataID, tag->description);
    return;
}
