//
//  chnlib00.c
//  AI003
//
//  Created by 西田　耀 on 13/01/28.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

//UIPArray関連のうち、このソースファイルで完結する関数群

//
//Include headers
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chnlib.h"

//
//Define values
//
#define CHNLIB_UIPArray_INTERNAL_PACKDATAS   7

//
//Declare internal functions
//
CHNLIB_UIPArray *CHNLIB_UIPArray_Internal_Allocate(void);

//
//Define types
//
typedef struct CHNLIB_UIPARRAY_INTERNAL_TAG CHNLIB_UIPArray_Internal_Tag;
struct CHNLIB_UIPARRAY_INTERNAL_TAG {
    //UIPArrayの一つの添字に対応するデータを格納する構造体
    uint data32;
    void *pointer;
};

struct CHNLIB_UIPARRAY {
    //UnsignedIntとPointerを格納するArray構造体
    CHNLIB_StructureHeader header;
    
    int using_tags;    //Number of using tags in this pack.
    CHNLIB_UIPArray_Internal_Tag tag[CHNLIB_UIPArray_INTERNAL_PACKDATAS];
    CHNLIB_UIPArray *next;
};

//
//Functions
//
CHNLIB_UIPArray *CHNLIB_UIPArray_Initialize(void)
{
    //ポインタを初期化する(NULLを返す)。
    return NULL;
}

int CHNLIB_UIPArray_AppendLast(CHNLIB_UIPArray **array, uint data32, void *pointer)
{
    //Arrayの末尾にデータを追加する。
    int index;
    
    index = 0;
    for(; *array != NULL && (*array)->using_tags == CHNLIB_UIPArray_INTERNAL_PACKDATAS; array = &((*array)->next)){
        index += CHNLIB_UIPArray_INTERNAL_PACKDATAS;
    }
    
    if(*array == NULL){
        *array = CHNLIB_UIPArray_Internal_Allocate();
    }
    (*array)->tag[(*array)->using_tags].data32 = data32;
    (*array)->tag[(*array)->using_tags].pointer = pointer;
    (*array)->using_tags++;
    
    return index + (*array)->using_tags - 1;
}

int CHNLIB_UIPArray_AppendLast_ProtectFromDuplication(CHNLIB_UIPArray **array, uint data32, void *pointer, int (*IsDuplicated)(const void *listtag, const void *newtag))
{
    //戻り値:IsAdded(True/False)
    //int (*IsDuplicated)(void *listtag, void *newtag)は、重複を確認する関数へのポインタ。
    //listtagにarrayのすべてのpointerを与え、すべてがFalseだった場合追加してFalseを返す。
    //Trueが返った時点で、追加をせずTrueを返す。
    int i, i_max;
    
    i_max = CHNLIB_UIPArray_GetNumberOfDatas(*array);
    for(i = 0; i < i_max; i++){
        if(IsDuplicated(CHNLIB_UIPArray_GetPointerByIndex(*array, i), pointer)){
            return False;
        }
    }
    
    CHNLIB_UIPArray_AppendLast(array, data32, pointer);
    
    return True;
}

int CHNLIB_UIPArray_RemoveByIndex(CHNLIB_UIPArray **array, int index)
{
    //戻り値:削除が成功したか（0:成功,-1:指定された添字の要素は存在しない）
    //indexが指し示す要素を削除し、後続の要素は前へつめる。
    //削除された要素に格納されていたデータに関しては関知しない。
    int i;
    
    for(; (index / CHNLIB_UIPArray_INTERNAL_PACKDATAS) > 0; index -= CHNLIB_UIPArray_INTERNAL_PACKDATAS){
        if(*array == NULL){
            return -1;
        }
        array = &(*array)->next;
    }
    if(*array == NULL){
        return -1;
    }
    if(index >= (*array)->using_tags){
        return -1;
    }
    for(i = index; i < (*array)->using_tags - 1; i++){
        (*array)->tag[i] = (*array)->tag[i + 1];
    }
    for(;;){
        if((*array)->next != NULL){
            if((*array)->using_tags != CHNLIB_UIPArray_INTERNAL_PACKDATAS || (*array)->next->using_tags == 0){
                //タグ数とリンクの関係があわない。以下の状態になっている。
                //次のパックがあるのに、間のパックが使い切られていない。
                //次のパックがあるのに、次のパックに一つもデータがない。
                CHNLIB_ReportError("Internal data error.", CHNLIB_DEBUG_ARGUMENTS);
            }
            (*array)->tag[CHNLIB_UIPArray_INTERNAL_PACKDATAS - 1] = (*array)->next->tag[0];
            array = &(*array)->next;
            for(i = 0; i < (*array)->using_tags - 1; i++){
                (*array)->tag[i] = (*array)->tag[i + 1];
            }
        } else{
            (*array)->using_tags--;
            if((*array)->using_tags == 0){
                //もうこのパックにはデータが存在しないので、パックを削除。
                CHNLIB_System_FreeMemory(*array, CHNLIB_DEBUG_ARGUMENTS);
                *array = NULL;
            }
            break;
        }
    }
    return 0;
}

void CHNLIB_UIPArray_FreeOnlyArray(CHNLIB_UIPArray **array)
{
    //ArrayそのものをFreeする。
    //Pointerの参照先については関知しない。
    CHNLIB_UIPArray *now, *next;
    
    now = *array;
    *array = NULL;
    
    for(; now != NULL; ){
        next = now->next;
        //free(now);
        CHNLIB_System_FreeMemory(now, CHNLIB_DEBUG_ARGUMENTS);
        now = next;
    }
    return;
}

void CHNLIB_UIPArray_FreeOnlyAllPointer(CHNLIB_UIPArray *array)
{
    //Pointerの参照先をすべてFree.
    //Array自体はFreeしない。
    int i;
    
    for(; array != NULL; array = array->next){
        for(i = 0; i < array->using_tags; i++){
            if(array->tag[i].pointer != NULL){
                //free(array->tag[i].pointer);
                CHNLIB_System_FreeMemory(array->tag[i].pointer, CHNLIB_DEBUG_ARGUMENTS);
                array->tag[i].pointer = NULL;
            }
        }
    }
    return;
}

void CHNLIB_UIPArray_FreeOnlySelectedPointer(CHNLIB_UIPArray *array)
{
    //Pointerの参照先で、data32==FalseのものをFree.
    //Array自体はFreeしない。
    int i;
    
    for(; array != NULL; array = array->next){
        for(i = 0; i < array->using_tags; i++){
            if(array->tag[i].pointer != NULL && !array->tag[i].data32){
                //free(array->tag[i].pointer);
                CHNLIB_System_FreeMemory(array->tag[i].pointer, CHNLIB_DEBUG_ARGUMENTS);
                array->tag[i].pointer = NULL;
            }
        }
    }
    return;
}

void CHNLIB_UIPArray_FreeAll(CHNLIB_UIPArray **array)
{
    //Array及びすべてのPointerをFree.
    CHNLIB_UIPArray_FreeOnlyAllPointer(*array);
    CHNLIB_UIPArray_FreeOnlyArray(array);
    return;
}

void CHNLIB_UIPArray_FreeSelectedAll(CHNLIB_UIPArray **array)
{
    //Array及びdata32==TrueのPointerをFree.
    CHNLIB_UIPArray_FreeOnlySelectedPointer(*array);
    CHNLIB_UIPArray_FreeOnlyArray(array);
    return;
}

int CHNLIB_UIPArray_GetNumberOfDatas(const CHNLIB_UIPArray *array)
{
    //Arrayで現在使用中のデータの個数を返す。
    int tags;
    
    tags = 0;
    
    for(; array != NULL; array = array->next){
        tags += array->using_tags;
    }
    return tags;
}

uint CHNLIB_UIPArray_GetData32ByIndex(const CHNLIB_UIPArray *array, int index)
{
    //retv:array[index]->data32
    for(; (index / CHNLIB_UIPArray_INTERNAL_PACKDATAS) > 0; index -= CHNLIB_UIPArray_INTERNAL_PACKDATAS){
        if(array == NULL){
            return 0;
        }
        array = array->next;
    }
    if(array == NULL){
        return 0;
    }
    return array->tag[index].data32;
}

uint CHNLIB_UIPArray_SetData32ByIndex(CHNLIB_UIPArray *array, int index, uint data32)
{
    //retv = old data32
    
    uint olddata;
    
    for(; (index / CHNLIB_UIPArray_INTERNAL_PACKDATAS) > 0; index -= CHNLIB_UIPArray_INTERNAL_PACKDATAS){
        if(array == NULL){
            return 0;
        }
        array = array->next;
    }
    if(array == NULL){
        return 0;
    }
    olddata = array->tag[index].data32;
    array->tag[index].data32 = data32;
    return olddata;
}

void *CHNLIB_UIPArray_GetPointerByIndex(const CHNLIB_UIPArray *array, int index)
{
    //retv:array[index]->pointer
    for(; (index / CHNLIB_UIPArray_INTERNAL_PACKDATAS) > 0; index -= CHNLIB_UIPArray_INTERNAL_PACKDATAS){
        if(array == NULL){
            return NULL;
        }
        array = array->next;
    }
    if(array == NULL){
        return NULL;
    }
    return array->tag[index].pointer;
}

int CHNLIB_UIPArray_GetIndexByData32(const CHNLIB_UIPArray *array, uint data32)
{
    //指定されたdata32を持つ最小のIndexを返す。
    int i, i_max;
    
    i_max = CHNLIB_UIPArray_GetNumberOfDatas(array);
    for(i = 0; i < i_max; i++){
        if(CHNLIB_UIPArray_GetData32ByIndex(array, i) == data32){
            return i;
        }
    }
    return CHNLIB_UIPArray_INDEX_NOTFOUND;
}

void *CHNLIB_UIPArray_GetPointerByData32(const CHNLIB_UIPArray *array, uint data32)
{
    //指定されたdata32を持つindexのデータのPointerを返す。
    return CHNLIB_UIPArray_GetPointerByIndex(array, CHNLIB_UIPArray_GetIndexByData32(array, data32));
}

//
//Internal functions
//
CHNLIB_UIPArray *CHNLIB_UIPArray_Internal_Allocate(void)
{
    //Arrayの実体を確保する。
    //このソース以外から呼び出してはならない。
    CHNLIB_UIPArray *tag;
    
    tag = (CHNLIB_UIPArray *)CHNLIB_System_AllocateMemory_Strict(sizeof(CHNLIB_UIPArray), CHNLIB_DEBUG_ARGUMENTS);
    
    CHNLIB_StructureHeader_Initialize(&tag->header, CHNLIB_STRUCT_ID_UIPArray);
    
    return tag;

}

