//
//  chnlib.h
//  AI003
//
//  Created by 西田　耀 on 13/01/28.
//  Copyright (c) 2013年 Hikaru Nishida. All rights reserved.
//

#ifndef AI003_chnlib_h
#define AI003_chnlib_h

//
//Set compile environment
//

#define CHNLIB_MAKE_GCC_MAC
//#define CHNLIB_MAKE_BCC_WIN

#ifdef CHNLIB_MAKE_BCC_WIN
#define DEBUG
#ifndef __FUNCTION__
#define __FUNCTION__	"Unknown"
#endif
#endif

#define CHNLIB_DEBUG_ARGUMENTS  __FILE__, __LINE__, __FUNCTION__

#ifdef DEBUG
//#define DEBUG_MEMORY_ALLOCATION
#endif

//
//Define types
//

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;

typedef struct CHNLIB_STRUCTURE_HEADER CHNLIB_StructureHeader;
struct CHNLIB_STRUCTURE_HEADER {
    //ライブラリ共通構造体ヘッダ
    uint signature;
    uint typeid;
};

//
//Define library values
//

#define CHNLIB_STRUCTURE_SIGNATURE  ((uint)0x4C4E4843)  //"CHNL"(Little Endian)

#define False   0
#define True    1

#define CHNLIB_STRUCT_ID_Null       0
#define CHNLIB_STRUCT_ID_UIPArray   1
#define CHNLIB_STRUCT_ID_String     2

#define CHNLIB_MAX_STRING_LENGTH	4096

#define CHNLIB_UIPArray_INDEX_NOTFOUND  -1

//
//Declare library functions
//
//@chnlib.c
void CHNLIB_Debug(const char format[], const char filename[], int line, const char funcname[], ...);
void CHNLIB_Debug_PrintStructureData(void *structure, uint level);
void CHNLIB_ReportError(const char format[], const char filename[], int line, const char funcname[], ...);  //("", CHNLIB_DEBUG_ARGUMENTS);
void CHNLIB_StructureHeader_Initialize(CHNLIB_StructureHeader *header, uint typeid);
uint CHNLIB_StructureHeader_GetTypeID(const void *structure);
void *CHNLIB_System_AllocateMemory_Strict(int size, const char filename[], int line, const char funcname[]);
void CHNLIB_System_FreeMemory(void *p, const char filename[], int line, const char funcname[]);

//@chnlib00.c
typedef struct CHNLIB_UIPARRAY CHNLIB_UIPArray;
struct CHNLIB_UIP_ARRAY;
CHNLIB_UIPArray *CHNLIB_UIPArray_Initialize(void);
int CHNLIB_UIPArray_AppendLast(CHNLIB_UIPArray **array, uint data32, void *pointer);
int CHNLIB_UIPArray_AppendLast_ProtectFromDuplication(CHNLIB_UIPArray **array, uint data32, void *pointer, int (*IsDuplicated)(const void *listtag, const void *newtag));
int CHNLIB_UIPArray_RemoveByIndex(CHNLIB_UIPArray **array, int index);
void CHNLIB_UIPArray_FreeOnlyArray(CHNLIB_UIPArray **array);
void CHNLIB_UIPArray_FreeOnlyAllPointer(CHNLIB_UIPArray *array);
void CHNLIB_UIPArray_FreeOnlySelectedPointer(CHNLIB_UIPArray *array);
void CHNLIB_UIPArray_FreeAll(CHNLIB_UIPArray **array);
void CHNLIB_UIPArray_FreeSelectedAll(CHNLIB_UIPArray **array);
int CHNLIB_UIPArray_GetNumberOfDatas(const CHNLIB_UIPArray *array);
uint CHNLIB_UIPArray_GetData32ByIndex(const CHNLIB_UIPArray *array, int index);
uint CHNLIB_UIPArray_SetData32ByIndex(CHNLIB_UIPArray *array, int index, uint data32);
void *CHNLIB_UIPArray_GetPointerByIndex(const CHNLIB_UIPArray *array, int index);
int CHNLIB_UIPArray_GetIndexByData32(const CHNLIB_UIPArray *array, uint data32);
void *CHNLIB_UIPArray_GetPointerByData32(const CHNLIB_UIPArray *array, uint data32);

//@chnlib01.c
typedef struct CHNLIB_STRING CHNLIB_String;
struct CHNLIB_STRING;
CHNLIB_String *CHNLIB_String_Initialize(const char str[]);
void CHNLIB_String_Free(CHNLIB_String *strtag);
int CHNLIB_String_SetStringFromCString(CHNLIB_String *strtag, const char s[]);
int CHNLIB_String_Print(CHNLIB_String *strtag);
const char *CHNLIB_String_GetReferencePointerOfCString(const CHNLIB_String *strtag);
CHNLIB_String *CHNLIB_String_ExtractByLength(const CHNLIB_String *strtag, int start, int len);
int CHNLIB_String_GetLength(const CHNLIB_String *strtag);
void CHNLIB_String_DeleteLastCRLF(CHNLIB_String *strtag);
int CHNLIB_String_CompareStringWithCString(const CHNLIB_String *s, const char search[]);
int CHNLIB_String_CompareString_Strict(const CHNLIB_String *s, const CHNLIB_String *search);
uint CHNLIB_String_GetCountOfContain(const CHNLIB_String *s, const CHNLIB_String *search);
//--
int CHNLIB_CString_GetByteLength(const char s[]);
void CHNLIB_CString_DeleteLastCRLF(char s[]);
char *CHNLIB_CString_ExtractByLength(const char s[], int start, int len);
int CHNLIB_CString_CompareString(const char s[], const char search[]);
int CHNLIB_CString_CompareString_Strict(const char s[], const char search[]);
int CHNLIB_CString_CompareString_LeftHand(const char s[], const char search[]);
//@chnlib02.c
int CHNLIB_String_Search_UIPArrayStringLocation(const CHNLIB_String *s, int s_start, const CHNLIB_UIPArray *list, int *location);
int CHNLIB_UIPArray_GetSeparatedStringByUIPArray(CHNLIB_UIPArray **separated, const CHNLIB_UIPArray *list, const CHNLIB_String *s);
int CHNLIB_UIPArray_GetSeparatedUTF8Character(CHNLIB_UIPArray **separated, const CHNLIB_String *s);
CHNLIB_String *CHNLIB_ReadLine(FILE *fp);

//@chnlib03.c
void CHNLIB_Environment_SetCurrentWorkingDirectory(const char apppath[]);
const char *CHNLIB_Environment_GetFilenameFromPath(const char path[]);

//@chnlib05.c
int CHNLIB_UTF8_GetCharacterType(char c);
int CHNLIB_UTF8_GetStringLengthByCharacter(const char s[]);
uint CHNLIB_UTF8_GetNextUnicodeOfCharacter(const char s[], const char **next);
int CHNLIB_UTF8_CompareString(const char s[], const char search[]);
int CHNLIB_UTF8_CompareString_LeftHand(const char s[], const char search[]);
int CHNLIB_UTF8_GetByteSizeFromLengthByCharacter(const char s[], int start, int end);
uint CHNLIB_UTF8_GetCountOfContain(const char s[], const char search[]);

#endif
