package net.minecraft.src.ChemiCraft;

import java.util.ArrayList;
import java.util.Properties;

import net.minecraft.src.Block;
import net.minecraft.src.CreativeTabs;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod( modid = "chemiCraft", name="ChemiCraft", version="eXg") //ID,O,o[W
@NetworkMod(clientSideRequired = true, serverSideRequired = true, versionBounds = "[1.3.2]") //NCAgAT[o[ɕKv 1.3.2p

public class ChemiCraft
{

	public static final CreativeTabs tabAtoms = new CreativeTabAtoms("tabAtoms");

	public static final String[] atomsName = {
		"Hydrogen", "Helium","Lithium","Beryllium","Boron","Carbon","Nitrogen","Oxygen","Fluorine","Neon",
		"Sodium","Magnesium","Aluminium","Silicon","Phosphorus","Sulfur","Chlorine","Argon","Potassium","Calcium",
		"Scandium","Titanium","Vanadium","Chromium","Manganese","Iron","Cobalt","Nickel","Copper","Zinc",
		"Gallium","Germanium","Arsenic","Selenium","Bromine","Krypton","Rubidium","Strontium","Yttorium","Zirconium",
		"Niobium","Molybdenum","Technetium","Ruthenium","Rhodium","Palladium","Silver","Cadmium","Indium","Tin",
		"Antimony","Tellurium","Iodine","Xenon","Caesium","Barium","Lanthanum","Cerium","Praseodymium","Neodymium",
		"Promethium","Samarium","Europium","Gadolinium","Terbium","Dysprosium","Holmium","Erbium","Thulium","Ytterbium",
		"Lutetium","Hafnium","Tantalum","Tungsten","Rhenium","Osmium","Iridium","Platinum","Gold","Mercury",
		"Thallium","Lead","Bismuth","Polonium","Astatine","Radon","Francium","Radium","Actinium","Thorium",
		"Protactinium","Uranium","Neptunium","Plutonium","Americium","Curium","Berkelium","Californium","Einsteinium","Fermium",
		"Mendelevium","Nobelium","Lawrencium","Rutherfordium","Dubnium","Seaborgium","Bohrium","Hassium","Meitnerium","Darmstadtium",
		"Roentgenium","Copernicium","Ununtrium","Ununquadium","Ununpentium","Ununhexium","","Ununoctium"
	};

	public static final String[] atomsNameJP = {
		"f", "wE", "`E", "xE", "zEf", "Yf", "f", "_f", "tbf", "lI",
		"igE", "}OlVE", "A~jE", "PCf", "", "", "f", "AS", "JE", "JVE",
		"XJWE", "`^", "oiWE", "N", "}K", "S", "Rog", "jbP", "", "",
		"KE", "Q}jE", "qf", "Z", "Lf", "Nvg", "rWE", "Xg`E", "CbgE", "WRjE",
		"jIu", "uf", "eNl`E", "ejE", "WE", "pWE", "", "Jh~E", "CWE", "XY",
		"A`", "e", "Ef", "LZm", "ZVE", "oE", "^", "ZE", "vZIW", "lIW",
		"v`E", "T}E", "ErE", "KhjE", "erE", "WXvjE", "z~E", "GrE", "cE", "CberE",
		"e`E", "ntjE", "^^", "^OXe", "jE", "IX~E", "CWE", "", "", "",
		"^E", "", "rX}X", "|jE", "AX^`", "h", "tVE", "WE", "AN`jE", "gE",
		"vgAN`E", "E", "lvcjE", "vgjE", "AVE", "LE", "o[NE", "JzjE", "ACX^CjE", "tF~E",
		"frE", "m[xE", "[VE", "Tz[WE", "hujE", "V[{[ME", "{[E", "nbVE", "}CglE", "_[X^`E",
		"gQjE", "RyjVE", "EEgE", "trE", "EEy`E", "oE", "EEZv`E", "EEIN`E"
	};

	private ChemiCraftAPI chemiCraftAPI = ChemiCraftAPI.instance;

	public static int gasCollectingBottleID;
	public static int atomsID;
	public static int compoundsID;

	public static Item itemGasCollectingBottle;
	public static Item itemAtoms;
	public static Item itemCompounds;

	private Auxiliary Auxiliary = new Auxiliary();
	private Auxiliary.NameAuxiliary NameAuxiliary = Auxiliary.new NameAuxiliary();

	// RXgN^
	@Mod.Init
	public void chemiLoadMethod(FMLInitializationEvent event)
	{

		//̒ǉ
		ChemiCraftAPI.addLangCompound("ja_JP", "Salt", "");
	}

	@Mod.PreInit  // O
	public void chemiPreLoadMethod(FMLPreInitializationEvent event)
	{
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		cfg.load();
		Property gasCollectingBottleIDProp = cfg.getItem("gasCollectingBottleID", 25000);
		Property atomsIDProp = cfg.getItem("atomsID", 25001);
		Property compoundsIDProp = cfg.getItem("compoundsID", 25002);
		gasCollectingBottleID = gasCollectingBottleIDProp.getInt();
		atomsID = atomsIDProp.getInt();
		compoundsID = compoundsIDProp.getInt();
		cfg.save();
	}

	@Mod.PostInit // ModLoader.load\bhƓ
	public void chemiPostLoadMethod(FMLPostInitializationEvent event)
	{
		itemGasCollectingBottle = new ItemGasCollectingBottle(gasCollectingBottleID).setItemName("gasCollectingBottle");
		itemAtoms = new ItemAtoms(atomsID).setItemName("atoms");
		itemCompounds = new ItemCompounds(compoundsID).setItemName("compounds");

		NameAuxiliary.addName(itemAtoms, atomsName);
		NameAuxiliary.addName(itemAtoms, "ja_JP", atomsNameJP);
		NameAuxiliary.addName(itemCompounds, ChemiCraftAPI.getCompoundsName().toArray());
		NameAuxiliary.addName(itemCompounds, "ja_JP", ChemiCraftAPI.getCompoundsLangName().toArray());
		NameAuxiliary.addName(itemGasCollectingBottle, "GasCollectingBottle");
		NameAuxiliary.addName(itemGasCollectingBottle, "ja_JP", "WCr");

		ChemiCraftAPI.addCompoundHandler("Salt", new CompoundHandlerTest());

	}

}