package net.minecraft.src.ChemiCraft;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class AtomInfo {

	protected static int posX;
	protected static int posY;
	protected static int posZ;
	protected static String biomeName;
	protected static String weather;

	public AtomInfo(World par1World, EntityPlayer par2EntityPlayer){

		this.biomeName = par1World.getBiomeGenForCoords(posX, posZ).biomeName;

		this.posX = (int) par2EntityPlayer.posX; // XW
		this.posY = (int) par2EntityPlayer.posY; // YW
		this.posZ = (int) par2EntityPlayer.posZ; // ZW

		boolean rainy = par1World.isRaining();
		boolean thunder = par1World.isThundering();
		if (rainy && thunder){ // J
			this.weather = "THUNDER";
		}else if(rainy){ // J܂͐
			this.weather = "RAINY";
		}else{ //
			this.weather = "SUNNY";
		}
	}

	/**
	 * YWƂ̔r
	 * @param EntityPlayer EntityPlayer
	 * @param y YW
	 * @param biomeName oCI[̖O(nullł)
	 * @param weather VC(nullł)
	 * @param par1 萔
	 * @param par2 (_[Wl)
	 */
	private boolean equivalentBiome(String biomeName){
		boolean ver1 = biomeName != null ? ((this.biomeName == biomeName) ? true : false) : true;
		return ver1;
	}
	private boolean equivalentWeather(String weather){
		boolean ver1 = weather != null ? ((this.weather == weather) ? true : false) : true;
		return ver1;
	}

	protected void overY(EntityPlayer EntityPlayer, int y, String biomeName, String weather, int par1, int par2){
		if(this.posY >= y && this.equivalentBiome(biomeName) && this.equivalentWeather(weather)){
			if (!EntityPlayer.inventory.addItemStackToInventory(new ItemStack(ChemiCraft.itemAtoms, par1, par2)))
			{
				EntityPlayer.dropPlayerItem(new ItemStack(ChemiCraft.itemAtoms.shiftedIndex, par1, par2));
			}
		}
	}
	protected void aboveY(EntityPlayer EntityPlayer, int y, String biomeName, String weather, int par1, int par2){
		if(this.posY > y && this.equivalentBiome(biomeName) && this.equivalentWeather(weather)){
			if (!EntityPlayer.inventory.addItemStackToInventory(new ItemStack(ChemiCraft.itemAtoms, par1, par2)))
			{
				EntityPlayer.dropPlayerItem(new ItemStack(ChemiCraft.itemAtoms.shiftedIndex, par1, par2));
			}
		}
	}
	protected void equivalentY(EntityPlayer EntityPlayer, int y, String biomeName, String weather, int par1, int par2){
		if(this.posY == y && this.equivalentBiome(biomeName) && this.equivalentWeather(weather)){
			if (!EntityPlayer.inventory.addItemStackToInventory(new ItemStack(ChemiCraft.itemAtoms, par1, par2)))
			{
				EntityPlayer.dropPlayerItem(new ItemStack(ChemiCraft.itemAtoms.shiftedIndex, par1, par2));
			}
		}
	}
	protected void lessY(EntityPlayer EntityPlayer, int y, String biomeName, String weather, int par1, int par2){
		if(this.posY < y && this.equivalentBiome(biomeName) && this.equivalentWeather(weather)){
			if (!EntityPlayer.inventory.addItemStackToInventory(new ItemStack(ChemiCraft.itemAtoms, par1, par2)))
			{
				EntityPlayer.dropPlayerItem(new ItemStack(ChemiCraft.itemAtoms.shiftedIndex, par1, par2));
			}
		}
	}
	protected void belowY(EntityPlayer EntityPlayer, int y, String biomeName, String weather, int par1, int par2){
		if(this.posY <= y && this.equivalentBiome(biomeName) && this.equivalentWeather(weather)){
			if (!EntityPlayer.inventory.addItemStackToInventory(new ItemStack(ChemiCraft.itemAtoms, par1, par2)))
			{
				EntityPlayer.dropPlayerItem(new ItemStack(ChemiCraft.itemAtoms.shiftedIndex, par1, par2));
			}
		}
	}

}
