package chemicraft.util;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.registry.LanguageRegistry;

public class Auxiliary {

	/**
	 * 補助クラス
	 * @author mozipi
	 *
	 */
	public static class NameAuxiliary {

		/**
		 * 名前を設定します
		 * @param object
		 * @param Name
		 */
		public void addName(Object object,Object name){
			LanguageRegistry.addName(object, (String) name);
		}



		/**
		 * 名前を設定します(ItemStack版)
		 * @param object
		 * @param name
		 * @param meta
		 */
		public void addName(ItemStack itemstack,Object name){
			LanguageRegistry.addName(itemstack, (String) name);
		}



		/**
		 * 指定言語にそって名前を追加します
		 * @param object
		 * @param lang
		 * @param name
		 */
		public void addName(Object object,String lang,Object name){
			LanguageRegistry.instance().addNameForObject(object, lang, (String) name);
		}



		/**
		 * 指定言語にそって名前を追加します(ItemStack版)
		 * @param object
		 * @param lang
		 * @param name
		 */
		public void addName(ItemStack object,String lang,Object name){
			LanguageRegistry.instance().addNameForObject(object, lang, (String) name);
		}



		/**
		 * メタデータごとに名前を追加します(Block版)
		 * @param object
		 * @param name
		 */
		public void addName(Block object,Object[] name){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.addName(new ItemStack(object,0,i), (String) name[i]);
			}
		}



		/**
		 * メタデータごとに名前を追加します(Item版)
		 * @param object
		 * @param name
		 */
		public void addName(Item object,Object[] name){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.addName(new ItemStack(object,0,i), (String) name[i]);
			}
		}



		/**
		 * 指定された言語にそってメタデータごとに名前を設定します(Block版)
		 * @param object
		 * @param name
		 */
		public void addName(Block object,String lang,Object[] name){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.instance().addNameForObject(new ItemStack(object,0,i), lang, (String) name[i]);
			}
		}



		/**
		 * 指定された言語にそってメタデータごとに名前を設定します(Item版)
		 * @param object
		 * @param name
		 */
		public void addName(Item object,String lang, Object[] name){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.instance().addNameForObject(new ItemStack(object,0,i), lang, (String) name[i]);
			}
		}

		/**
		 * 指定された言語にそってメタデータごとに名前を設定します(Block版)
		 * また、配列の前に任意の文字列を追加できます。
		 * @param object
		 * @param name
		 */
		public void addName(Block object,String lang, String string, Object[] name){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.instance().addNameForObject(new ItemStack(object,0,i), lang, string + (String) name[i]);
			}
		}



		/**
		 * 指定された言語にそってメタデータごとに名前を設定します(Item版)
		 * また、配列の前に任意の文字列を追加できます。
		 * @param object
		 * @param name
		 */
		public void addName(Item object,String lang, String string, Object[] name){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.instance().addNameForObject(new ItemStack(object,0,i), lang, string + (String) name[i]);
			}
		}

		/**
		 * 指定された言語にそってメタデータごとに名前を設定します(Block版)
		 * また、配列の後ろに任意の文字列を追加できます。
		 * @param object
		 * @param name
		 */
		public void addName(Block object,String lang, Object[] name, String string){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.instance().addNameForObject(new ItemStack(object,0,i), lang, (String) name[i] + string);
			}
		}



		/**
		 * 指定された言語にそってメタデータごとに名前を設定します(Item版)
		 * また、配列の後ろに任意の文字列を追加できます。
		 * @param object
		 * @param name
		 */
		public void addName(Item object,String lang, Object[] name, String string){
			for(int i=0;i<name.length;i++){
				LanguageRegistry.instance().addNameForObject(new ItemStack(object,0,i), lang, (String) name[i] + string);
			}
		}

	}

	public static class ArrayAuxiliary{

		public ItemStack[] deleteNull(ItemStack[] array){
			int count = 0;
			ItemStack[] arrayCopy;
			for(int i = 0;i < array.length;i++){
				if(array[array.length - 1 - i] == null){
					count++;
				}else{
					break;
				}
			}
			arrayCopy = new ItemStack[array.length - count];
			for(int i = 0;i < arrayCopy.length;i++){
				arrayCopy[i] = array[i];
			}
			array = arrayCopy.clone();
			return array;
		}

	}

}
