package chemicraft.system;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import chemicraft.ChemiCraft;
import chemicraft.tileentity.TileEntityChemicalCombinationTable;
import chemicraft.tileentity.TileEntityChemicalCraftingTable;
import chemicraft.tileentity.TileEntityDecompositionTable;
import chemicraft.tileentity.TileEntityToolAndWeaponCraftingTable;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;

/**
 * サーバーとクライアントのデータの同期に必要なクラス
 *
 * @author Lilly
 *
 */
public class PacketHandler implements IPacketHandler {

	@Override
	public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
		if (packet.channel.equals("chemicraft")) {
			ByteArrayDataInput badi = ByteStreams.newDataInput(packet.data);

			World worldClient;
			World worldServer;
			TileEntity var1;

			// TileEntityのx, y, z座標
			int x, y, z;

			// 座標読み込み
			x = badi.readInt();
			y = badi.readInt();
			z = badi.readInt();

			worldClient = ChemiCraft.proxy.getClientWorld();
			worldServer = ((EntityPlayer)player).worldObj;
			if(worldClient != null && worldServer == null){
				var1 = worldClient.getBlockTileEntity(x, y, z);
				if(var1 instanceof TileEntityChemicalCombinationTable) ((TileEntityChemicalCombinationTable)var1).readPacket(badi);
				if(var1 instanceof TileEntityChemicalCraftingTable) ((TileEntityChemicalCraftingTable)var1).readPacket(badi);
				if(var1 instanceof TileEntityDecompositionTable) ((TileEntityDecompositionTable)var1).readPacket(badi);
				if(var1 instanceof TileEntityToolAndWeaponCraftingTable) ((TileEntityToolAndWeaponCraftingTable)var1).readPacket(badi);
				return;
			}
			if(worldServer != null){
				var1 = worldServer.getBlockTileEntity(x, y, z);
				if(var1 instanceof TileEntityChemicalCombinationTable) ((TileEntityChemicalCombinationTable)var1).readPacket(badi);
				if(var1 instanceof TileEntityChemicalCraftingTable) ((TileEntityChemicalCraftingTable)var1).readPacket(badi);
				if(var1 instanceof TileEntityDecompositionTable) ((TileEntityDecompositionTable)var1).readPacket(badi);
				if(var1 instanceof TileEntityToolAndWeaponCraftingTable) ((TileEntityToolAndWeaponCraftingTable)var1).readPacket(badi);
			}
			return;
		}
	}


	public static Packet getPacket(TileEntityDecompositionTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

	public static Packet getPacket(TileEntityChemicalCombinationTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

	public static Packet getPacket(TileEntityToolAndWeaponCraftingTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

	public static Packet getPacket(TileEntityChemicalCraftingTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

}
