package chemicraft.system;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import chemicraft.container.ContainerChemicalCombinationTable;
import chemicraft.container.ContainerChemicalCraftingTable;
import chemicraft.container.ContainerDecompositionTable;
import chemicraft.container.ContainerElectrolysisTable;
import chemicraft.container.ContainerToolAndWeaponCraftingTable;
import chemicraft.tileentity.TileEntityChemicalCombinationTable;
import chemicraft.tileentity.TileEntityChemicalCraftingTable;
import chemicraft.tileentity.TileEntityDecompositionTable;
import chemicraft.tileentity.TileEntityElectrolysisTable;
import chemicraft.tileentity.TileEntityToolAndWeaponCraftingTable;
import cpw.mods.fml.common.network.IGuiHandler;

public class CommonProxy implements IGuiHandler {

	public void registerTextures(){

	}

	public void registerRenderInformation() {
	}


	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if (!world.blockExists(x, y, z))
			return null;

		TileEntity tileEntity = world.getBlockTileEntity(x, y, z);
		if (tileEntity instanceof TileEntityDecompositionTable) {
			return new ContainerDecompositionTable(player, (TileEntityDecompositionTable) tileEntity);
		}else if(tileEntity instanceof TileEntityChemicalCombinationTable){
			return new ContainerChemicalCombinationTable(player, (TileEntityChemicalCombinationTable) tileEntity);
		}else if(tileEntity instanceof TileEntityToolAndWeaponCraftingTable){
			return new ContainerToolAndWeaponCraftingTable(player, (TileEntityToolAndWeaponCraftingTable) tileEntity);
		}else if(tileEntity instanceof TileEntityChemicalCraftingTable){
			return new ContainerChemicalCraftingTable(player, (TileEntityChemicalCraftingTable) tileEntity);
		}else if(tileEntity instanceof TileEntityElectrolysisTable){
			return new ContainerElectrolysisTable(player, (TileEntityElectrolysisTable)tileEntity);
		}
		return null;
	}


	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		return null;
	}

	public World getClientWorld(){
		return null;
	}

}