package chemicraft.system;

import java.util.ArrayList;
import java.util.Arrays;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import chemicraft.ChemiCraftAPI;
import chemicraft.inventory.InventoryChemicalCraftingMaterial;
import chemicraft.inventory.InventoryChemicalCraftingNBT;
import chemicraft.inventory.InventoryChemicalCraftingResult;
import chemicraft.util.ChemicalNBTRecipe;
import chemicraft.util.ComparatorFormulaPart;
import chemicraft.util.FormulaPart;

public class ChemiCraftCraftingManager {

	public ItemStack[] getDecompositionResults(IInventory par1IInventory){
		return null;
	}



	public ItemStack getChemicalCombinationResult(ArrayList<String> atomsList, ArrayList<Integer> atomsAmountList){
		ChemiCraftAPI api = ChemiCraftAPI.getInstance();
		recipeSize :
			for (int i = 0; i < api.getChemicalCombinationAtoms().size(); i++) {
				FormulaPart[] var1 = new FormulaPart[atomsList.size()];
				FormulaPart[] var2 = new FormulaPart[api.getChemicalCombinationAtoms().get(i).length];
				for (int j = 0; j < atomsList.size(); j++) {
					var1[j] = new FormulaPart(atomsList.get(j), atomsAmountList.get(j));
				}
				for (int j = 0; j < api.getChemicalCombinationAtoms().get(i).length; j++) {
					var2[j] = new FormulaPart(api.getChemicalCombinationAtoms().get(i)[j], api.getChemicalCombinationAmounts().get(i)[j]);
				}
				Arrays.sort(var1, new ComparatorFormulaPart());
				Arrays.sort(var2, new ComparatorFormulaPart());
				if (var1.length != var2.length) {
					continue recipeSize;
				}
				for (int j = 0; j < var1.length; j++) {
					if (!var1[j].equals(var2[j])) {
						continue recipeSize;
					}
				}
				return api.getChemicalCombinationResult().get(i);
			}
		return null;
	}



	public ChemicalNBTRecipe chemicalCrafting(InventoryChemicalCraftingMaterial par1IInventory, InventoryChemicalCraftingResult par2IInventory, InventoryChemicalCraftingNBT par3IInventory){
		ChemiCraftAPI api = ChemiCraftAPI.getInstance();
		ChemicalNBTRecipe returnObj = null;
		for(int i = 0;i < api.getMaterialRecipe().size();i++){
			ItemStack result = api.getMaterialRecipe().get(i).match(par1IInventory);
			ItemStack resultArg = null;
			if(result != null){
				resultArg = new ItemStack(result.itemID, result.stackSize, result.getItemDamage());
				if(api.getMaterialRecipe().get(i).nbtMatch(par1IInventory) != null){
					ItemStack[] nbtInv = new ItemStack[par3IInventory.getSizeInventory()];
					for(int j = 0;j < par3IInventory.getSizeInventory();j++){
						nbtInv[j] = par3IInventory.getStackInSlot(j);
					}
					api.getMaterialRecipe().get(i).nbtMatch(par1IInventory).setNBT(nbtInv, resultArg);
				}
				returnObj = api.getMaterialRecipe().get(i).nbtMatch(par1IInventory);
			}
			par2IInventory.setInventorySlotContents(0, resultArg);
		}
		return returnObj;
	}



	private void clearResults(IInventory par1IInventory, int par2){
		/*
		 * Commented by mozipi.
		((InventoryDecomposition)par1IInventory).setFlag(false);
		 */
		for(int i = 0;i < par2;i++){
			par1IInventory.setInventorySlotContents(i, null);
		}
	}

}
