package chemicraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import chemicraft.ChemiCraft;
import chemicraft.ChemiCraftAPI;
import chemicraft.util.MathHelperPlus;

public class ItemGasCollectingBottle extends ItemAtomInfoContainer
{

	public ItemGasCollectingBottle(int id) {
		super(id);
		this.setMaxStackSize(1);
		this.setMaxDamage(2);
		this.setCreativeTab(ChemiCraft.instance.creativeTab);
	}

	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
	{
		par1ItemStack.damageItem(1, par3EntityPlayer);

		this.atomInfo.update(par2World, par3EntityPlayer);

		int heightValue = par2World.getHeightValue((int) par3EntityPlayer.posX, (int) par3EntityPlayer.posZ);

		int result1 = MathHelperPlus.probability(99, 1);
		int result2 = MathHelperPlus.probability(78, 21, 1);
		int result3 = MathHelperPlus.probability(0.032, 0.0018, 0.000012, 0.00052);
		if (this.atomInfo.isOverY(heightValue)) {
			if (result1 == 0) {
				if (result2 == 0) {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemAtoms, 1, 6), par3EntityPlayer);
				} else if (result2 == 1) {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemAtoms, 1, 7), par3EntityPlayer);
				} else {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemAtoms, 1, 17), par3EntityPlayer);
				}
			} else {
				if (result3 == 0) {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemCompounds, 1, ChemiCraftAPI.getInstance().getCompound("CarbonDioxide")), par3EntityPlayer);
				} else if (result3 == 1) {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemAtoms, 1, 9), par3EntityPlayer);
				} else if (result3 == 2) {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemCompounds, 1, 1), par3EntityPlayer);
				} else {
					this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemAtoms, 1, 1), par3EntityPlayer);
				}
			}
		}

		// デバッグ用
		if (par2World.isRemote) {
			par3EntityPlayer.addChatMessage("result1=" + result1 + " result2=" + result2 + " result3=" + result3);
			par3EntityPlayer.addChatMessage("このメッセージは開発版のみの表示ですが、もし製品版で表示されていた場合はご連絡ください。");
		}

		return par1ItemStack;
	}

	public void isStackOrDrop(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer)
	{
		if (!par2EntityPlayer.inventory.addItemStackToInventory(par1ItemStack)) {
			par2EntityPlayer.dropPlayerItem(par1ItemStack);
		}
	}

	@Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10)
	{
		int blockID = par3World.getBlockId(par4, par5, par6);
		Block block = Block.blocksList[blockID];

		int uniqueBlockID = par3World.getBlockId(par4, par5 + 1, par6);
		Block uniqueBlock = Block.blocksList[uniqueBlockID];

		if (uniqueBlock instanceof BlockFire){
			par1ItemStack.damageItem(1, par2EntityPlayer);

			int result1 = MathHelperPlus.probability(90, 10);

			if (result1 == 0) {
				this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemCompounds, 1, ChemiCraftAPI.getInstance().getCompound("CarbonDioxide")), par2EntityPlayer);
			} else {
				this.isStackOrDrop(new ItemStack(ChemiCraft.instance.itemCompounds, 1, ChemiCraftAPI.getInstance().getCompound("CarbonMonoxide")), par2EntityPlayer);
			}

			return true;
		}
		return false;
	}

	@Override
	public String getTextureFile()
	{
		return "/chemicraft/items/items.png";
	}

}
