package chemicraft.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.world.World;
import chemicraft.ChemiCraft;
import chemicraft.inventory.InventoryElectrolysisFuel;
import chemicraft.inventory.InventoryElectrolysisMaterial;
import chemicraft.inventory.InventoryElectrolysisResult;
import chemicraft.slot.SlotElectrolysisMaterial;
import chemicraft.slot.SlotElectrolysisResult;
import chemicraft.tileentity.TileEntityElectrolysisTable;

public class ContainerElectrolysisTable extends Container
{

	private World worldObj;

	private int posX;
	private int posY;
	private int posZ;

	private TileEntityElectrolysisTable tileEntity;

	private InventoryElectrolysisMaterial invm;
	private InventoryElectrolysisResult invr;
	private InventoryElectrolysisFuel invf;

	public ContainerElectrolysisTable(EntityPlayer par1EntityPlayer, TileEntityElectrolysisTable par2) {
		super();
		this.worldObj = par2.worldObj;
		this.posX = par2.xCoord;
		this.posY = par2.yCoord;
		this.posZ = par2.zCoord;
		this.invm = (InventoryElectrolysisMaterial) this.tileEntity.getInvMaterial();
		this.invr = (InventoryElectrolysisResult) this.tileEntity.getInvResult();
		this.invf = (InventoryElectrolysisFuel) this.tileEntity.getInvFuel();

		this.addSlotToContainer(new SlotElectrolysisMaterial(invm, 0, 123, 34));
		for (int i = 0; i < 16; i++) {
			this.addSlotToContainer(new SlotElectrolysisResult(invr, i, 123, 34));
		}
		this.addSlotToContainer(new SlotElectrolysisResult(invf, 0, 123, 34));

		int var3;
		for (var3 = 0; var3 < 3; ++var3)
		{
			for (int var4 = 0; var4 < 9; ++var4)
			{
				this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var4 + var3 * 9 + 9, 8 + var4 * 18, 85 + var3 * 18));
			}
		}

		for (var3 = 0; var3 < 9; ++var3)
		{
			this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var3, 8 + var3 * 18, 143));
		}

	}

	@Override
	public boolean canInteractWith(EntityPlayer par1EntityPlayer)
	{
		return this.worldObj.getBlockId(this.posX, this.posY, this.posZ) != ChemiCraft.instance.electrolysisTableID ? false : par1EntityPlayer.getDistanceSq((double) this.posX + 0.5D, (double) this.posY + 0.5D, (double) this.posZ + 0.5D) <= 64.0D;
	}

}
