// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: TableAdapterTransactor.cs 31 2007-10-22 07:36:27Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

using System.Data;
using System.Data.SQLite;
using System.Reflection;

namespace Chattr
{
    /// <summary>
    /// TableAdapterɃgUNV@\NX
    /// </summary>
    /// <remarks>
    /// p@̗
    ///     TableAdapterTransactor tat = new TableAdapterTransactor();
    ///     Data1TableAdapter taData1 = new Data1TableAdapter();
    ///     Data2TableAdapter taData2 = new Data2TableAdapter();
    ///     
    ///     tat.AddTableAdapter(taData1);
    ///     tat.AddTableAdapter(taData2);
    ///     tat.BeginTransaction();
    ///     try {
    ///         taData1.Insert...();
    ///         taData2.Insert...();
    ///         tat.Commit();
    ///     }
    ///     catch (Exception ex) {
    ///         tat.Rollback();
    ///     }
    ///
    /// http://www.ailight.jp/blog/unaap/archive/2007/02/13/13566.aspx
    /// </remarks>
    class TableAdapterTransactor
    {
        private SQLiteConnection _conn = null;
        private SQLiteTransaction _trans = null;
        private List<object> _tableAdapters = new List<object>();

        #region "PvV[W - GetConnection                     [TableAdapterConnection擾]"

        /// <summary>
        /// TableAdapterConnection擾
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <returns>擾Connection</returns>
        /// <remarks></remarks>
        private SQLiteConnection GetConnection(object tableAdapter)
        {
            Type type = tableAdapter.GetType();
            PropertyInfo connectionProperty = type.GetProperty("Connection", BindingFlags.NonPublic | BindingFlags.Instance);
            SQLiteConnection connection = (SQLiteConnection)connectionProperty.GetValue(tableAdapter, null);
            return connection;
        }
        #endregion

        #region "PvV[W - SetConnection                     [TableAdapterConnectionݒ肷]"

        /// <summary>
        /// TableAdapterConnectionݒ肷
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <param name="connection">Connection</param>
        /// <remarks></remarks>
        private void SetConnection(object tableAdapter, SQLiteConnection connection)
        {
            Type type = tableAdapter.GetType();
            PropertyInfo connectionProperty = type.GetProperty("Connection", BindingFlags.NonPublic | BindingFlags.Instance);
            connectionProperty.SetValue(tableAdapter, connection, null);
        }
        #endregion

        #region "PvV[W - GetAdapter                        [TableAdapterDataAdapter擾]"

        /// <summary>
        /// TableAdapterDataAdapter擾
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <returns>擾DataAdapter</returns>
        /// <remarks></remarks>
        private SQLiteDataAdapter GetAdapter(object tableAdapter)
        {
            Type type = tableAdapter.GetType();
            FieldInfo adapterField = type.GetField("_adapter", BindingFlags.NonPublic | BindingFlags.Instance);
            SQLiteDataAdapter adapter = (SQLiteDataAdapter)adapterField.GetValue(tableAdapter);
            return adapter;
        }
        #endregion
        #region "PvV[W - SetAdapter                        [TableAdapterDataAdapterݒ肷]"
        /// <summary>
        /// TableAdapterDataAdapterݒ肷
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <param name="adapter">DataAdapter</param>
        /// <remarks></remarks>
        private void SetAdapter(object tableAdapter, SQLiteDataAdapter adapter)
        {
            Type type = tableAdapter.GetType();
            FieldInfo adapterField = type.GetField("_adapter", BindingFlags.NonPublic | BindingFlags.Instance);
            adapterField.SetValue(tableAdapter, adapter);
        }
        #endregion
        #region "PvV[W - InitAdapter                       [TableAdapterInitAdapter\bhĂяo]"
        /// <summary>
        /// TableAdapterInitAdapter\bhĂяo
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <remarks>pȂ</remarks>
        private void InitAdapter(object tableAdapter)
        {
            Type type = tableAdapter.GetType();
            MethodInfo mi = type.GetMethod("InitAdapter", BindingFlags.NonPublic | BindingFlags.Instance);
            mi.Invoke(tableAdapter, null);
        }
        #endregion
        #region "PvV[W - InitCommandCollection             [TableAdapterInitCommandCollection\bhĂяo]"
        /// <summary>
        /// TableAdapterInitCommandCollection\bhĂяo
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <remarks>pȂ</remarks>
        private void InitCommandCollection(object tableAdapter)
        {
            Type type = tableAdapter.GetType();
            MethodInfo mi = type.GetMethod("InitCommandCollection", BindingFlags.NonPublic | BindingFlags.Instance);
            mi.Invoke(tableAdapter, null);
        }
        #endregion
        #region "PvV[W - SetTransactionCommands            [TableAdapterCommandCollectionTransactionݒ肷]"
        /// <summary>
        /// TableAdapterCommandCollectionTransactionݒ肷
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <param name="transaction">Transaction</param>
        /// <remarks></remarks>
        private void SetTransactionCommands(object tableAdapter, SQLiteTransaction transaction)
        {
            Type type = tableAdapter.GetType();
            PropertyInfo commandsProperty = type.GetProperty("CommandCollection", BindingFlags.NonPublic | BindingFlags.Instance);
            SQLiteCommand[] commands = (SQLiteCommand[])commandsProperty.GetValue(tableAdapter, null);
            foreach (SQLiteCommand command in commands)
            {
                command.Transaction = transaction;
            }
            this.SetConnection(tableAdapter, transaction.Connection);
        }
        #endregion
        #region "PvV[W - SetTransactionAdapter             [TableAdapterDataAdapterTransactionݒ肷]"
        /// <summary>
        /// TableAdapterDataAdapterTransactionݒ肷
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <param name="transaction">Transaction</param>
        /// <remarks></remarks>
        private void SetTransactionAdapter(object tableAdapter, SQLiteTransaction transaction)
        {
            SQLiteDataAdapter adp = this.GetAdapter(tableAdapter);
            if (adp.InsertCommand != null)
            {
                adp.InsertCommand.Transaction = transaction;
            }
            if (adp.DeleteCommand != null)
            {
                adp.DeleteCommand.Transaction = transaction;
            }
            if (adp.UpdateCommand != null)
            {
                adp.UpdateCommand.Transaction = transaction;
            }
            this.SetAdapter(tableAdapter, adp);
            //this.InitCommandCollection(tableAdapter)
        }
        #endregion
        #region "\bh - AddTableAdapter                        [TableAdapterǉ]"
        /// <summary>
        /// TableAdapterǉ
        /// </summary>
        /// <param name="tableAdapter">TableAdapter</param>
        /// <remarks></remarks>
        public void AddTableAdapter(object tableAdapter)
        {
            this._tableAdapters.Add(tableAdapter);
        }
        #endregion
        #region "\bh - BeginTransaction                       [gUNVJn]"
        /// <summary>
        /// gUNVJn
        /// </summary>
        /// <remarks>JnOɁAAddTableAdapter\bhőΏۂƂȂTableAdapterǉ邱</remarks>
        public void BeginTransaction()
        {
            int counter = 0;
            foreach (object adapter in this._tableAdapters)
            {
                counter += 1;
                if (counter == 1)
                {
                    this._conn = this.GetConnection(adapter);
                    if (this._conn.State != ConnectionState.Open)
                    {
                        this._conn.Open();
                    }
                    this._trans = this._conn.BeginTransaction();
                }
                this.SetConnection(adapter, this._conn);
                this.SetTransactionAdapter(adapter, this._trans);
                this.SetTransactionCommands(adapter, this._trans);
            }
        }
        /// <summary>
        /// gUNVJn
        /// </summary>
        /// <param name="conn">RlNV</param>
        /// <remarks></remarks>
        public void BeginTransaction(SQLiteConnection conn)
        {
            this._conn = conn;
            if (this._conn.State != ConnectionState.Open)
            {
                this._conn.Open();
            }
            this._trans = this._conn.BeginTransaction();
            foreach (object adapter in this._tableAdapters)
            {
                this.SetConnection(adapter, this._conn);
                this.SetTransactionAdapter(adapter, this._trans);
                this.SetTransactionCommands(adapter, this._trans);
            }
        }
        /// <summary>
        /// gUNVJn
        /// </summary>
        /// <param name="trans">gUNV</param>
        /// <remarks></remarks>
        public void BeginTransaction(SQLiteTransaction trans)
        {
            this._conn = trans.Connection;
            this._trans = trans;
            foreach (object adapter in this._tableAdapters)
            {
                this.SetConnection(adapter, this._conn);
                this.SetTransactionAdapter(adapter, this._trans);
                this.SetTransactionCommands(adapter, this._trans);
            }
        }
        #endregion
        #region "\bh - Commit                                 [gUNVR~bg]"
        /// <summary>
        /// gUNVR~bg
        /// </summary>
        /// <remarks></remarks>
        public void Commit()
        {
            try
            {
                this._trans.Commit();
            }
            catch (Exception ex)
            {
                this._trans.Rollback();
                throw ex;
            }
            finally
            {
                if ((this._conn.State == ConnectionState.Open))
                {
                    this._conn.Close();
                }
            }
        }
        #endregion
        #region "\bh - Rollback                               [gUNV[obN]"
        /// <summary>
        /// gUNV[obN
        /// </summary>
        /// <remarks></remarks>
        public void Rollback()
        {
            this._trans.Rollback();
            if ((this._conn.State == ConnectionState.Open))
            {
                this._conn.Close();
            }
        }
        #endregion
    }
}
