// Chattr - Twitter client on .NET
//
// Copyright (c) 2007-2009 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IGetTimeline.cs 169 2009-01-21 14:19:44Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

using System.Net;

namespace Chattr
{
    class IUpdate
    {
        string m_User;
        string m_Pass;
        string m_Status;
        long m_ReplyTo;
        HttpWebResponse m_Res;

        public IUpdate(string user, string pass, string status, long replyTo)
        {
            m_User = user;
            m_Pass = pass;
            m_Status = status;
            m_ReplyTo = replyTo;
            m_Res = null;
        }

        public string User
        {
            get
            {
                return m_User;
            }
        }

        public string Pass
        {
            get
            {
                return m_Pass;
            }
        }

        public string Status
        {
            get
            {
                return m_Status;
            }
        }

        public long ReplyTo
        {
            get
            {
                return m_ReplyTo;
            }
        }

        public HttpWebResponse Response
        {
            get
            {
                return m_Res;
            }
            set
            {
                m_Res = value;
            }
        }
    }
}
