// Chattr - Twitter client on .NET
//
// Copyright (c) 2007-2009 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: CListBox.cs 179 2009-01-22 17:09:07Z ichi $

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Chattr
{
    class CListBox : System.Windows.Forms.ListBox
    {
        private const int WM_VSCROLL = 0x115;
        private const int WM_KEYDOWN = 0x100;
        private const int VK_PRIOR = 0x21;
        private const int VK_NEXT = 0x22;
        private EventArgs e = new EventArgs();

        public event EventHandler Scroll;

        protected override void WndProc(ref System.Windows.Forms.Message m)
        {
            switch (m.Msg)
            {
                case WM_VSCROLL:
                    if (this.Scroll != null)
                    {
                        this.Scroll(this, e);
                    }
                    break;
                case WM_KEYDOWN:
                    break;
            }
            base.WndProc(ref m);
        }

        public void RaiseKey(Keys key)
        {
            IntPtr wParam = new IntPtr(VK_NEXT);
            if (key != Keys.PageDown)
            {
                wParam = new IntPtr(VK_PRIOR);
            }
            Message msg = Message.Create(this.Handle, WM_KEYDOWN, wParam, new IntPtr(1));
            this.WndProc(ref msg);
            //this.ProcessKeyMessage(ref msg);
        }
    }
}
