// Chattr - Twitter client on .NET
//
// Copyright (c) 2007, 2008 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Chattr
{
    public partial class FormPost : Form
    {
        FormMain m_FormMain;

        public FormPost(FormMain formMain)
        {
            InitializeComponent();
            m_FormMain = formMain;
        }

        public void InsertText(string text)
        {
            textBox.Text = text + textBox.Text;
            textBox.SelectionStart = textBox.Text.Length;
            textBox.SelectionLength = 0;
        }

        public void SetText(string text)
        {
            textBox.Text = text;
            textBox.SelectionStart = textBox.Text.Length;
            textBox.SelectionLength = 0;
        }

        public void ClearText()
        {
            textBox.Text = "";
        }

        public void EnableText()
        {
            textBox.Enabled = true;
        }

        private void FormPost_Load(object sender, EventArgs e)
        {
        }

        private void textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                if (textBox.Text != "")
                {
                    string text = m_FormMain.MakeStatusText(textBox.Text);
                    textBox.Enabled = false;
                    m_FormMain.UpdateStatus(text);
                }
                else
                {
                    Hide();
                }
                e.Handled = true;
            }
        }

        private void FormPost_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible)
            {
                Rectangle rect = Screen.PrimaryScreen.Bounds;
                int workHeight = Screen.GetWorkingArea(new Point(0, 0)).Height;
                int side = 0;
                if (Properties.Settings.Default.PopupSideBar)
                {
                    side += 150;
                }
                this.Location = new Point(rect.Width - this.Width - side, workHeight - this.Height);
            }
        }
    }
}