/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright (c) 2003-2007 by AG-Software 											 *
 * All Rights Reserved.																 *
 * Contact information for AG-Software is available at http://www.ag-software.de	 *
 *																					 *
 * Licence:																			 *
 * The agsXMPP SDK is released under a dual licence									 *
 * agsXMPP can be used under either of two licences									 *
 * 																					 *
 * A commercial licence which is probably the most appropriate for commercial 		 *
 * corporate use and closed source projects. 										 *
 *																					 *
 * The GNU Public License (GPL) is probably most appropriate for inclusion in		 *
 * other open source projects.														 *
 *																					 *
 * See README.html for details.														 *
 *																					 *
 * For general enquiries visit our website at:										 *
 * http://www.ag-software.de														 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

using System;
using System.Net;
using System.Globalization;

using agsXMPP.Xml.Dom;

namespace agsXMPP.protocol.extensions.jingle
{
    /*
     <candidate  name='rtp'
           protocol='udp'
           preference='1.0'
           username='/38UHtocC941jdS4' 
           password='pcd+Z/WmsthSFIcz'
           type='local'
           network='0'
           generation='0' 
           ip='10.1.1.104' 
           port=''
      />
    
     **********
     XML Schema
     **********
     <xs:element name="candidate">
     <xs:complexType>
      <xs:simpleContent>
        <xs:extension base="empty">
          <xs:attribute name="generation" type="xs:unsignedByte" use="required" />
          <xs:attribute name="ip" type="xs:string" use="required" />
          <xs:attribute name="name" type="xs:string" use="optional" />
          <xs:attribute name="network" type="xs:unsignedByte" use="required" />
          <xs:attribute name="password" type="xs:string" use="required" />
          <xs:attribute name="port" type="xs:short" use="required" />
          <xs:attribute name="preference" type="xs:decimal" use="required" />
          <xs:attribute name="protocol" use="required">
            <xs:simpleType>
              <xs:restriction base="xs:NCName">
                <xs:enumeration value="ssltcp" />
                <xs:enumeration value="tcp" />
                <xs:enumeration value="udp" />
              </xs:restriction>
            </xs:simpleType>
          </xs:attribute>
          <xs:attribute name="type" use="required">
            <xs:simpleType>
              <xs:restriction base="xs:NCName">
                <xs:enumeration value="local" />
                <xs:enumeration value="relay" />
                <xs:enumeration value="stun" />
              </xs:restriction>
            </xs:simpleType>
          </xs:attribute>
          <xs:attribute name="username" type="xs:string" use="required" />
        </xs:extension>
      </xs:simpleContent>
     </xs:complexType>
    */

    public class Candidate : Element
    {        
        public Candidate()
        {
            this.TagName    = "candidate";
            this.Namespace  = Uri.JINGLE;
        }

        /// <summary>
        /// Port (Required)
        /// </summary>
        public int Port
        {
            get { return GetAttributeInt("port"); }
            set { SetAttribute("port", value); }
        }

        /// <summary>
        /// Password (Required)
        /// </summary>
        public string Password
        {
            get { return GetAttribute("password"); }
            set { SetAttribute("password", value); }
        }

        /// <summary>
        /// Username (Required)
        /// </summary>
        public string Username
        {
            get { return GetAttribute("username"); }
            set { SetAttribute("username", value); }
        }

        /// <summary>
        /// Name (Optional)
        /// </summary>
        public string Name
        {
            get { return GetAttribute("name"); }
            set { SetAttribute("name", value); }
        }

        /// <summary>
        /// Network Protocol (Requrired)
        /// </summary>
        public Protocol Protocol
        {
            get
            {
                return (Protocol)GetAttributeEnum("protocol", typeof(Protocol));
            }
            set
            {
                SetAttribute("protocol", value.ToString());
            }
        }

        /// <summary>
        /// Type (Requrired)
        /// </summary>
        public Type Type
        {
            get
            {
                return (Type)GetAttributeEnum("type", typeof(Type));
            }
            set
            {
                SetAttribute("type", value.ToString());
            }
        }

        /// <summary>
        /// IP Address (required)
        /// </summary>
        public IPAddress Ip
        {
            get
            {
                try
                {
                    return IPAddress.Parse(GetAttribute("ip"));
                }
                catch
                {
                    return null;
                }
                
            }
            set
            {
                SetAttribute("ip", value.ToString());
            }
        }

        /// <summary>
        /// Generation (required)
        /// </summary>
        public Byte Generation
        {
            get
            {
                try
                {
                    Byte b = Byte.Parse(GetAttribute("generation"));
                    return b;
                }
                catch
                {
                    return 0;
                }
            }
            set { SetAttribute("generation", value.ToString()); }
        }

        /// <summary>
        /// Network (required)
        /// </summary>
        public Byte Network
        {
            get
            {
                try
                {
                    Byte b = Byte.Parse(GetAttribute("network"));
                    return b;
                }
                catch
                {
                    return 0;
                }
            }
            set { SetAttribute("network", value.ToString()); }
        }

        /// <summary>
        /// Preference (required)
        /// </summary>
        public double Preference
        {
            get
            {
                return  GetAttributeDouble("preference");
            }
            set
            {
                SetAttribute("preference", value);
            }
        }
    }
}
