// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Chattr
{
    public partial class FormPost : Form
    {
        FormMain m_FormMain;

        public FormPost(FormMain formMain)
        {
            InitializeComponent();
            m_FormMain = formMain;
        }

        public void InsertText(string text)
        {
            textBox.Text = text + textBox.Text;
            textBox.SelectionStart = textBox.Text.Length;
            textBox.SelectionLength = 0;
        }

        public void SetText(string text)
        {
            textBox.Text = text;
            textBox.SelectionStart = textBox.Text.Length;
            textBox.SelectionLength = 0;
        }

        public void ClearText()
        {
            textBox.Text = "";
        }

        public void EnableText()
        {
            textBox.Enabled = true;
        }

        private void FormPost_Load(object sender, EventArgs e)
        {
            Rectangle rect = Screen.PrimaryScreen.Bounds;
            int workHeight = Screen.GetWorkingArea(new Point(0, 0)).Height;
            this.Location = new Point(rect.Width - this.Width - 2, workHeight - this.Height - 2);
        }

        private void textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                if (textBox.Text != "")
                {
                    string text = m_FormMain.MakeStatusText(textBox.Text);
                    textBox.Enabled = false;
                    m_FormMain.UpdateStatus(text);
                }
                else
                {
                    Hide();
                }
                e.Handled = true;
            }
        }
    }
}