// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IGetProfileImage.cs 13 2007-10-04 16:00:35Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;
using System.ComponentModel;

namespace Chattr
{
    class IGetProfileImage : IGetHttp
    {
        DataSetChattrTableAdapters.TableStatusTableAdapter m_Status;
        DataSetChattrTableAdapters.TableProfileImageTableAdapter m_Adapter;
        DataSetChattr m_DataSet;
        BackgroundWorker m_Worker;
        Action<string> m_Request;
        Action<bool> m_Exit;
        MethodInvoker m_BeginUpdate;
        MethodInvoker m_EndUpdate;
        Action<int> m_Replase;

        public IGetProfileImage(string url, DataSetChattrTableAdapters.TableStatusTableAdapter status,
            DataSetChattrTableAdapters.TableProfileImageTableAdapter adapter,
            DataSetChattr dataSet, BackgroundWorker worker, Action<string> request, Action<bool> exit,
            MethodInvoker beginUpdate, MethodInvoker endUpdate, Action<int> replase
            )
            : base(url)
        {
            m_Status = status;
            m_Adapter = adapter;
            m_DataSet = dataSet;
            m_Worker = worker;
            m_Request = request;
            m_Exit = exit;
            m_BeginUpdate = beginUpdate;
            m_EndUpdate = endUpdate;
            m_Replase = replase;
        }

        public DataSetChattrTableAdapters.TableStatusTableAdapter Status
        {
            get
            {
                return m_Status;
            }
        }

        public DataSetChattrTableAdapters.TableProfileImageTableAdapter Adapter
        {
            get
            {
                return m_Adapter;
            }
        }

        public DataSetChattr DataSet
        {
            get
            {
                return m_DataSet;
            }
        }
        public BackgroundWorker Worker
        {
            get
            {
                return m_Worker;
            }
        }

        public Action<string> Request
        {
            get
            {
                return m_Request;
            }
        }

        public Action<bool> Exit
        {
            get
            {
                return m_Exit;
            }
        }

        public MethodInvoker BeginUpdate
        {
            get
            {
                return m_BeginUpdate;
            }
        }

        public MethodInvoker EndUpdate
        {
            get
            {
                return m_EndUpdate;
            }
        }

        public Action<int> Replase
        {
            get
            {
                return m_Replase;
            }
        }
    }
}
