// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: FormPreferences.cs 32 2007-10-29 06:51:19Z ichi $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Text.RegularExpressions;

namespace Chattr
{
    public partial class FormPreferences : Form
    {
        private string m_Password = "";
        private string m_XmppPass = "";
        private static string m_ProxyPass = "";

        private bool m_SmallIcon;
        private bool m_MultiLineForm;
        private bool m_NotEllipsis;
        private Font m_FontStatuses;
        private Font m_FontTime;

        ToolTip m_TipUserName;
        ToolTip m_TipPassword;
        ToolTip m_TipIntervalFriends;
        ToolTip m_TipIntervalReplies;
        ToolTip m_TipUseXMPP;
        ToolTip m_TipXmppID;
        ToolTip m_TipXmppPass;
        ToolTip m_TipXmppServer;
        ToolTip m_TipXmppPort;
        ToolTip m_TipXmppUseSSL;
        ToolTip m_TipProxyUseSystem;
        ToolTip m_TipUseProxy;
        ToolTip m_TipProxyAddr;
        ToolTip m_TipProxyPort;
        ToolTip m_TipProxyUser;
        ToolTip m_TipProxyPass;
        ToolTip m_TipUseBuiltinBrowser;
        ToolTip m_TipRetrieveStartup;
        ToolTip m_TipRefreshWithReplies;
        ToolTip m_TipNotifyTaskbar;
        ToolTip m_TipNotifyAll;
        ToolTip m_TipNotifyInMe;
        ToolTip m_TipNotifyKeywords;
        ToolTip m_TipTaskTrayIcon;
        ToolTip m_TipPopupAll;
        ToolTip m_TipPopupInMe;
        ToolTip m_TipPopupKeywords;
        ToolTip m_TipLogLimit;
        ToolTip m_TipLogDelete;
        ToolTip m_TipIndicateFrom;
        ToolTip m_TipSmallIcon;
        ToolTip m_TipMultiLineForm;
        ToolTip m_TipNotEllipsis;
        ToolTip m_TipUseSignature;
        ToolTip m_TipSignature;
        ToolTip m_TipFontStatuses;
        ToolTip m_TipFontTime;
        ToolTip m_TipColorText;
        ToolTip m_TipColorHighlightText;
        ToolTip m_TipColorBackground;
        ToolTip m_TipColorHighlight;
        ToolTip m_TipColorNewStatus;
        ToolTip m_TipColorInMe;
        ToolTip m_TipColorKeywords;
        ToolTip m_TipKeywords;

        FormMain m_FormMain;

        public string Password
        {
            get
            {
                return m_Password;
            }
        }

        public string XmppPass
        {
            get
            {
                return m_XmppPass;
            }
        }

        public string ProxyPass
        {
            get
            {
                return m_ProxyPass;
            }
        }

        public static string GetProxyPass()
        {
            return m_ProxyPass;
        }

        public FormPreferences(FormMain main)
        {
            m_FormMain = main;
            InitializeComponent();
            // General
            m_SmallIcon = Properties.Settings.Default.SmallIcon;
            m_MultiLineForm = Properties.Settings.Default.MultiLineForm;
            m_NotEllipsis = Properties.Settings.Default.NotEllipsis;
            // Font & Color
            m_FontStatuses = Properties.Settings.Default.FontStatuses;
            m_FontTime = Properties.Settings.Default.FontTime;
            // Help Account
            m_TipUserName = SetupTip(textBoxUserName, labelUsername);
            m_TipPassword = SetupTip(textBoxPassword, labelPassword);
            m_TipIntervalFriends = SetupTip(numericUpDownIntervalFriends, labelIntervalFriends);
            m_TipIntervalReplies = SetupTip(numericUpDownIntervalReplies, labelIntervalReplies);
            m_TipUseXMPP = SetupTip(checkBoxUseXMPP, checkBoxUseXMPP);
            m_TipXmppID = SetupTip(textBoxXmppID, labelXmppID);
            m_TipXmppPass = SetupTip(textBoxXmppPass, labelXmppPass);
            m_TipXmppServer = SetupTip(textBoxXmppServer, labelXmppServer);
            m_TipXmppPort = SetupTip(textBoxXmppPort, labelXmppPort);
            m_TipXmppUseSSL = SetupTip(checkBoxXmppUseSSL, checkBoxXmppUseSSL);
            // Help Network
            m_TipProxyUseSystem = SetupTip(radioButtonProxyUseSystem, radioButtonProxyUseSystem);
            m_TipUseProxy = SetupTip(radioButtonUseProxy, radioButtonUseProxy);
            m_TipProxyAddr = SetupTip(textBoxProxyAddr, labelProxyAddr);
            m_TipProxyPort = SetupTip(textBoxProxyPort, labelProxyPort);
            m_TipProxyUser = SetupTip(textBoxProxyUser, labelProxyUser);
            m_TipProxyPass = SetupTip(textBoxProxyPass, labelProxyPass);
            // Help Feature
            m_TipUseBuiltinBrowser = SetupTip(checkBoxUseBuiltinBrowser, checkBoxUseBuiltinBrowser);
            m_TipRetrieveStartup = SetupTip(checkBoxRetrieveStartup, checkBoxRetrieveStartup);
            m_TipRefreshWithReplies = SetupTip(checkBoxRefreshWithReplies, checkBoxRefreshWithReplies);
            m_TipNotifyTaskbar = SetupTip(checkBoxNotifyTaskbar, checkBoxNotifyTaskbar);
            m_TipNotifyAll = SetupTip(radioButtonAll, radioButtonAll);
            m_TipNotifyInMe = SetupTip(radioButtonInMe, radioButtonInMe);
            m_TipNotifyKeywords = SetupTip(radioButtonKeywords, radioButtonKeywords);
            m_TipTaskTrayIcon = SetupTip(checkBoxTaskTrayIcon, checkBoxTaskTrayIcon);
            m_TipPopupAll = SetupTip(radioButtonPopupAll, radioButtonPopupAll);
            m_TipPopupInMe = SetupTip(radioButtonPopupInMe, radioButtonPopupInMe);
            m_TipPopupKeywords = SetupTip(radioButtonPopupKeywords, radioButtonPopupKeywords);
            m_TipLogLimit = SetupTip(comboBoxLogLimit, labelLogLimit);
            m_TipLogDelete = SetupTip(buttonLogDelete, buttonLogDelete);
            m_TipSignature = SetupTip(textBoxSignature, checkBoxSignature);
            // Help Look&Feel
            m_TipIndicateFrom = SetupTip(checkBoxIndicateFrom, checkBoxIndicateFrom);
            m_TipSmallIcon = SetupTip(checkBoxSmallIcon, checkBoxSmallIcon);
            m_TipMultiLineForm = SetupTip(checkBoxMultiLineForm, checkBoxMultiLineForm);
            m_TipNotEllipsis = SetupTip(checkBoxNotEllipsis, checkBoxNotEllipsis);
            m_TipUseSignature = SetupTip(checkBoxSignature, checkBoxSignature);
            // Help Font & Color
            m_TipFontStatuses = SetupTip(buttonFontStatuses, labelFontStatuses);
            m_TipFontTime = SetupTip(buttonFontTime, labelFontTime);
            m_TipColorText = SetupTip(buttonColorText, labelColorText);
            m_TipColorHighlightText = SetupTip(buttonColorHighlightText, labelColorHighlightText);
            m_TipColorBackground = SetupTip(buttonColorBackground, labelColorBackground);
            m_TipColorHighlight = SetupTip(buttonColorHighlight, labelColorHighlight);
            m_TipColorNewStatus = SetupTip(buttonColorNewStatus, labelColorNewStatus);
            m_TipColorInMe = SetupTip(buttonColorInMe, labelColorInMe);
            m_TipColorKeywords = SetupTip(buttonColorKeywords, labelColorKeywords);
            // Help Keyword
            m_TipKeywords = SetupTip(textBoxKeywords, groupBoxKeywords);
        }

        private ToolTip SetupTip(Control control, Control title)
        {
            ToolTip toolTip = new ToolTip();
            toolTip.ToolTipTitle = Regex.Replace(Regex.Replace(title.Text, @"&", ""), @":", "");
            toolTip.SetToolTip(control, helpProvider.GetHelpString(control));
            return toolTip;
        }

        public void SetDialog()
        {
            // Account
            textBoxUserName.Text = Properties.Settings.Default.UserName;
            try
            {
                m_Password = Encoding.Unicode.GetString(Convert.FromBase64String(Properties.Settings.Default.Password));
            }
            catch (SystemException ex)
            {
                m_Password = "";
                Console.WriteLine("Convert.FromBase64String(Properties.Settings.Default.Password) Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
            textBoxPassword.Text = m_Password;
            numericUpDownIntervalFriends.Value = Properties.Settings.Default.IntervalFriends;
            numericUpDownIntervalReplies.Value = Properties.Settings.Default.IntervalReplies;
            checkBoxUseXMPP.Checked = Properties.Settings.Default.UseXmpp;
            textBoxXmppID.Text = Properties.Settings.Default.XmppID;
            try
            {
                m_XmppPass = Encoding.Unicode.GetString(Convert.FromBase64String(Properties.Settings.Default.XmppPass));
            }
            catch (SystemException ex)
            {
                m_XmppPass = "";
                Console.WriteLine("Convert.FromBase64String(Properties.Settings.Default.XmppPass) Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
            textBoxXmppPass.Text = m_XmppPass;
            textBoxXmppServer.Text = Properties.Settings.Default.XmppServer;
            textBoxXmppPort.Text = Properties.Settings.Default.XmppPort.ToString();
            checkBoxXmppUseSSL.Checked = Properties.Settings.Default.XmppUseSSL;
            // Network
            switch (Properties.Settings.Default.UseProxy)
            {
                case FormMain.PROXY_CHATTR:
                    radioButtonUseProxy.Checked = true;
                    break;
                default:
                    radioButtonProxyUseSystem.Checked = true;
                    break;
            }
            textBoxProxyAddr.Text = Properties.Settings.Default.ProxyAddr;
            try
            {
                if (Properties.Settings.Default.ProxyPort < 0)
                {
                    textBoxProxyPort.Text = "";
                }
                else
                {
                    textBoxProxyPort.Text = Properties.Settings.Default.ProxyPort.ToString();
                }
            }
            catch (SystemException ex)
            {
                textBoxProxyPort.Text = "";
                Console.WriteLine("Properties.Settings.Default.ProxyPort.ToString() Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
            textBoxProxyUser.Text = Properties.Settings.Default.ProxyUser;
            try
            {
                m_ProxyPass = Encoding.Unicode.GetString(Convert.FromBase64String(Properties.Settings.Default.ProxyPass));
            }
            catch (SystemException ex)
            {
                m_ProxyPass = "";
                Console.WriteLine("Convert.FromBase64String(Properties.Settings.Default.ProxyPass) Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
            textBoxProxyPass.Text = m_ProxyPass;
            // Feature
            checkBoxUseBuiltinBrowser.Checked = Properties.Settings.Default.UseBuiltinBrowser;
            checkBoxRetrieveStartup.Checked = Properties.Settings.Default.RetrieveStartup;
            checkBoxRefreshWithReplies.Checked = Properties.Settings.Default.RefreshWithReplies;
            checkBoxNotifyTaskbar.Checked = Properties.Settings.Default.NotifyTaskbar;
            switch (Properties.Settings.Default.NotifyTaskbarKind)
            {
                case FormMain.NOTIFY_INME:
                    radioButtonInMe.Checked = true;
                    break;
                case FormMain.NOTIFY_KEYWORDS:
                    radioButtonKeywords.Checked = true;
                    break;
                default:
                    radioButtonAll.Checked = true;
                    break;
            }
            checkBoxTaskTrayIcon.Checked = Properties.Settings.Default.TaskTrayIcon;
            switch (Properties.Settings.Default.PopupKind)
            {
                case FormMain.NOTIFY_INME:
                    radioButtonPopupAll.Checked = true;
                    break;
                case FormMain.NOTIFY_KEYWORDS:
                    radioButtonPopupKeywords.Checked = true;
                    break;
                default:
                    radioButtonPopupAll.Checked = true;
                    break;
            }
            if (Properties.Settings.Default.LogLimit < comboBoxLogLimit.Items.Count)
            {
                comboBoxLogLimit.SelectedIndex = Properties.Settings.Default.LogLimit;
            }
            else
            {
                comboBoxLogLimit.SelectedIndex = 0;
            }
            checkBoxSignature.Checked = Properties.Settings.Default.UseSignature;
            textBoxSignature.Text = Properties.Settings.Default.Signature;
            // Look & Feel
            checkBoxIndicateFrom.Checked = Properties.Settings.Default.IndicateFrom;
            checkBoxSmallIcon.Checked = m_SmallIcon;
            checkBoxMultiLineForm.Checked = m_MultiLineForm;
            checkBoxNotEllipsis.Checked = m_NotEllipsis;
            // Font & Color
            SetButtonFont(buttonFontStatuses, m_FontStatuses);
            SetButtonFont(buttonFontTime, m_FontTime);
            SetButtonColor(buttonColorText, Properties.Settings.Default.ColorText);
            SetButtonColor(buttonColorHighlightText, Properties.Settings.Default.ColorHighlight);
            SetButtonColor(buttonColorBackground, Properties.Settings.Default.BgColor);
            SetButtonColor(buttonColorHighlight, Properties.Settings.Default.BgColorHighlight);
            SetButtonColor(buttonColorNewStatus, Properties.Settings.Default.BgColorNew);
            SetButtonColor(buttonColorInMe, Properties.Settings.Default.BgColorInMe);
            SetButtonColor(buttonColorKeywords, Properties.Settings.Default.BgColorKeywords);
            // Keywords
            textBoxKeywords.Text = Properties.Settings.Default.Keywords;
        }

        public void GetDialog()
        {
            // Account
            Properties.Settings.Default.UserName = textBoxUserName.Text;
            m_Password =  textBoxPassword.Text;
            Properties.Settings.Default.Password = Convert.ToBase64String(Encoding.Unicode.GetBytes(m_Password));
            Properties.Settings.Default.IntervalFriends = Convert.ToInt32(numericUpDownIntervalFriends.Value);
            Properties.Settings.Default.IntervalReplies = Convert.ToInt32(numericUpDownIntervalReplies.Value);
            Properties.Settings.Default.UseXmpp = checkBoxUseXMPP.Checked;
            Properties.Settings.Default.XmppID = textBoxXmppID.Text;
            m_XmppPass = textBoxXmppPass.Text;
            Properties.Settings.Default.XmppPass = Convert.ToBase64String(Encoding.Unicode.GetBytes(m_XmppPass));
            Properties.Settings.Default.XmppServer = textBoxXmppServer.Text;
            Properties.Settings.Default.XmppPort = int.Parse(textBoxXmppPort.Text);
            Properties.Settings.Default.XmppUseSSL = checkBoxXmppUseSSL.Checked;
            // Network
            if (radioButtonProxyUseSystem.Checked)
            {
                Properties.Settings.Default.UseProxy = FormMain.PROXY_SYSTEM;
            }
            else
            {
                Properties.Settings.Default.UseProxy = FormMain.PROXY_CHATTR;
            }
            Properties.Settings.Default.ProxyAddr = textBoxProxyAddr.Text;
            if (textBoxProxyPort.Text == "")
            {
                Properties.Settings.Default.ProxyPort = -1;
            }
            else
            {
                Properties.Settings.Default.ProxyPort = Convert.ToInt32(textBoxProxyPort.Text);
            }
            Properties.Settings.Default.ProxyUser = textBoxProxyUser.Text;
            m_ProxyPass = textBoxProxyPass.Text;
            Properties.Settings.Default.ProxyPass = Convert.ToBase64String(Encoding.Unicode.GetBytes(m_ProxyPass));
            // Feature
            Properties.Settings.Default.UseBuiltinBrowser = checkBoxUseBuiltinBrowser.Checked;
            Properties.Settings.Default.RetrieveStartup = checkBoxRetrieveStartup.Checked;
            Properties.Settings.Default.RefreshWithReplies = checkBoxRefreshWithReplies.Checked;
            Properties.Settings.Default.NotifyTaskbar = checkBoxNotifyTaskbar.Checked;
            if (radioButtonAll.Checked)
            {
                Properties.Settings.Default.NotifyTaskbarKind = FormMain.NOTIFY_ALL;
            }
            else if (radioButtonInMe.Checked)
            {
                Properties.Settings.Default.NotifyTaskbarKind = FormMain.NOTIFY_INME;
            }
            else
            {
                Properties.Settings.Default.NotifyTaskbarKind = FormMain.NOTIFY_KEYWORDS;
            }
            Properties.Settings.Default.TaskTrayIcon = checkBoxTaskTrayIcon.Checked;
            if (radioButtonPopupAll.Checked)
            {
                Properties.Settings.Default.PopupKind = FormMain.NOTIFY_ALL;
            }
            else if (radioButtonPopupInMe.Checked)
            {
                Properties.Settings.Default.PopupKind = FormMain.NOTIFY_INME;
            }
            else if (radioButtonPopupKeywords.Checked)
            {
                Properties.Settings.Default.PopupKind = FormMain.NOTIFY_KEYWORDS;
            }
            Properties.Settings.Default.LogLimit = comboBoxLogLimit.SelectedIndex;
            Properties.Settings.Default.UseSignature = checkBoxSignature.Checked;
            Properties.Settings.Default.Signature = textBoxSignature.Text;
            // Look & Feel
            Properties.Settings.Default.IndicateFrom = checkBoxIndicateFrom.Checked;
            m_SmallIcon = checkBoxSmallIcon.Checked;
            m_MultiLineForm = checkBoxMultiLineForm.Checked;
            m_NotEllipsis = checkBoxNotEllipsis.Checked;
            // Font & Color
            m_FontStatuses = buttonFontStatuses.Font;
            m_FontTime = buttonFontTime.Font;
            Properties.Settings.Default.ColorText = buttonColorText.ForeColor;
            Properties.Settings.Default.ColorHighlight = buttonColorHighlightText.ForeColor;
            Properties.Settings.Default.BgColor = buttonColorBackground.ForeColor;
            Properties.Settings.Default.BgColorHighlight = buttonColorHighlight.ForeColor;
            Properties.Settings.Default.BgColorNew = buttonColorNewStatus.ForeColor;
            Properties.Settings.Default.BgColorInMe = buttonColorInMe.ForeColor;
            Properties.Settings.Default.BgColorKeywords = buttonColorKeywords.ForeColor;
            // Keywords
            Properties.Settings.Default.Keywords = textBoxKeywords.Text;
        }

        public void Save()
        {
            // General
            Properties.Settings.Default.SmallIcon = m_SmallIcon;
            Properties.Settings.Default.MultiLineForm = m_MultiLineForm;
            Properties.Settings.Default.NotEllipsis = m_NotEllipsis;
            // Font & Color
            Properties.Settings.Default.FontStatuses = m_FontStatuses;
            Properties.Settings.Default.FontTime = m_FontTime;

            Properties.Settings.Default.Save();
        }

        private void SetButtonFont(Button button, Font font)
        {
            button.Text = font.Name + " " + font.Size + "pt";
            button.Font = font;
        }

        private void SetButtonColor(Button button, Color color)
        {
            int width = button.Width / 2;
            int height = button.Height / 2 + 1;
            Bitmap bmp = new Bitmap(width, height);
            Graphics graph = Graphics.FromImage(bmp);
            graph.FillRectangle(new SolidBrush(color), new Rectangle(0, 0, width, height));
            graph.DrawRectangle(new Pen(Color.FromKnownColor(KnownColor.Black)), new Rectangle(0, 0, width-1, height-1));
            button.Image = bmp;
            button.Text = "";
            button.ForeColor = color;
        }

        private void FormPreferences_Load(object sender, EventArgs e)
        {
            labelVersion.Text = "Version " + Application.ProductVersion + "";
        }

        private void buttonFontStatuses_Click(object sender, EventArgs e)
        {
            fontDialog.Font = buttonFontStatuses.Font;
            if (fontDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonFont(buttonFontStatuses, fontDialog.Font);
            }
        }

        private void buttonFontTime_Click(object sender, EventArgs e)
        {
            fontDialog.Font = buttonFontTime.Font;
            if (fontDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonFont(buttonFontTime, fontDialog.Font);
            }
        }

        private void buttonColorText_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.ColorText;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorText, colorDialog.Color);
            }
        }

        private void buttonColorHighlightText_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.ColorHighlight;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorHighlightText, colorDialog.Color);
            }
        }

        private void buttonColorBackground_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.BgColor;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorBackground, colorDialog.Color);
            }
        }

        private void buttonColorHighlight_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.BgColorHighlight;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorHighlight, colorDialog.Color);
            }
        }

        private void buttonColorNewStatus_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.BgColorNew;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorNewStatus, colorDialog.Color);
            }
        }

        private void buttonColorInMe_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.BgColorInMe;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorInMe, colorDialog.Color);
            }
        }

        private void buttonColorKeywords_Click(object sender, EventArgs e)
        {
            colorDialog.Color = Properties.Settings.Default.BgColorKeywords;
            if (colorDialog.ShowDialog() == DialogResult.OK)
            {
                SetButtonColor(buttonColorKeywords, colorDialog.Color);
            }
        }

        private void textBoxXmppServer_Enter(object sender, EventArgs e)
        {
            if (textBoxXmppServer.Text == "")
            {
                if (new Regex(@"@gmail\.com$").Match(textBoxXmppID.Text).Success)
                {
                    textBoxXmppServer.Text = "talk.google.com";
                }
            }
        }

        private void linkLabelSourceForge_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            m_FormMain.Navigate(linkLabelSourceForge.Text);
        }

        private void linkLabelKichi_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            m_FormMain.Navigate(linkLabelKichi.Text);
        }

        private void linkLabelMinami_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            m_FormMain.Navigate(linkLabelMinami.Text);
        }

        private void radioButtonAll_Click(object sender, EventArgs e)
        {
            if (!radioButtonAll.Checked)
            {
                radioButtonAll.Checked = true;
                radioButtonInMe.Checked = false;
                radioButtonKeywords.Checked = false;
            }
        }

        private void radioButtonInMe_Click(object sender, EventArgs e)
        {
            if (!radioButtonInMe.Checked)
            {
                radioButtonAll.Checked = false;
                radioButtonInMe.Checked = true;
                radioButtonKeywords.Checked = false;
            }
        }

        private void radioButtonKeywords_Click(object sender, EventArgs e)
        {
            if (!radioButtonKeywords.Checked)
            {
                radioButtonAll.Checked = false;
                radioButtonInMe.Checked = false;
                radioButtonKeywords.Checked = true;
            }
        }

        private void radioButtonPopupAll_Click(object sender, EventArgs e)
        {
            if (!radioButtonPopupAll.Checked)
            {
                radioButtonPopupAll.Checked = true;
                radioButtonPopupInMe.Checked = false;
                radioButtonPopupKeywords.Checked = false;
            }
        }

        private void radioButtonPopupInMe_Click(object sender, EventArgs e)
        {
            if (!radioButtonPopupInMe.Checked)
            {
                radioButtonPopupAll.Checked = false;
                radioButtonPopupInMe.Checked = true;
                radioButtonPopupKeywords.Checked = false;
            }
        }

        private void radioButtonPopupKeywords_Click(object sender, EventArgs e)
        {
            if (!radioButtonPopupKeywords.Checked)
            {
                radioButtonPopupAll.Checked = false;
                radioButtonPopupInMe.Checked = false;
                radioButtonPopupKeywords.Checked = true;
            }
        }

        private void buttonLogDelete_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("OSč폜܂H", "O폜", MessageBoxButtons.YesNo, MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button2) == DialogResult.Yes)
            {
                m_FormMain.DeleteLog();
            }
        }
    }
}